/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionBillUpdatePositions
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", -1);
        String positions = this.getParameter("positions");
        if (id <= 0 || this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        try (BillManager billManager = new BillManager(this.con, this.mid);){
            BillDoc doc;
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionBillUpdatePositions", (int)this.mid, (int)this.userId);
            if (closedDate != null && (doc = billManager.getBillDocInfo(id)) != null) {
                LocalDate month = LocalDate.of(doc.getYy(), doc.getMm() + 1, 1);
                ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (LocalDate)month, (LocalDate)month);
            }
            if ("updateNumber".equals(this.getParameter("mode"))) {
                int year;
                int number = this.getIntParameter("number", -1);
                int numberInYear = this.getIntParameter("number_in_year", -1);
                int numberInMonth = this.getIntParameter("number_in_month", -1);
                Calendar date = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date", null));
                if (number <= 0 || numberInMonth <= 0 || numberInYear <= 0) {
                    throw new BGMessageException("\u041d\u043e\u043c\u0435\u0440\u0430 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f.");
                }
                if (date == null) {
                    throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0434\u0430\u0442\u0443 \u0432\u044b\u043f\u0438\u0441\u043a\u0438.");
                }
                int month = this.getIntParameter("mm", 0);
                String message = billManager.updateNumber(id, number, numberInYear, numberInMonth, date, month, year = this.getIntParameter("yy", 0));
                if (Utils.notBlankString((String)message)) {
                    this.setMsg(message);
                }
            } else {
                if (Utils.isEmptyString((String)positions)) {
                    throw new BGIllegalArgumentException();
                }
                billManager.updatePositions(id, positions, null);
            }
        }
        catch (BGException bx) {
            throw new BGMessageException(bx.getMessage());
        }
    }
}

