/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean.counter;

import java.math.BigDecimal;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import ru.bitel.bgbilling.modules.bill.server.bean.counter.Counter;
import ru.bitel.common.Utils;

public class RSCMCounter
extends Counter {
    @Override
    public BigDecimal count(String function, Connection con, String cid, Calendar month, List<String> paramList) {
        BigDecimal result = BigDecimal.ZERO;
        if (function.equals("SERVICE_AMOUNT")) {
            result = this.getAmount(con, "rscm_service_account", "amount", paramList, month, cid, null, "cid", "sid");
        }
        return result;
    }

    @Override
    protected BigDecimal getAmount(Connection con, String table, String col, List<String> paramList, Calendar month, String cids, String filter, String cidFieldName, String sidFieldName) {
        BigDecimal result = BigDecimal.ZERO;
        try {
            if (paramList.size() >= 3) {
                int mid = this.getIntParam(paramList, 0);
                month = this.getMonthParam(month, paramList, 1);
                month.set(5, 1);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                StringBuilder filterWithPeriod = new StringBuilder((String)(filter == null ? "" : filter + " AND ")).append("`date`>='").append(dateFormat.format(month.getTime())).append("' AND `date`<'");
                month.add(2, 1);
                filterWithPeriod.append(dateFormat.format(month.getTime())).append("'");
                long divisor = Utils.parseLong((String)paramList.get(2), (long)1L);
                String sids = this.getIdsFromEnd(3, paramList);
                String tableName = table + "_" + mid;
                long subresult = this.getSumFromTable(con, tableName, col, cids, sids, filterWithPeriod.toString(), cidFieldName, sidFieldName);
                result = divisor > 0L ? BigDecimal.valueOf((double)subresult / (double)divisor) : BigDecimal.valueOf(subresult);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

