/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean.extractor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.modules.bill.server.bean.ExtractorPositionValue;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionValue;
import ru.bitel.bgbilling.modules.bill.server.bean.extractor.Extractor;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;

public class RSCMExtractor
extends Extractor {
    @Override
    public List<PositionValue> extract(String function, Connection con, String cids, Calendar month, List<String> paramList, String posName) {
        ArrayList<PositionValue> result = new ArrayList<PositionValue>();
        try {
            if (!this.serviceSimple(result, function, con, cids, month, paramList)) {
                this.serviceExtended(result, function, con, cids, month, paramList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean serviceSimple(List<PositionValue> result, String function, Connection con, String cids, Calendar month, List<String> paramList) {
        try {
            boolean services = function.equals("SERVICES");
            boolean servicesExcept = function.equals("SERVICES_EXCEPT");
            if ((services || servicesExcept) && paramList.size() > 1) {
                String table;
                int mid = this.getIntParam(paramList, 0);
                month = this.getMonthParam(month, paramList, 1);
                String sids = null;
                if (paramList.size() > 2) {
                    sids = Utils.toString(paramList, (int)2);
                }
                if (ServerUtils.tableExists((Connection)con, (String)(table = "rscm_service_account_" + mid))) {
                    int sid;
                    HashMap<Integer, BigDecimal> serviceQuantity = new HashMap<Integer, BigDecimal>();
                    String query = "SELECT * FROM " + table + " WHERE cid IN (" + cids + ") AND date>=? AND date<?";
                    if (Utils.notBlankString((String)sids)) {
                        query = services ? query + " AND sid IN (" + sids + ")" : query + " AND sid NOT IN (" + sids + ")";
                    }
                    PreparedStatement ps = con.prepareStatement(query);
                    Calendar calendar = (Calendar)month.clone();
                    calendar.set(5, 1);
                    ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)calendar));
                    calendar.add(2, 1);
                    ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)calendar));
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        sid = rs.getInt("sid");
                        BigDecimal quantity = rs.getBigDecimal("amount");
                        BigDecimal currentQuantity = (BigDecimal)serviceQuantity.get(sid);
                        if (currentQuantity == null) {
                            currentQuantity = BigDecimal.ZERO;
                        }
                        currentQuantity = currentQuantity.add(quantity);
                        serviceQuantity.put(sid, currentQuantity);
                    }
                    rs.close();
                    ps.close();
                    query = "SELECT ca.sid, SUM(ca.summa) AS summ, service.title, rscm.unit FROM contract_account AS ca INNER JOIN service ON ca.sid=service.id AND service.mid=?  LEFT JOIN rscm_service_" + mid + " as rscm ON rscm.sid = service.id WHERE cid IN (" + cids + ") AND ca.yy=? AND ca.mm=?";
                    if (Utils.notBlankString((String)sids)) {
                        query = services ? query + " AND ca.sid IN ( " + sids + " )" : query + " AND ca.sid NOT IN ( " + sids + " )";
                    }
                    query = query + " GROUP BY ca.sid HAVING summ>0";
                    ps = con.prepareStatement(query);
                    ps.setInt(1, mid);
                    ps.setInt(2, month.get(1));
                    ps.setInt(3, month.get(2) + 1);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        sid = rs.getInt(1);
                        BigDecimal summa = Utils.roundBigDecimalSumm((BigDecimal)rs.getBigDecimal(2));
                        String title = rs.getString(3);
                        String unit = rs.getString(4);
                        BigDecimal quantity = (BigDecimal)serviceQuantity.get(sid);
                        if (quantity == null) {
                            quantity = BigDecimal.ZERO;
                        }
                        ExtractorPositionValue value = new ExtractorPositionValue();
                        value.setSum(summa);
                        value.setName(title);
                        value.setQuantity(quantity);
                        value.setUnit(unit);
                        value.setSid(sid);
                        value.setMid(mid);
                        result.add(value);
                    }
                    rs.close();
                    ps.close();
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean serviceExtended(List<PositionValue> result, String function, Connection con, String cids, Calendar month, List<String> paramList) {
        try {
            boolean services = function.equals("SERVICES_EXT");
            boolean servicesExcept = function.equals("SERVICES_EXT_EXCEPT");
            if ((services || servicesExcept) && paramList.size() > 1) {
                String table;
                int mid = this.getIntParam(paramList, 0);
                month = this.getMonthParam(month, paramList, 1);
                String sids = null;
                if (paramList.size() > 2) {
                    sids = Utils.toString(paramList, (int)2);
                }
                if (ServerUtils.tableExists((Connection)con, (String)(table = "rscm_service_account_" + mid))) {
                    int sid;
                    HashMap<Integer, Pair> serviceQuantity = new HashMap<Integer, Pair>();
                    String query = "SELECT * FROM " + table + " WHERE cid IN (" + cids + ") AND date>=? AND date<?";
                    if (Utils.notBlankString((String)sids)) {
                        query = services ? query + " AND sid IN (" + sids + ")" : query + " AND sid NOT IN (" + sids + ")";
                    }
                    PreparedStatement ps = con.prepareStatement(query);
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.set(5, 1);
                    ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)calendar));
                    ((Calendar)calendar).add(2, 1);
                    ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)calendar));
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        sid = rs.getInt("sid");
                        BigDecimal quantity = rs.getBigDecimal("amount");
                        String comment = rs.getString("comment");
                        Pair pair = (Pair)serviceQuantity.get(sid);
                        if (pair == null) {
                            pair = new Pair(new ArrayList(), (Object)BigDecimal.ZERO);
                            serviceQuantity.put(sid, pair);
                        }
                        List soForSid = (List)pair.getFirst();
                        RSCMService current = new RSCMService();
                        current.quantity = quantity;
                        current.comment = comment;
                        soForSid.add(current);
                        pair.setSecond((Object)((BigDecimal)pair.getSecond()).add(quantity));
                    }
                    rs.close();
                    ps.close();
                    query = "SELECT ca.sid, SUM(ca.summa) AS summ, service.title, rscm.unit FROM contract_account AS ca INNER JOIN service ON ca.sid=service.id AND service.mid=?  LEFT JOIN rscm_service_" + mid + " as rscm ON rscm.sid = service.id WHERE cid IN (" + cids + ") AND ca.yy=? AND ca.mm=?";
                    if (Utils.notBlankString((String)sids)) {
                        query = services ? query + " AND ca.sid IN ( " + sids + " )" : query + " AND ca.sid NOT IN ( " + sids + " )";
                    }
                    query = query + " GROUP BY ca.sid HAVING summ>0";
                    ps = con.prepareStatement(query);
                    ps.setInt(1, mid);
                    ps.setInt(2, month.get(1));
                    ps.setInt(3, month.get(2) + 1);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        sid = rs.getInt(1);
                        BigDecimal summa = Utils.roundBigDecimalSumm((BigDecimal)rs.getBigDecimal(2));
                        String title = rs.getString(3);
                        String unit = rs.getString(4);
                        Pair pair = (Pair)serviceQuantity.get(sid);
                        BigDecimal costPerPay = summa.divide((BigDecimal)pair.getSecond(), 20, RoundingMode.HALF_DOWN);
                        for (RSCMService so : (List)pair.getFirst()) {
                            ExtractorPositionValue value = new ExtractorPositionValue();
                            value.setSum(costPerPay.multiply(so.quantity));
                            value.setName(this.makeTitle(title, so.comment));
                            value.setQuantity(so.quantity);
                            value.setSid(sid);
                            value.setMid(mid);
                            value.setUnit(unit);
                            result.add(value);
                        }
                    }
                    rs.close();
                    ps.close();
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private class RSCMService {
        public BigDecimal quantity;
        public String comment;

        private RSCMService() {
        }
    }
}

