/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.task;

import bitel.billing.server.util.MailMsg;
import java.sql.Connection;
import javax.mail.Multipart;
import javax.mail.internet.MimeMultipart;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.modules.bill.server.bean.EmailMaster;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class BillDocsSender
extends RunTask {
    private int mid;
    private String type;
    private String codes;
    private int userId;

    public BillDocsSender(int mid, String type, String codes, int userId) {
        this.mid = mid;
        this.type = type;
        this.codes = codes;
        this.userId = userId;
    }

    public String getDescription() {
        String doc = "bill".equals(this.type) ? " \u0441\u0447\u0435\u0442\u0430." : " \u0441\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0430\u043a\u0442\u044b, \u0423\u041f\u0414.";
        return "\u041c\u043e\u0434\u0443\u043b\u044c Bill. \u0417\u0430\u0434\u0430\u0447\u0430 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.mid + " \u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b: " + doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            this.log.debug("type=>" + this.type + " codes=>" + this.codes);
            EmailMaster emailMaster = new EmailMaster(this.setup, con, this.mid, this.userId);
            int countSend = 0;
            int countAll = 0;
            for (Integer id : Utils.toIntegerList((String)this.codes)) {
                ++countAll;
                try {
                    MimeMultipart multipart = new MimeMultipart();
                    emailMaster.setDocumentId(this.type, id);
                    emailMaster.setContractId(-1);
                    emailMaster.addMessage((Multipart)multipart);
                    emailMaster.addAttach((Multipart)multipart);
                    new MailMsg((Preferences)this.setup).sendMessage(emailMaster.getEmail(), emailMaster.getSubject(), (Multipart)multipart);
                    ++countSend;
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
            this.log.info("Send " + countSend + " of " + countAll);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }
}

