/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.integration;

import bitel.billing.module.contract.ContractEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.bill.client.integration.BasePanel;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class TinkoffPanel
extends BasePanel {
    private JSONObject json = null;
    private JToggleButton outButton = new JToggleButton("\u0438\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0435");
    private JToggleButton internalButton = new JToggleButton("\u0432\u043d\u0443\u0442\u0440\u0435\u043d\u0438\u0435");
    private InfoPanel infoPanel = new InfoPanel();
    private JList<JSONObject> operationList = new JList();

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getFilterPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.getOperationPanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    protected JPanel getOperationPanel() {
        this.operationList.setCellRenderer(new OperationListCellRenderer());
        this.operationList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JSONObject json;
                if (mouseEvent.getClickCount() == 2 && (json = TinkoffPanel.this.operationList.getSelectedValue()) != null) {
                    JTextArea message = new JTextArea(30, 70);
                    message.setMargin(new Insets(3, 3, 3, 3));
                    message.setEditable(false);
                    message.setText(json.toString(2));
                    JList<Object> contractList = new JList<Object>();
                    contractList.setCellRenderer(new ContractListCellRenderer());
                    contractList.setSelectionMode(0);
                    try {
                        DefaultListModel contractModel = new DefaultListModel();
                        new JSONArray(TinkoffPanel.this.getBillIntegrationService().contractListByInn(json.optString("payerInn"))).forEach(a -> contractModel.addElement((JSONObject)a));
                        contractList.setModel(contractModel);
                    }
                    catch (Exception e2) {
                        ClientUtils.showErrorMessageDialog((Throwable)e2);
                    }
                    Dimension dimension = new Dimension(200, 150);
                    JScrollPane contractPane = new JScrollPane(contractList);
                    contractPane.setMinimumSize(dimension);
                    contractPane.setPreferredSize(dimension);
                    JList<Object> billList = new JList<Object>();
                    billList.setCellRenderer(new ContractListCellRenderer());
                    billList.setSelectionMode(0);
                    try {
                        DefaultListModel billModel = new DefaultListModel();
                        billList.setModel(billModel);
                    }
                    catch (Exception e3) {
                        ClientUtils.showErrorMessageDialog((Throwable)e3);
                    }
                    int gridy = 0;
                    JPanel contractBillPanel = new JPanel(new GridBagLayout());
                    contractBillPanel.add((Component)new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 3, 5), 0, 0));
                    contractBillPanel.add((Component)contractPane, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
                    contractBillPanel.add((Component)new JLabel("\u0421\u0447\u0435\u0442\u0430:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 3, 5), 0, 0));
                    contractBillPanel.add((Component)new JScrollPane(billList), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
                    JTabbedPane tabbedPane = new JTabbedPane();
                    tabbedPane.add((Component)contractBillPanel, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440, \u0441\u0447\u0435\u0442");
                    tabbedPane.add((Component)new JScrollPane(message), "\u0414\u0430\u043d\u043d\u044b\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438");
                    String initValue = "\u0417\u0430\u043a\u0440\u044b\u0442\u044c";
                    JButton openContractButton = new JButton("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
                    openContractButton.setEnabled(false);
                    JButton billButton = new JButton("\u0421\u0447\u0435\u0442 \u043e\u043f\u043b\u0430\u0447\u0435\u043d");
                    billButton.setEnabled(false);
                    JOptionPane pane = new JOptionPane(tabbedPane, 1, 0, null, new Object[]{openContractButton, billButton, initValue}, initValue);
                    contractList.addListSelectionListener(e -> ((JButton)pane.getOptions()[0]).setEnabled(contractList.getSelectedIndices().length > 0));
                    JDialog dialog = pane.createDialog((Component)((Object)TinkoffPanel.this), "\u041e\u043f\u0435\u0440\u0438\u0446\u0438\u044f");
                    pane.selectInitialValue();
                    openContractButton.addActionListener(e -> {
                        dialog.setVisible(false);
                        BGClientBase.getFrame().getTabbedPane().addTab((BGTabPanel)new ContractEditor(((JSONObject)contractList.getSelectedValue()).optInt("id")));
                    });
                    dialog.setVisible(true);
                    dialog.dispose();
                }
            }
        });
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getControlPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.operationList), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    protected JPanel getInfoPanel() {
        return this.infoPanel;
    }

    private JPanel getControlPanel() {
        BGButton loadButton = new BGButton("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c");
        loadButton.addActionListener(e -> {
            if (this.accountList.getSelectedValue() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0447\u0435\u0442");
                return;
            }
            try {
                this.json = new JSONObject(this.getBillIntegrationService().tinkoffBankStatement(((IdTitle)this.accountList.getSelectedValue()).getTitle(), this.periodNavigation.getPeriod()));
                this.infoPanel.saldoIn.setText(Utils.formatCostByGrouping((BigDecimal)this.json.optBigDecimal("saldoIn", BigDecimal.ZERO), (int)3, (int)2));
                this.infoPanel.income.setText(Utils.formatCostByGrouping((BigDecimal)this.json.optBigDecimal("income", BigDecimal.ZERO), (int)3, (int)2));
                this.infoPanel.outcome.setText(Utils.formatCostByGrouping((BigDecimal)this.json.optBigDecimal("outcome", BigDecimal.ZERO), (int)3, (int)2));
                this.infoPanel.saldoOut.setText(Utils.formatCostByGrouping((BigDecimal)this.json.optBigDecimal("saldoOut", BigDecimal.ZERO), (int)3, (int)2));
                this.setFilter();
            }
            catch (Exception e1) {
                ClientUtils.showErrorMessageDialog((Throwable)e1);
            }
        });
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)loadButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u044c:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.outButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.internalButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private void setFilter() {
        JSONArray operation = this.json.optJSONArray("operation");
        DefaultListModel listModel = new DefaultListModel();
        operation.forEach(a -> {
            JSONObject operationJson = (JSONObject)a;
            if (this.internalButton.isSelected() && operationJson.optString("payerInn").equals(operationJson.optString("recipientInn"))) {
                return;
            }
            if (this.outButton.isSelected() && operationJson.optString("payerAccount").equals(((IdTitle)this.accountList.getSelectedValue()).getTitle())) {
                return;
            }
            listModel.addElement(operationJson);
        });
        this.operationList.setModel(listModel);
    }

    class InfoPanel
    extends JPanel {
        private InfoTextField saldoIn;
        private InfoTextField income;
        private InfoTextField outcome;
        private InfoTextField saldoOut;

        InfoPanel() {
            this.saldoIn = new InfoTextField(10);
            this.income = new InfoTextField(10);
            this.outcome = new InfoTextField(10);
            this.saldoOut = new InfoTextField(10);
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel("C\u0430\u043b\u044c\u0434\u043e:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel("\u0412\u0445\u043e\u0434\u044f\u0449\u0435\u0435:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.saldoIn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel("\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0435\u0435:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.saldoOut, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel("\u041f\u043e\u0441\u0442\u0443\u043f\u043b\u0435\u043d\u0438\u0439:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.income, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel("\u0421\u043f\u0438\u0441\u0430\u043d\u0438\u0439:"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.outcome, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    class OperationListCellRenderer
    implements ListCellRenderer<JSONObject> {
        OperationListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JSONObject> list, JSONObject value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel payerNameLabel = new JLabel(value.optString("payerName"));
            payerNameLabel.setForeground(new Color(50, 50, 50));
            payerNameLabel.setFont(new Font("DialogInput", 1, 17));
            JLabel payerInnLabel = new JLabel("\u0418\u041d\u041d: " + value.optString("payerInn"));
            payerInnLabel.setForeground(new Color(150, 150, 150));
            payerInnLabel.setFont(new Font("DialogInput", 1, 12));
            JLabel paymentPurposeLabel = new JLabel(value.optString("paymentPurpose"));
            paymentPurposeLabel.setForeground(new Color(50, 50, 50));
            paymentPurposeLabel.setFont(new Font("SansSerif", 2, 12));
            JLabel sumLabel = new JLabel(Utils.formatCostByGrouping((BigDecimal)value.optBigDecimal("amount", BigDecimal.ZERO), (int)3, (int)2));
            sumLabel.setForeground(Color.DARK_GRAY);
            sumLabel.setFont(new Font("Dialog", 1, 16));
            Object date = value.optString("date");
            date = ((String)date).substring(8) + ((String)date).substring(4, 8) + ((String)date).substring(0, 4);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            panel.add((Component)new JLabel((String)date), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            panel.add((Component)payerNameLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 20, 0, 3), 0, 0));
            panel.add((Component)payerInnLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 20, 0, 3), 0, 0));
            panel.add((Component)paymentPurposeLabel, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 3), 0, 0));
            panel.add((Component)sumLabel, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 20, 0, 3), 0, 0));
            return panel;
        }
    }

    class InfoTextField
    extends JTextField {
        InfoTextField(int column) {
            super(column);
            this.setHorizontalAlignment(4);
            Color bgColor = this.getBackground();
            this.setEditable(false);
            this.setBackground(bgColor);
        }
    }

    class ContractListCellRenderer
    implements ListCellRenderer<JSONObject> {
        ContractListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JSONObject> list, JSONObject value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel titleLabel = new JLabel(value.optString("title"));
            titleLabel.setForeground(new Color(50, 50, 50));
            titleLabel.setFont(new Font("DialogInput", 1, 17));
            JLabel commentLabel = new JLabel(value.optString("comment"));
            commentLabel.setForeground(new Color(50, 50, 50));
            commentLabel.setFont(new Font("SansSerif", 2, 15));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            panel.add((Component)titleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)commentLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 0), 0, 0));
            return panel;
        }
    }
}

