/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.common.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.script.server.dev.EventScriptBase;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusContractProgram;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusPayment;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgram;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgramSpecification;
import ru.bitel.bgbilling.plugins.bonus.common.bonusPrograms.OperationBonusProgram;
import ru.bitel.bgbilling.plugins.bonus.server.dao.BonusDao;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.model.Period;
import ru.bitel.common.sql.ConnectionSet;

public abstract class BonusProgramDynamicBase
extends EventScriptBase<Event>
implements BonusProgramSpecification {
    public Map<String, String> map;
    public BonusDao bonusDao;
    public Connection con;
    public int contractId = -1;

    public void onEvent(Event event, Setup setup, ConnectionSet set) throws Exception {
        this.con = set.getConnection();
        this.contractId = event.getContractId();
        this.bonusDao = new BonusDao(this.con);
    }

    @Override
    public void accrualOfBonus(Connection con, BonusProgram program) throws SQLException, BGException {
        this.con = con;
        this.bonusDao = new BonusDao(con);
        this.accrualOfBonusImpl(con, program);
    }

    public abstract void accrualOfBonusImpl(Connection var1, BonusProgram var2) throws SQLException, BGException;

    public abstract List<String> getWebBonusStrings(Connection var1, BonusContractProgram var2);

    public List<BonusContractProgram> getContractPrograms(Class<? extends BonusProgramDynamicBase> clazz, Date date) throws BGException {
        List list = this.bonusDao.getProgramCotractList(this.contractId, 2, date);
        ArrayList<BonusContractProgram> result = new ArrayList<BonusContractProgram>();
        for (BonusContractProgram contractProgram : list) {
            String name = contractProgram.getProgram().getNameForDynamicClass();
            if (name == null || !name.equals(clazz.getName())) continue;
            result.add(contractProgram);
        }
        return result;
    }

    public BonusContractProgram getProgramContract(int programId, Date date) throws BGException {
        if (this.contractId == -1) {
            return null;
        }
        List list = this.bonusDao.getProgramCotractList(this.contractId, 2, date);
        for (BonusContractProgram program : list) {
            if (program.getProgram().getId() != programId) continue;
            return program;
        }
        return null;
    }

    public Period getPeriodForBonusPayment(BonusProgram program) {
        return new OperationBonusProgram().getPeriodForBonusPayment(program);
    }

    public int updatePaymnent(BigDecimal sum, BonusProgram program) throws BGException {
        return this.updatePayment(sum, program);
    }

    public int updatePayment(BigDecimal sum, BonusProgram program) throws BGException {
        BonusPayment payment = new BonusPayment(0, program.getPaymentTypeId(), new Date(), sum, this.getPeriodForBonusPayment(program));
        this.bonusDao.updatePayment(0, this.contractId, payment);
        return payment.getId();
    }

    public String getParam(String param, int programId) throws BGException {
        if (this.map == null) {
            this.map = this.bonusDao.getDataProgramOfContract(programId, this.contractId);
        }
        return this.map.get(param);
    }

    public void updateProgramData(int programId, int contractId, Map<String, String> mapL) throws SQLException {
        this.bonusDao.updateDataProgramOfContract(programId, contractId, mapL);
    }

    public void updateProgramData(int programId) throws SQLException {
        this.updateProgramData(programId, this.contractId, this.map);
    }
}

