/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.bots;

import com.sun.istack.NotNull;
import com.vk.api.sdk.client.TransportClient;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.exceptions.ApiException;
import com.vk.api.sdk.exceptions.ClientException;
import com.vk.api.sdk.httpclient.HttpTransportClient;
import com.vk.api.sdk.objects.messages.Message;
import com.vk.api.sdk.queries.messages.MessagesSendQuery;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.botmanager.common.bean.Bot;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.server.bean.VKApiHelper;
import ru.bitel.bgbilling.modules.botmanager.server.bots.RuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.message.ResponseOnMessage;
import ru.bitel.bgbilling.modules.botmanager.server.service.BotManagerServiceImpl;
import ru.bitel.common.Utils;

public class VKRuntimeBot
extends RuntimeBot {
    public static final String VKBOT_GROUP_ID_CONFIG_KEY = "groupId";
    public static final String VKBOT_ACCESS_TOKEN_CONFIG_KEY = "accessToken";
    private Logger logger = LogManager.getLogger();
    private VKApiHandler handler;
    private int groupId;

    public VKRuntimeBot(Bot bot) {
        super(bot);
    }

    @Override
    public void initBot() {
        this.groupId = this.botConfig.getInt(VKBOT_GROUP_ID_CONFIG_KEY, -1);
        if (this.groupId < 0) {
            this.logger.warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c groupId \u0434\u043b\u044f VKBot \u0438\u0437 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 GroupActor \u0434\u043b\u044f \u0431\u043e\u0442\u0430 " + this.botId + " groupId=" + this.groupId + " token=" + this.token);
        }
        try {
            this.handler = new VKApiHandler();
        }
        catch (BGException e) {
            this.logger.error((Object)e);
        }
    }

    @Override
    public void startBot() {
        if (this.groupId <= 0 && Utils.isBlankString((String)this.token)) {
            this.logger.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0431\u043e\u0442. \u041f\u0440\u0438\u0447\u0438\u043d\u0430: \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u0442\u044c \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c GroupActor");
            return;
        }
        if (this.botState == 0) {
            this.botState = 1;
        }
    }

    @Override
    public void stopBot() {
        if (this.botState == 1) {
            this.botState = 0;
        }
    }

    public VKApiHandler getApiHandler() {
        return this.handler;
    }

    public final class VKApiHandler {
        private VkApiClient vkApiClient;
        private VKApiHelper vkApiHelper;
        private final ResponseOnMessage responseOnMessage;

        private VKApiHandler() throws BGException {
            HttpTransportClient transportClient = HttpTransportClient.getInstance();
            this.vkApiClient = new VkApiClient((TransportClient)transportClient);
            this.responseOnMessage = new ResponseOnMessage(VKRuntimeBot.this);
            this.vkApiHelper = new VKApiHelper(this.vkApiClient);
        }

        public void messageNew(@NotNull Message message) throws BGException {
            try {
                List<String> attachments;
                int fromId = message.getFromId();
                String messageText = this.getTextMessage(message);
                MessagesSendQuery messagesSendQuery = this.vkApiClient.messages().send(new GroupActor(Integer.valueOf(VKRuntimeBot.this.groupId), VKRuntimeBot.this.getToken())).randomId(Integer.valueOf(new Random().nextInt(10000))).message(messageText).peerId(Integer.valueOf(fromId)).userId(Integer.valueOf(fromId));
                if (message.getKeyboard() != null) {
                    messagesSendQuery.keyboard(message.getKeyboard());
                }
                if (Utils.notEmptyCollection(attachments = this.getAttachments(message, VKRuntimeBot.this.getToken(), fromId))) {
                    messagesSendQuery.attachment(Utils.toString(attachments, (String)","));
                }
                messagesSendQuery.execute();
            }
            catch (ApiException | ClientException e) {
                throw new BGException(e);
            }
        }

        public void messageNew(int groupId, int fromId, String inputMessageText) throws BGException {
            Message response = this.responseOnMessage.response((Integer)groupId, fromId, inputMessageText);
            response.setFromId(Integer.valueOf(fromId));
            this.messageNew(response);
        }

        public VkApiClient getVkApiClient() {
            return this.vkApiClient;
        }

        private String getTextMessage(Message message) {
            String error = "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435";
            if (message == null) {
                return error;
            }
            String text = message.getText();
            if (Utils.isBlankString((String)text)) {
                return error;
            }
            if (text.contains("{$attachments:")) {
                text = text.substring(0, text.indexOf("{$attachments:"));
            }
            return text;
        }

        private List<String> getAttachments(Message message, String token, int fromId) throws BGException {
            if (message == null || Utils.isBlankString((String)message.getText())) {
                return Collections.emptyList();
            }
            String text = message.getText();
            if (!text.contains("{$attachments:")) {
                return Collections.emptyList();
            }
            List ids = Utils.toIntegerList((String)text.substring(text.indexOf("{$attachments:") + 14, text.indexOf("}")));
            if (Utils.isEmptyCollection((Collection)ids)) {
                return Collections.emptyList();
            }
            ArrayList<String> attachments = new ArrayList<String>();
            for (BotDialogElement element : VKRuntimeBot.this.getBotManagerService().getElementsByIds(ids)) {
                File attachmentFile = ((BotManagerServiceImpl)VKRuntimeBot.this.getBotManagerService()).getFileByElementId(element.getId());
                if (attachmentFile == null) continue;
                try {
                    attachments.add(this.getAttachmentLink(token, attachmentFile, fromId));
                }
                catch (IOException e) {
                    throw new BGException((Throwable)e);
                }
            }
            return attachments;
        }

        private String getAttachmentLink(String token, File attachmentFile, int fromId) throws BGException, UnsupportedEncodingException {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("access_token", token);
            params.put("peer_id", String.valueOf(fromId));
            JSONObject resp = this.vkApiHelper.doGet("docs.getMessagesUploadServer?", params);
            JSONObject responseJson = resp.optJSONObject("response");
            if (responseJson == null) {
                return "";
            }
            String uploadUrl = responseJson.optString("upload_url");
            if (Utils.isBlankString((String)uploadUrl)) {
                return "";
            }
            resp = this.vkApiHelper.uploadAttachmentFileOnVKServer(uploadUrl, attachmentFile);
            String encodeURL = URLEncoder.encode(resp.optString("file"), "UTF-8");
            params = new HashMap();
            params.put("access_token", token);
            params.put("file", encodeURL);
            resp = this.vkApiHelper.doPost("docs.save?", params);
            JSONObject content = resp.optJSONObject("response").optJSONObject("doc");
            return "doc" + content.optInt("owner_id", -1) + "_" + content.optInt("id", -1);
        }
    }
}

