/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action.base;

import bitel.billing.server.ActionBase;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractTariff;
import bitel.billing.server.contract.bean.ContractTariffManager;
import bitel.billing.server.contract.bean.PersonalTariff;
import bitel.billing.server.contract.bean.PersonalTariffManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.bgbilling.modules.card.common.bean.Dealer;
import ru.bitel.bgbilling.modules.card.server.bean.BGMacrosFormat;
import ru.bitel.bgbilling.modules.card.server.idealer.Conf;
import ru.bitel.bgbilling.modules.card.server.idealer.findbean.Find;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public abstract class ActionBaseIDealer
extends ActionBase {
    protected Dealer dealer;
    protected Contract dealerContract;

    protected void setErrorStatus(String msg, String error_code) throws DOMException {
        this.rootNode.setAttribute("status", "error");
        this.rootNode.setAttribute("error_code", error_code);
        this.rootNode.appendChild(this.rootNode.getOwnerDocument().createTextNode(msg));
    }

    public void init(Setup setup, Element rootNode, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws SQLException {
        super.init(setup, rootNode, request, response, servletContext);
        this.dealer = (Dealer)this.session.getAttribute("dealer_" + this.mid);
        this.dealerContract = (Contract)this.session.getAttribute("dealer_contract_" + this.mid);
    }

    protected void buildAddressLists() throws SQLException {
        this.buildAddressLists(0);
    }

    protected void buildAddressLists(int cityid) throws SQLException {
        Element addressList = this.createElement(this.rootNode, "address_list");
        Element cities = this.createElement(addressList, "cities");
        this.addListItem(cities, "0", "----------");
        Object query = "SELECT id, title FROM address_city ORDER BY title";
        PreparedStatement ps = this.con.prepareStatement((String)query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            this.addListItem(cities, rs.getString(1), rs.getString(2));
        }
        rs.close();
        ps.close();
        Element streets = this.createElement(addressList, "streets");
        this.addListItem(streets, "0", "----------");
        query = "SELECT street.id, concat('[', concat(city.title, concat('] ', street.title))) FROM address_street as street LEFT JOIN address_city as city ON street.cityid=city.id ";
        if (cityid > 0) {
            query = (String)query + " WHERE city.id=" + cityid;
        }
        query = (String)query + " ORDER BY city.title, street.title";
        ps = this.con.prepareStatement((String)query);
        rs = ps.executeQuery();
        while (rs.next()) {
            this.addListItem(streets, rs.getString(1), rs.getString(2));
        }
        rs.close();
        ps.close();
    }

    protected void buildFindModeList(Conf conf, long findmodes) {
        Element findModes = this.createElement(this.rootNode, "find_modes");
        findmodes >>= 1;
        for (int iter = 0; findmodes != 0L && iter < conf.finders.length; ++iter, findmodes >>= 1) {
            if ((findmodes & 1L) <= 0L) continue;
            Find find = conf.finders[iter];
            find.addMode(findModes, iter + 1);
        }
    }

    protected void buildContractPatternList() {
        String contractPatterns = this.moduleSetup.get("contract.pattern", "");
        if (!Utils.isEmptyString((String)contractPatterns)) {
            Element patternsEl = this.createElement(this.rootNode, "contract_patterns");
            String[] patterns = contractPatterns.split(";");
            for (int i = 0; i < patterns.length; ++i) {
                Element pattern = this.createElement(patternsEl, "pattern");
                pattern.setAttribute("value", patterns[i].trim());
            }
        }
    }

    protected final String getInfo(Connection con, Contract contract, String macros) {
        try {
            return new BGMacrosFormat(con, 0, contract).format(macros, new Object[0]);
        }
        catch (Exception e) {
            return "";
        }
    }

    protected void buildContractInfo(Contract contract) throws BGException {
        int cid = contract.getId();
        BalanceUtils bu = new BalanceUtils(this.con);
        String firmId = this.moduleSetup.get("firm.id", null);
        Element conEl = this.createElement(this.rootNode, "contract");
        conEl.setAttribute("id", String.valueOf(cid));
        conEl.setAttribute("title", String.valueOf(contract.getTitle()));
        conEl.setAttribute("comment", String.valueOf(contract.getComment()));
        conEl.setAttribute("balance", bu.getBalance(new Date(), contract.getId()).toPlainString());
        conEl.setAttribute("firm_id", firmId);
        bu.close();
        String infoMacros = this.moduleSetup.get("idealer.contract.info.macros", null);
        if (Utils.notBlankString((String)infoMacros)) {
            conEl.setAttribute("info", this.getInfo(this.con, contract, infoMacros));
        }
        String tariff_ids = this.moduleSetup.get("idealer.tariff.ids", null);
        Element tariffs = this.createElement(conEl, "tariffs");
        if (Utils.notBlankString((String)tariff_ids)) {
            tariffs.setAttribute("show", "1");
            List ids = Utils.toIntegerList((String)tariff_ids);
            ContractTariffManager tariffManager = new ContractTariffManager(this.con);
            List tariffList = tariffManager.getContractTariffList(cid, new Date());
            PersonalTariffManager ptManager = new PersonalTariffManager(this.con);
            List ptList = ptManager.getPersonalTariffList(cid, new Date());
            TariffPlanDao tpManager = new TariffPlanDao(this.con);
            for (int i = 0; i < ids.size(); ++i) {
                Element tariff;
                PersonalTariff perst2;
                int id = (Integer)ids.get(i);
                if (id == 0) {
                    for (PersonalTariff perst2 : ptList) {
                        tariff = this.createElement(tariffs, "tariff");
                        tariff.setAttribute("title", "\u041f\u0422: " + perst2.getTitle());
                    }
                    continue;
                }
                boolean found = false;
                perst2 = tariffList.iterator();
                while (perst2.hasNext()) {
                    ContractTariff t = (ContractTariff)perst2.next();
                    if (t.getTariffPlanId() != id) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                ArrayList<Integer> tariffPlanIds = new ArrayList<Integer>();
                tariffPlanIds.add(id);
                tariff = this.createElement(tariffs, "tariff");
                List tpList = tpManager.list(tariffPlanIds);
                if (tpList.size() <= 0 || tpList.get(0) == null) continue;
                tariff.setAttribute("title", ((TariffPlan)tpList.get(0)).getTitle());
            }
        } else {
            tariffs.setAttribute("show", "0");
        }
    }
}

