/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action.idealer;

import bitel.billing.server.ActionConType;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBaseIDealer;
import ru.bitel.bgbilling.modules.card.server.bean.DPayment;
import ru.bitel.bgbilling.modules.card.server.bean.DPaymentManager;
import ru.bitel.bgbilling.modules.card.server.bean.DealerManager;
import ru.bitel.bgbilling.modules.card.server.bean.DealerUtils;
import ru.bitel.bgbilling.modules.card.server.idealer.Conf;
import ru.bitel.bgbilling.modules.card.server.idealer.findbean.FindContractUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@ActionConType(value=0)
public class ActionPaymentAdd
extends ActionBaseIDealer {
    public void doAction() throws SQLException, BGException {
        float summ = this.getFloatParameter("summ", 0.0f);
        int pt = this.getIntParameter("pt", -1);
        String trans = this.getParameter("trans", "");
        String comment = this.getParameter("comment", "");
        if (this.dealer == null) {
            this.setErrorStatus("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0438/\u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", "3");
            return;
        }
        List paymentTypes = Utils.toIntegerList((String)this.dealer.getPt());
        if (paymentTypes.size() == 1 && pt < 0) {
            pt = (Integer)paymentTypes.get(0);
        }
        if (summ <= 0.0f || this.mid < 0 || pt < 0 || !paymentTypes.contains(pt) || Utils.isEmptyString((String)trans)) {
            this.setErrorStatus("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0438/\u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", "3");
            return;
        }
        Contract contract = null;
        int cid = this.getIntParameter("cid", -1);
        if (cid > 0) {
            ContractManager contractManager = new ContractManager(this.con);
            contract = contractManager.getContractById(cid);
            contractManager.close();
        } else {
            Conf conf = (Conf)this.setup.getConfig(this.mid, Conf.class);
            List<Contract> contractList = FindContractUtils.findContract(this.conSlave, conf, (this.dealer.getParams() & 0xFFFFFFF) > 0 ? (long)this.dealer.getParams() & 0xFFFFL : this.dealer.getFindmodes(), (this.dealer.getParams() & 0xFFFFFFF) > 0 ? ((long)this.dealer.getParams() & 0x3FFF0000L) >> 16 : this.dealer.getAllowcontracts(), this.dealer.getAllowcontractsMode(), this.request, true);
            if (contractList.size() > 1) {
                this.setErrorStatus("\u0423\u0442\u043e\u0447\u043d\u0438\u0442\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f \u043f\u043e\u0438\u0441\u043a\u0430", "9");
                return;
            }
            if (contractList.size() == 1) {
                contract = contractList.get(0);
            }
        }
        if (contract != null) {
            DPayment payment = new DPayment();
            payment.setTransId(trans);
            payment.setContractId(contract.getId());
            payment.setSumma(new BigDecimal(summ));
            payment.setPaymentType(pt);
            if (this.dealerContract != null) {
                BalanceUtils bu = new BalanceUtils(this.con);
                if (bu.getBalance(new Date(), this.dealerContract.getId()).compareTo(this.dealerContract.getBalanceLimit()) < 1) {
                    this.setErrorStatus("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0441\u0447\u0435\u0442\u0435 \u0434\u0438\u043b\u0435\u0440\u0430!", "15");
                    bu.close();
                    return;
                }
                bu.close();
            }
            String pattern = this.moduleSetup.get("payment.comment", "${dealer} # ${trans}");
            payment.setPaymentComment(DealerUtils.getPaymentComment(pattern, contract.getTitle(), this.dealer.getTitle(), summ, trans, comment));
            DealerManager dealerManager = new DealerManager(this.con, this.mid);
            DPaymentManager paymentManager = new DPaymentManager((Preferences)this.moduleSetup, this.con, this.mid);
            DPayment exist = paymentManager.addPayment(this.dealer, payment);
            if (exist == null) {
                dealerManager.incDealerPayed(this.dealer.getId());
            } else {
                payment = exist;
                this.setErrorStatus("\u0422\u0430\u043a\u043e\u0439 \u043d\u043e\u043c\u0435\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0443\u0436\u0435 \u0435\u0441\u0442\u044c!", "10");
            }
            Element payments = this.createElement(this.rootNode, "payments");
            Element payEl = this.createElement(payments, "payment");
            payEl.setAttribute("id", String.valueOf(payment.getId()));
            payEl.setAttribute("trans", payment.getTransId());
            payEl.setAttribute("cid", String.valueOf(payment.getContractId()));
            payEl.setAttribute("summ", Utils.formatCost((BigDecimal)payment.getSumma()));
            payEl.setAttribute("date", TimeUtils.format((Date)payment.getDateTime(), (String)"dd.MM.yyyy HH.mm.ss"));
            payEl.setAttribute("comment", payment.getPaymentComment());
            payEl.setAttribute("contract", contract.getTitle());
            payEl.setAttribute("contract_comment", contract.getComment());
            payEl.setAttribute("status", String.valueOf(payment.getStatus()));
            if (exist == null) {
                this.buildContractInfo(contract);
            }
        } else {
            this.setErrorStatus("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", "8");
        }
    }
}

