/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server;

import java.io.IOException;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.xcrypt.XcryptCon;
import ru.bitel.bgbilling.modules.cerbercrypt.server.xcrypt.XcryptException;
import ru.bitel.common.DateTimeUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class XcryptServiceActivator
extends DigitalTVServiceActivator {
    private static final Logger log = LogManager.getLogger();
    private XcryptCon con = null;
    private static LocalDate INF_TERM_DATE_DEFAULT = LocalDate.of(2049, 12, 31);
    private LocalDate infiniteDate = INF_TERM_DATE_DEFAULT;

    public XcryptServiceActivator(ParameterMap moduleSetup, Connection conMaster, Connection conSlave, int mid, Calendar time) throws BGException {
        super(moduleSetup, conMaster, conSlave, mid, time);
    }

    private XcryptCon getConnection(int serverId, UserCard userCard) throws BGException {
        ParameterMap moduleSetup = this.getModuleSetup(userCard);
        ParameterMap connectionSetup = moduleSetup.sub("server." + serverId + ".");
        XcryptCon newconnect = new XcryptCon(connectionSetup, serverId);
        this.infiniteDate = connectionSetup.getLocalDate("infinite.date", INF_TERM_DATE_DEFAULT);
        try {
            if (this.con == null) {
                newconnect.connect();
                newconnect.channel_setup();
                newconnect.channel_test();
                this.con = newconnect;
            } else {
                this.con.tuneconnect(newconnect);
            }
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
        return this.con;
    }

    @Override
    public void destroy() {
        if (this.con != null) {
            try {
                this.con.channel_close();
                this.con.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.con = null;
        }
    }

    private static void smartSynchronize(XcryptCon con, long cardNumber, String CA_Dev_ID, List<DigitalTVServiceActivator.CardPacketCodePair> billingSubscription, LocalDate infiniteDate) throws Exception {
        List<XcryptCon.SubscriptionInfo> casSubscription = con.command_get_subscribers_information(cardNumber);
        ArrayList<DigitalTVServiceActivator.CardPacketCodePair> toAdd = new ArrayList<DigitalTVServiceActivator.CardPacketCodePair>();
        ArrayList<XcryptCon.SubscriptionInfo> toCancel = new ArrayList<XcryptCon.SubscriptionInfo>();
        XcryptServiceActivator.subscribeEqualizer(billingSubscription, casSubscription, toAdd, toCancel, new XcryptSubscriptionInfo(infiniteDate));
        if (!toCancel.isEmpty()) {
            con.command_product_cancellation(cardNumber, CA_Dev_ID, toCancel);
        }
        if (!toAdd.isEmpty()) {
            List<XcryptCon.SubscriptionInfo> entitlements = XcryptServiceActivator.packetsToEntitlements(toAdd, infiniteDate);
            con.command_adding_of_product(cardNumber, CA_Dev_ID, entitlements);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(long cardCode) throws BGException {
        log.info("Closing card " + cardCode);
        XcryptCon con = null;
        try {
            con = this.getConnection(0, null);
            XcryptServiceActivator.smartSynchronize(con, cardCode, null, Collections.emptyList(), this.infiniteDate);
        }
        catch (Exception ex) {
            log.error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u043d\u043e\u0439 \u043e\u0442\u043c\u0435\u043d\u044b \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult modifyImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        XcryptCon con = null;
        try {
            con = this.getConnection(0, card);
            List<DigitalTVServiceActivator.CardPacketCodePair> cpcl = this.getCardPacketCodePairList(cardPacketList, false, true);
            XcryptServiceActivator.smartSynchronize(con, card.getNumber(), card != null ? card.getUserdeviceSN() : null, cpcl, this.infiniteDate);
        }
        catch (Exception ex) {
            log.error("Exception in modifyImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        log.info("Closing card: " + card.getNumber() + ", cardPackets count: " + cardPacketList.size());
        XcryptCon con = null;
        try {
            con = this.getConnection(0, card);
            XcryptServiceActivator.smartSynchronize(con, card.getNumber(), card != null ? card.getUserdeviceSN() : null, Collections.emptyList(), this.infiniteDate);
        }
        catch (Exception ex) {
            log.error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u043c\u0435\u043d\u044b \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult sendMessagesImpl(List<Long> cardNumbers, String title, String message, boolean ismail) {
        XcryptCon con = null;
        try {
            if (cardNumbers == null) {
                con = this.getConnection(0, null);
                con.command_group_mail(message);
            } else {
                for (Long cardNumber : cardNumbers) {
                    UserCard userCard = this.userCardManager.getUserCard((long)cardNumber, new Date());
                    con = this.getConnection(0, userCard);
                    con.command_mail(cardNumber, userCard.getUserdeviceSN(), message);
                }
            }
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            log.error("Exception sendMessagesImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult getSubscribeInfoImpl(long cardNumber) {
        StringBuilder infotext = new StringBuilder(64);
        String logline1 = "get subscribe card: " + cardNumber;
        log.info(logline1);
        infotext.append(logline1).append("\n");
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
            XcryptCon con = this.getConnection(0, userCard);
            List<XcryptCon.SubscriptionInfo> packages = con.command_get_subscribers_information(cardNumber);
            if (packages.size() == 0) {
                infotext.append("none\n");
            } else {
                infotext.append(XcryptCon.SubscriptionInfo.getHeader()).append("\n");
                for (XcryptCon.SubscriptionInfo info : packages) {
                    infotext.append(info.toString()).append("\n");
                }
            }
        }
        catch (XcryptException ex) {
            infotext.append("error: " + ex.getMessage());
        }
        catch (Exception ex) {
            log.error("Exception getSubscribeInfoImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438", ex);
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(true, infotext.toString(), null, null);
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult activateImpl(long cardNumber, UserCard card, List<CardPacket> cardPacketList) throws BGException {
        XcryptCon con = null;
        try {
            con = this.getConnection(0, card);
            List<DigitalTVServiceActivator.CardPacketCodePair> cpcl = this.getCardPacketCodePairList(cardPacketList, false, true);
            List<XcryptCon.SubscriptionInfo> entitlements = XcryptServiceActivator.packetsToEntitlements(cpcl, this.infiniteDate);
            con.command_subscription_creation(cardNumber, card != null ? card.getUserdeviceSN() : null, entitlements);
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            log.error("Exception activateImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult deactivateImpl(long cardNumber) throws BGException {
        XcryptCon con = null;
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
            con = this.getConnection(0, userCard);
            con.command_subscription_termination(cardNumber, userCard != null ? userCard.getUserdeviceSN() : null);
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            log.error("Exception deactivateImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", ex);
        }
    }

    private static List<XcryptCon.SubscriptionInfo> packetsToEntitlements(List<DigitalTVServiceActivator.CardPacketCodePair> cpclList, LocalDate infiniteDate) {
        ArrayList<XcryptCon.SubscriptionInfo> entitlements = new ArrayList<XcryptCon.SubscriptionInfo>();
        for (DigitalTVServiceActivator.CardPacketCodePair cpcl : cpclList) {
            int product_group = Utils.parseInt((String)cpcl.packetCode, (int)-1);
            LocalDate term_date = cpcl.cardpacket.getDateTo() != null ? DateTimeUtils.toLocalDate((Date)cpcl.cardpacket.getDateTo()) : infiniteDate;
            entitlements.add(new XcryptCon.SubscriptionInfo(0L, null, null, product_group, term_date));
        }
        return entitlements;
    }

    public static class XcryptSubscriptionInfo
    implements DigitalTVServiceActivator.SubscriptionComparatorForEqualizer<XcryptCon.SubscriptionInfo> {
        private LocalDate infiniteDate;

        public XcryptSubscriptionInfo(LocalDate infiniteDate) {
            this.infiniteDate = infiniteDate;
        }

        @Override
        public boolean subscriptionEquals(DigitalTVServiceActivator.CardPacketCodePair cardpacket, XcryptCon.SubscriptionInfo casPacket) {
            int bg_product_group = Utils.parseInt((String)cardpacket.packetCode, (int)-1);
            LocalDate bg_term_date = cardpacket.cardpacket.getDateTo() != null ? DateTimeUtils.toLocalDate((Date)cardpacket.cardpacket.getDateTo()) : this.infiniteDate;
            return bg_term_date.equals(casPacket.term_date) && bg_product_group == casPacket.product_group;
        }
    }
}

