/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.enigo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.server.enigo.CommandAddSubscription;
import ru.bitel.bgbilling.modules.cerbercrypt.server.enigo.CommandRemoveSubscription;
import ru.bitel.bgbilling.modules.cerbercrypt.server.enigo.CommandSendMessage;
import ru.bitel.bgbilling.modules.cerbercrypt.server.enigo.CommandSubscriptionsList;
import ru.bitel.bgbilling.modules.cerbercrypt.server.enigo.CommandUpdateParameters;
import ru.bitel.bgbilling.modules.cerbercrypt.server.enigo.EnigoCasCommand;
import ru.bitel.bgbilling.modules.cerbercrypt.server.enigo.EnigoCasException;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class EnigoCasCon {
    private static final Logger log = LogManager.getLogger();
    private String host;
    private String apikey;
    private int osdRepetition;
    private int osdDuration;
    private int osdInterval;
    private boolean emailEnable;
    private boolean osdEnable;
    private int cmd2type;

    public EnigoCasCon(ParameterMap preferences, int serverId) throws BGException {
        this.host = preferences.get("host", null);
        this.apikey = preferences.get("apikey", null);
        if (Utils.isEmptyString((String)this.host) || Utils.isEmptyString((String)this.apikey)) {
            throw new BGException("Host or apikey for server " + serverId + " undefined!");
        }
        this.osdRepetition = preferences.getInt("osdRepetition", 1);
        this.osdDuration = preferences.getInt("osdDuration", 30);
        this.osdInterval = preferences.getInt("osdInterval", 60);
        this.emailEnable = preferences.getBoolean("emailEnable", true);
        this.osdEnable = preferences.getBoolean("osdEnable", true);
        this.cmd2type = preferences.getInt("cmd2type", 0);
    }

    private static String getUrl(String url) throws IOException {
        int ch;
        StringBuilder result = new StringBuilder();
        URL url2 = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)url2.openConnection();
        conn.setRequestMethod("GET");
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        while ((ch = rd.read()) != -1) {
            result.append((char)ch);
        }
        rd.close();
        conn.disconnect();
        return result.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendCommand(EnigoCasCommand command) throws EnigoCasException, BGException, IOException {
        StringBuilder query = new StringBuilder(666);
        query.append(this.host).append("?api-key=").append(this.apikey);
        query.append("&command=").append(command.getCommandNumber());
        for (Map.Entry<String, Object> param : command.getParamMap().entrySet()) {
            query.append("&").append(param.getKey()).append("=").append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
        }
        EnigoCasCon.$trace("-> %s", query.toString());
        String response = EnigoCasCon.getUrl(query.toString());
        EnigoCasCon.$trace("<- %s", response);
        if (response.length() <= 20) {
            int errorcode = Utils.parseInt((String)response, (int)-1);
            if (errorcode == -1) throw new BGException("response is not similar to the error code: " + response);
            command.checkError(errorcode);
            return;
        } else {
            command.setResponse(response);
        }
    }

    public void activeStatusSmartcard(long cardNumber, boolean active, String name, String cn, String address, String info) throws BGException, IOException {
        EnigoCasCon.$trace("activeStatusSmartcard: cardNumber=%s, active=%s", cardNumber, active);
        this.sendCommand(new CommandUpdateParameters(cardNumber, active, name, cn, address, info));
    }

    public void sendMessageOsd(long cardNumber, String text) throws BGException, IOException {
        EnigoCasCon.$trace("sendMessageOsd: cardNumber=%s (osdEnable=%b)", cardNumber, this.osdEnable);
        if (this.osdEnable) {
            this.sendCommand(new CommandSendMessage(cardNumber, true, text, this.osdRepetition, this.osdDuration, this.osdInterval));
        }
    }

    public void sendMessageMail(long cardNumber, String text) throws BGException, IOException {
        EnigoCasCon.$trace("sendMessageMail: cardNumber=%s (emailEnable=%b)", cardNumber, this.emailEnable);
        if (this.emailEnable) {
            this.sendCommand(new CommandSendMessage(cardNumber, false, text));
        }
    }

    public List<CommandSubscriptionsList.SubscriptionInfo> getSubscriptionsList(long cardNumber) throws EnigoCasException, BGException, IOException {
        EnigoCasCon.$trace("getSubscriptionsList: cardNumber=%s", cardNumber);
        CommandSubscriptionsList command = new CommandSubscriptionsList(cardNumber);
        try {
            this.sendCommand(command);
        }
        catch (EnigoCasException ex) {
            if (ex.getErrorcode() == 4) {
                EnigoCasCon.$trace("masking exception: %s", ex.getMessage());
                return new ArrayList<CommandSubscriptionsList.SubscriptionInfo>();
            }
            throw ex;
        }
        return command.getSubscriptionInfo();
    }

    public void addSubscription(long cardNumber, String packageCode, Date startTime, Date stopTime) throws BGException, IOException {
        EnigoCasCon.$trace("addSubscription: cardNumber=%s, packageCode=%s, startTime=%s, stopTime=%s", cardNumber, packageCode, startTime, stopTime);
        this.sendCommand(new CommandAddSubscription(cardNumber, packageCode, startTime, stopTime, this.cmd2type));
    }

    public void removeSubscription(long cardNumber, String packageCode, String subscriptionId) throws BGException, IOException {
        EnigoCasCon.$trace("removeSubscription: cardNumber=%s, packageCode=%s, subscriptionId=%s", cardNumber, packageCode, subscriptionId);
        this.sendCommand(new CommandRemoveSubscription(cardNumber, packageCode, subscriptionId));
    }

    public void removeAllSubscription(long cardNumber) throws BGException, IOException {
        EnigoCasCon.$trace("removeAllSubscription: cardNumber=%s", cardNumber);
        try {
            this.sendCommand(new CommandRemoveSubscription(cardNumber, null, null));
        }
        catch (EnigoCasException ex) {
            if (ex.getErrorcode() == 7) {
                EnigoCasCon.$trace("masking exception: %s", ex.getMessage());
            }
            throw ex;
        }
    }

    private static void $trace(String format, Object ... args) {
        log.info("EnigoCasCon: " + String.format(format, args));
    }
}

