/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.service;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.RecalculateService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.task.Recalculator;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.cerbercrypt.common.service.RecalculateService")
public class RecalculateServiceImpl
extends AbstractService
implements RecalculateService {
    public void recalculate(String cids, String mail, String date, String comment) throws BGException {
        Calendar startMonth = TimeUtils.parseCalendar((String)date, (String)"dd.MM.yyyy");
        if (this.moduleId < 0 || startMonth == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 mid=" + this.moduleId + "; date=" + startMonth);
        }
        if (TimeUtils.monthsDelta((Calendar)new GregorianCalendar(), (Calendar)startMonth) > 0) {
            throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u044c \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0437\u0430 \u0431\u0443\u0434\u0443\u0449\u0438\u0435 \u043c\u0435\u0441\u044f\u0446\u044b!");
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionRecalculate", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            try {
                ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (Calendar)startMonth);
            }
            catch (BGMessageException ex) {
                throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043f\u0435\u0440\u0435\u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u0435");
            }
        }
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new Recalculator(this.moduleId, startMonth, mail, cids, comment));
    }
}

