/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.chronopay.server.action.web;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.modules.chronopay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.chronopay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.chronopay.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.chronopay.server.bean.Constants;
import ru.bitel.bgbilling.modules.chronopay.server.bean.TransactionManager;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Chronopay")
public class ActionDoTransaction
extends AbstractAction {
    private static final Logger logger = LogManager.getLogger();
    private final String moduleName = "chronopay";

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.context.getRequest().setAttribute("gateUrl", (Object)this.moduleSetup.get("chronopay.gate.url", "https://payments.chronopay.com/"));
        this.paymentForm("chronopay", Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchResult searchResult = new SearchResult(null, this.getPage(), new String[]{"createDate:1", "transactionDate:1"});
            transactionManager.searchTransaction((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
            this.context.getRequest().setAttribute("transactions", (Object)searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    public void success() throws Exception {
        this.execute();
    }

    public void decline() throws Exception {
        this.execute();
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws BGException {
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal sumMin = this.moduleSetup.getBigDecimal("chronopay.sum.min", new BigDecimal(100));
        BigDecimal sumMax = this.moduleSetup.getBigDecimal("chronopay.sum.max", new BigDecimal(5000));
        try {
            String customerAddress = ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
            if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
                this.execute();
                throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
            }
            Transaction transaction = new Transaction();
            transaction.setSum(sum);
            transaction.setContractId(this.contractId);
            transaction.setCreateDate(new Date());
            try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
                transactionManager.update(transaction);
            }
            Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
            String description = this.moduleSetup.get("chronopay.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle());
            String productId = this.moduleSetup.get("chronopay.product.id", "1-1-1");
            String productPrice = sum.setScale(2, RoundingMode.HALF_UP).toString();
            String phone = ContractUtils.getPaymentPhone((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("payment.phone"));
            this.setResultParam("product_id", productId);
            this.setResultParam("product_price", productPrice);
            this.setResultParam("product_name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116" + contract.getTitle());
            this.setResultParam("order_id", String.valueOf(transaction.getId()));
            this.setResultParam("merchant_no", String.valueOf(transaction.getId()));
            this.setResultParam("cs1", String.valueOf(transaction.getId()));
            this.setResultParam("merchant_uid", String.valueOf(contract.getId()));
            this.setResultParam("product_name", description);
            this.setResultParam("country", this.moduleSetup.get("chronopay.country", "RUS"));
            this.setResultParam("cb_url", this.moduleSetup.get("chronopay.callback.url", ""));
            this.setResultParam("success_url", this.moduleSetup.get("chronopay.success.url", ""));
            this.setResultParam("decline_url", this.moduleSetup.get("chronopay.decline.url", ""));
            this.setResultParam("sign", this.doSign(productId + "-" + productPrice));
            if (customerAddress != null) {
                this.setResultParam("email", customerAddress);
            }
            if (phone != null) {
                this.setResultParam("phone", phone);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    private String doSign(String value) {
        return Utils.getDigest((String)(value + "-" + this.moduleSetup.get("chronopay.sharedsec", "")), (String)"UTF-8").toLowerCase();
    }
}

