/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.chronopay.server.service;

import java.math.BigDecimal;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.modules.chronopay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.chronopay.common.service.ChronoPayService;
import ru.bitel.bgbilling.modules.chronopay.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.chronopay.server.bean.TransactionManager;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.chronopay.common.service.ChronoPayService")
public class ChronoPayServiceImpl
extends AbstractService
implements ChronoPayService {
    private static final Logger logger = LogManager.getLogger();
    private TransactionManager manager;

    @PostConstruct
    private void init() {
        this.manager = new TransactionManager(this.getConnection(), this.moduleId);
    }

    public SearchResult<Transaction> searchTransactionList(int contractId, String contractTitle, String status, Period period, String[] sort, Page page) throws BGException {
        SearchResult transactionSearchResult = new SearchResult(period, page, sort);
        this.manager.searchTransaction((SearchResult<Transaction>)transactionSearchResult, contractId, contractTitle, status);
        return transactionSearchResult;
    }

    public void checkTransactions(int contractId) throws BGException {
        this.manager.doCheckRequest(contractId);
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        if (logger.isDebugEnabled()) {
            logger.debug("endTransaction");
        }
        try (TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);){
            transactionManager.doCheckRequest(contractId);
        }
    }

    public SearchResult<Autopayment> searchAutopaymentList(int contractId, Period period, String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(period, page, sort);
        AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
        autopaymentManager.searchAutopayment(searchResult, contractId);
        autopaymentManager.close();
        return searchResult;
    }

    public void doManualAutopayment(int contractId, BigDecimal sum) throws BGException {
    }
}

