/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.action;

import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCall;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCategory;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterProblem;
import ru.bitel.bgbilling.plugins.crm.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterCallManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterCategoryManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterProblemManager;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.SearchResult;

public class ActionRegisterCallTable
extends ActionBase {
    public void doAction() throws SQLException {
        int subject = this.getIntParameter("subject", 0);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        RegisterCallManager callManager = new RegisterCallManager(this.con);
        RegisterCategoryManager catManager = new RegisterCategoryManager(this.con);
        RegisterProblemManager problemManager = new RegisterProblemManager(this.con);
        Map<Integer, RegisterCategory> categoryMap = catManager.getCategoryMap();
        SearchResult searchResult = new SearchResult();
        String statusList = this.plugin.getSetup().get("register.problem.status.list", "0:\u043e\u0442\u043a\u0440\u044b\u0442\u0430;1:\u043f\u0440\u0438\u043d\u044f\u0442\u0430;2:\u0437\u0430\u043a\u0440\u044b\u0442\u0430");
        Map<Integer, String> statusMap = RegisterProblemManager.getStatusMap(statusList);
        searchResult.setPage(this.getPage());
        searchResult.setPeriod(this.getPeriod());
        searchResult.setAttribute("cid", String.valueOf(this.cid));
        searchResult.setAttribute("subject", String.valueOf(subject));
        callManager.searchList((SearchResult<RegisterCall>)searchResult);
        for (RegisterCall call : searchResult.getList()) {
            RegisterProblem ri;
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(call.getId()));
            row.setAttribute("time", TimeUtils.format((Date)call.getTime(), (String)"dd.MM.yyyy HH:mm:ss"));
            row.setAttribute("user", UserMap.getUser((Integer)call.getUserId()).getName());
            row.setAttribute("type", call.getSubjectTitle());
            row.setAttribute("comment", call.getComment());
            if (call.getContractId() > 0) {
                row.setAttribute("contract", call.getContractTitle());
                row.setAttribute("contract_id", String.valueOf(call.getContractId()));
                if (call.getObjectId() > 0) {
                    row.setAttribute("object", call.getObjectTitle());
                    row.setAttribute("object_id", String.valueOf(call.getObjectId()));
                }
            }
            if (call.getRegisterProblemId() <= 0 || (ri = problemManager.getProblemByID(call.getRegisterProblemId())) == null) continue;
            row.setAttribute("problem", this.getDescription(ri, categoryMap, statusMap));
        }
        this.setPageAttribute(table, searchResult.getPage());
    }

    public String getDescription(RegisterProblem problem, Map<Integer, RegisterCategory> categoryMap, Map<Integer, String> statusMap) {
        StringBuffer sb = new StringBuffer();
        sb.append(problem.getId());
        sb.append(";");
        sb.append(statusMap.get(problem.getStatus()));
        if (problem.getCloseTime() != null) {
            sb.append(" (");
            RegisterCategory cat = categoryMap.get(problem.getCategoryId());
            if (cat != null) {
                sb.append(cat.getTitle());
            } else {
                sb.append("??? (" + problem.getCategoryId() + ") ");
            }
            sb.append(")");
        }
        sb.append(";");
        sb.append(problem.getComment());
        return sb.toString();
    }
}

