/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.client.admin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.param.common.service.ContractParameterServiceOld;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContactType;
import ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class ContactManagerPanel
extends BGUPanel {
    private static final ContactType EMAIL_CONTACT_TYPE = new ContactType();
    private BGUTable table;
    private BGTableModel<ContactType> model;
    private BGEditor editor;
    private ContactEditorForm contactForm;

    protected void jbInit() {
        this.model = new BGTableModel<ContactType>("\u0422\u0438\u043f\u044b \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432"){

            protected void initColumns() {
                this.addColumn("\u041a\u043e\u0434", 100, 100, 100, "id");
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title");
            }
        };
        this.table = new BGUTable(this.model);
        this.contactForm = new ContactEditorForm();
        this.editor = new BGEditor();
        this.editor.addForm((JComponent)((Object)this.contactForm));
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.editor.setVisible(false);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ContactManagerPanel.this.performAction("edit");
                }
            }
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                List data = ((DispatchService)((ClientContext)ContactManagerPanel.this.getContext()).getPort(DispatchService.class)).getContactTypes();
                ContactManagerPanel.this.model.setData(data);
            }
        };
    }

    static {
        EMAIL_CONTACT_TYPE.setId(-1);
        EMAIL_CONTACT_TYPE.setPattern("^[A-z0-9._%+-]+@[A-z0-9.-]+\\.[A-z]{2,4}$");
        EMAIL_CONTACT_TYPE.setTitle("\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 (e-mail)");
    }

    private class ContactEditorForm
    extends BGUPanel {
        private static final int EMAIL_ID = 0;
        private static final int USER_ID = 1;
        private ContactType current;
        private BGUComboBox<IdTitle> templateBox = new BGUComboBox();
        private BGTextField patternField = new BGTextField();
        private BGTextField titleField = new BGTextField();
        private BGTextField tooltipField = new BGTextField();
        private BGUComboBox<IdTitle> paramaterBox = new BGUComboBox();

        private ContactEditorForm() {
        }

        protected void jbInit() {
            ArrayList<IdTitle> items = new ArrayList<IdTitle>(2);
            items.add(new IdTitle(1, "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439"));
            items.add(new IdTitle(0, "E-mail"));
            this.templateBox.setData(items);
            ArrayList<IdTitle> parameters = new ArrayList<IdTitle>(2);
            parameters.add(new IdTitle(-1, "\u041d\u0435\u0442"));
            try {
                parameters.addAll(((ContractParameterServiceOld)((ClientContext)this.getContext()).getPort(ContractParameterServiceOld.class)).getContractParameterPrefList(1));
                parameters.addAll(((ContractParameterServiceOld)((ClientContext)this.getContext()).getPort(ContractParameterServiceOld.class)).getContractParameterPrefList(3));
                parameters.addAll(((ContractParameterServiceOld)((ClientContext)this.getContext()).getPort(ContractParameterServiceOld.class)).getContractParameterPrefList(9));
            }
            catch (BGException e1) {
                e1.printStackTrace();
            }
            this.paramaterBox.setData(parameters);
            this.setLayout(new GridBagLayout());
            this.add(new JLabel("\u0422\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.titleField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add(new JLabel("\u0428\u0430\u0431\u043b\u043e\u043d:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)this.templateBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)this.patternField, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.add(new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (\u043f\u043e\u0434\u0441\u043a\u0430\u0437\u043a\u0430):"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.tooltipField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add(new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.paramaterBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
            this.templateBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ContactEditorForm.this.templateBox.getSelectedItem() != null && ((IdTitle)ContactEditorForm.this.templateBox.getSelectedItem()).getId() == 0) {
                        ContactEditorForm.this.patternField.setVisible(false);
                    } else {
                        ContactEditorForm.this.patternField.setVisible(true);
                    }
                    ContactManagerPanel.this.editor.revalidate();
                }
            });
        }

        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u044b\u0439"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    ContactEditorForm.this.current = new ContactType();
                    ContactEditorForm.this.current.setId(-1);
                    ContactEditorForm.this.patternField.setText("^.*$");
                    ContactEditorForm.this.titleField.setText("");
                    ContactEditorForm.this.tooltipField.setText("");
                    ContactEditorForm.this.templateBox.setSelectedItem((Object)1);
                    ContactEditorForm.this.paramaterBox.setSelectedItem((Object)-1);
                    ContactEditorForm.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    ContactEditorForm.this.current = (ContactType)ContactManagerPanel.this.model.getSelectedRow();
                    if (ContactEditorForm.this.current == null) {
                        return;
                    }
                    ContactEditorForm.this.patternField.setText(ContactEditorForm.this.current.getPattern());
                    ContactEditorForm.this.titleField.setText(ContactEditorForm.this.current.getTitle());
                    ContactEditorForm.this.tooltipField.setText(ContactEditorForm.this.current.getDescription());
                    if (EMAIL_CONTACT_TYPE.getPattern().equals(ContactEditorForm.this.current.getPattern())) {
                        ContactEditorForm.this.templateBox.setSelectedItem((Object)0);
                    } else {
                        ContactEditorForm.this.templateBox.setSelectedItem((Object)1);
                    }
                    ContactEditorForm.this.paramaterBox.setSelectedItem((Object)ContactEditorForm.this.current.getPid());
                    ContactEditorForm.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "OK"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    if (ContactEditorForm.this.templateBox.getSelectedItem() != null && ((IdTitle)ContactEditorForm.this.templateBox.getSelectedItem()).getId() == 0) {
                        ContactEditorForm.this.current.setPattern(EMAIL_CONTACT_TYPE.getPattern());
                    } else {
                        ContactEditorForm.this.current.setPattern(ContactEditorForm.this.patternField.getText());
                    }
                    ContactEditorForm.this.current.setTitle(ContactEditorForm.this.titleField.getText());
                    ContactEditorForm.this.current.setDescription(ContactEditorForm.this.tooltipField.getText());
                    ContactEditorForm.this.current.setPid(((IdTitle)ContactEditorForm.this.paramaterBox.getSelectedItem()).getId());
                    ((DispatchService)((ClientContext)ContactEditorForm.this.getContext()).getPort(DispatchService.class)).updateContactType(ContactEditorForm.this.current);
                    ContactEditorForm.this.performActionClose();
                    ContactManagerPanel.this.performAction("refresh");
                }
            };
            new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    ContactEditorForm.this.current = (ContactType)ContactManagerPanel.this.model.getSelectedRow();
                    if (ContactEditorForm.this.current == null) {
                        return;
                    }
                    ((DispatchService)((ClientContext)ContactEditorForm.this.getContext()).getPort(DispatchService.class)).deleteContactType(ContactEditorForm.this.current.getId());
                    ContactEditorForm.this.performActionClose();
                    ContactManagerPanel.this.performAction("refresh");
                }
            };
        }
    }
}

