/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.dao;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.base.DispatchCondition;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.SenderTypeDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.ScheduleTime;

public class DispatchDao
extends AbstractIdDao<Dispatch> {
    public DispatchDao(Connection con) {
        super(con, 0, "dispatch_dispatch");
    }

    protected void updateImpl(Dispatch b) throws BGException, SQLException {
        byte[] bytes = this.serializeDispatchConditions(b);
        String query = b.getId() > 0 ? "UPDATE " + this.tableName + " SET title=?, sender_type_id=?, repeat_time=?, contact_type_id=?, conditions=?, active=?, personal=?, do_not_mark_sended=?, only_one_contact=?, wo_contact_type=?, user=?, last_modify_date=NOW() WHERE id=?" : "INSERT INTO " + this.tableName + " (title,sender_type_id,repeat_time,contact_type_id,conditions,active,personal, do_not_mark_sended, only_one_contact, wo_contact_type, user, last_modify_date, create_date) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW(),NOW())";
        PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
        int index = 1;
        ps.setString(index++, b.getTitle());
        ps.setInt(index++, b.getSenderType().getId());
        ps.setString(index++, ScheduleTime.serialize((ScheduleTime)b.getRepeatTime()));
        ps.setInt(index++, b.getContactTypeId());
        ps.setBytes(index++, bytes);
        ps.setBoolean(index++, b.isActive());
        ps.setBoolean(index++, b.isPersonal());
        ps.setBoolean(index++, b.isDoNotMarkSended());
        ps.setBoolean(index++, b.isOnlyOneContact());
        ps.setBoolean(index++, b.isWoContactType());
        ps.setInt(index++, b.getUserId());
        if (b.getId() > 0) {
            ps.setInt(index++, b.getId());
        }
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }

    private byte[] serializeDispatchConditions(Dispatch b) {
        Document doc = XMLUtils.newDocument();
        Element items = XMLUtils.createElement((Document)doc, (String)"items");
        for (DispatchCondition cond : b.getConditions()) {
            Element item = XMLUtils.createElement((Element)items, (String)"item");
            cond.serialize(item);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLUtils.serialize((Node)doc, (OutputStream)baos, (String)"UTF-8");
        return baos.toByteArray();
    }

    protected Dispatch getFromRS(ResultSet rs) throws SQLException, BGException {
        Dispatch d = new Dispatch();
        d.setId(rs.getInt(this.tableName + ".id"));
        d.setSenderType(SenderTypeDao.getSenderTypeFromRS(rs, this.tableName));
        d.setRepeatTime(ScheduleTime.deserialize((String)rs.getString(this.tableName + ".repeat_time")));
        d.setContactTypeId(rs.getInt(this.tableName + ".contact_type_id"));
        d.setTitle(rs.getString(this.tableName + ".title"));
        d.setActive(rs.getBoolean(this.tableName + ".active"));
        d.setPersonal(rs.getBoolean(this.tableName + ".personal"));
        d.setDoNotMarkSended(rs.getBoolean(this.tableName + ".do_not_mark_sended"));
        d.setOnlyOneContact(rs.getBoolean(this.tableName + ".only_one_contact"));
        d.setWoContactType(rs.getBoolean(this.tableName + ".wo_contact_type"));
        d.setUserId(rs.getInt(this.tableName + ".user"));
        d.setCreateDispatchDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(this.tableName + ".create_date")));
        d.setLastModifyDispatchDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(this.tableName + ".last_modify_date")));
        List<DispatchCondition> conditions = this.deserializeConditions(rs);
        d.setConditions(conditions);
        return d;
    }

    private List<DispatchCondition> deserializeConditions(ResultSet rs) throws SQLException {
        byte[] bytes = rs.getBytes(this.tableName + ".conditions");
        ArrayList<DispatchCondition> conditions = new ArrayList<DispatchCondition>();
        if (bytes.length == 0) {
            return conditions;
        }
        Document doc = XMLUtils.parseDocument((byte[])bytes);
        for (Element item : XMLUtils.selectElements((Node)doc, (String)"//items/item")) {
            try {
                String className = item.getAttribute("class");
                DispatchCondition condition = (DispatchCondition)Class.forName(className).newInstance();
                condition.deserialize(item);
                conditions.add(condition);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return conditions;
    }

    public Dispatch getDispatchFromRS(ResultSet rs) throws SQLException, BGException {
        return this.getFromRS(rs);
    }

    public List<Dispatch> getList() throws BGException {
        ArrayList<Dispatch> list = new ArrayList<Dispatch>();
        try {
            String query = "SELECT * FROM " + this.tableName + " LEFT JOIN dispatch_sender_type ON " + this.tableName + ".sender_type_id=dispatch_sender_type.id ORDER BY " + this.tableName + ".title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getDispatchFromRS(rs));
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return list;
    }

    protected Dispatch getImpl(int id) throws BGException, SQLException {
        Dispatch result = null;
        String query = "SELECT * FROM " + this.tableName + " LEFT JOIN dispatch_sender_type ON " + this.tableName + ".sender_type_id=dispatch_sender_type.id WHERE " + this.tableName + ".id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result = this.getFromRS(rs);
        }
        ps.close();
        return result;
    }

    public boolean checkByContactType(int contactTypeId) throws BGException {
        boolean result = false;
        try {
            String query = "SELECT id FROM " + this.tableName + " WHERE contact_type_id=? LIMIT 1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contactTypeId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = true;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public boolean isOnlyOneContact(int id) {
        boolean result = false;
        String query = "SELECT only_one_contact FROM " + this.tableName + " WHERE id = ?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next() && rs.getInt("only_one_contact") == 1) {
                result = true;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

