/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.client.directory;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.plugins.documents.client.directory.DirectoryTableModel;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentJournal;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.Id;

public class JournalEditor
extends BGUPanel {
    private BGUTable journalTable;
    private JournalTableModel journalTableModel;
    private JButton addButton = new JButton(ClientUtils.getIcon((String)"add.png"));
    private JButton deleteButton = new JButton(ClientUtils.getIcon((String)"delete.png"));
    private Directory<DocumentJournal> journalDirectory;
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refreshJournal", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0436\u0443\u0440\u043d\u0430\u043b\u044b"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            JournalEditor.this.journalTableModel.setData(JournalEditor.this.journalDirectory.list());
        }
    };
    AbstractBGUPanel.DefaultAction newAction = new AbstractBGUPanel.DefaultAction("newJournal", "\u041d\u043e\u0432\u044b\u0439 \u0436\u0443\u0440\u043d\u0430\u043b"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            List list = JournalEditor.this.journalTableModel.getRows();
            if (list.size() == 0 || ((DocumentJournal)list.get(list.size() - 1)).getId() > 0) {
                JournalEditor.this.journalTableModel.addRow(new DocumentJournal());
                JournalEditor.this.journalTable.repaint();
                JournalEditor.this.journalTable.updateUI();
            }
        }
    };
    AbstractBGUPanel.DefaultAction deleteAction = new AbstractBGUPanel.DefaultAction("deleteJournal", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0436\u0443\u0440\u043d\u0430\u043b"){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            DocumentJournal selectedRow = (DocumentJournal)JournalEditor.this.journalTableModel.getSelectedRow();
            if (selectedRow.getId() > 0) {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0441\u0442\u0440\u043e\u043a\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0440\u043e\u043a\u0438", 0) == 0) {
                    JournalEditor.this.journalDirectory.delete(selectedRow.getId());
                }
            } else if (selectedRow.getId() == 0) {
                JournalEditor.this.journalTableModel.deleteSelectedRows();
            } else {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                return;
            }
            JournalEditor.this.performAction("refreshJournal");
        }
    };

    public JournalEditor() {
        this.journalTableModel = new JournalTableModel(JournalEditor.class.getName());
    }

    protected void jbInit() throws Exception {
        this.journalDirectory = ((ClientContext)this.getContext()).getDirectory(DocumentJournal.class, -1);
        this.journalTable = new BGUTable((TableModel)((Object)this.journalTableModel));
        this.journalTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    JournalEditor.this.performAction("delete");
                }
            }
        });
        this.addButton.setToolTipText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u0436\u0443\u0440\u043d\u0430\u043b");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JournalEditor.this.performAction("newJournal");
            }
        });
        this.deleteButton.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0436\u0443\u0440\u043d\u0430\u043b");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JournalEditor.this.performAction("deleteJournal");
            }
        });
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)this.deleteButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(buttonPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)this.journalTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    class JournalTableModel
    extends DirectoryTableModel<DocumentJournal> {
        public JournalTableModel(String name) {
            super(name);
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            DocumentJournal val = (DocumentJournal)this.getSelectedRow();
            String oldValue = val.getTitle();
            String newValue = (String)value;
            if (Utils.notBlankString((String)newValue)) {
                if (oldValue != null && oldValue.equals(newValue)) {
                    return;
                }
                val.setTitle(newValue);
                try {
                    JournalEditor.this.journalDirectory.update((Id)val);
                }
                catch (BGException e) {
                    ((ClientContext)JournalEditor.this.getContext()).processException((Throwable)e);
                }
            } else if (val.getId() <= 0) {
                JournalEditor.this.performAction("refresh");
            }
            JournalEditor.this.performAction("refreshJournal");
        }
    }
}

