/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnDestroyServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnInitServer;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsService;
import ru.bitel.bgbilling.server.WebMenuBase;

public class PluginServerListener
extends WebMenuBase
implements OnInitServer,
OnDestroyServer,
EventListener<Event> {
    private static final Logger log = LogManager.getLogger();

    public void notify(Event event, EventListenerContext ctx) throws BGException {
        ContractDeleteEvent cdEvent;
        List installedModules = new ModuleManager(ctx.getConnection()).getInstalledModules(new String[]{"plugin"});
        BGInstalledModule installPlugin = installedModules.stream().filter(n -> n.getName().equals("ru.bitel.bgbilling.plugins.documents")).findFirst().get();
        if (installPlugin != null && installPlugin.isEnabled() && event instanceof ContractDeleteEvent && !(cdEvent = (ContractDeleteEvent)event).isCheck()) {
            try {
                DocumentsService documentService = (DocumentsService)ctx.getService(DocumentsService.class, event.getModuleId());
                List documentList = documentService.getDocumentList(event.getContractId(), null, null);
                List docIds = documentList.stream().map(f -> f.getId()).collect(Collectors.toList());
                documentService.deleteDocument(docIds);
            }
            catch (BGException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void onInitServer(String applicationName) {
        if (!"server".equals(applicationName)) {
            return;
        }
        try {
            EventProcessor.getInstance().addListener((EventListener)this, ContractDeleteEvent.class, 0, null);
        }
        catch (BGException e) {
            log.error("Error on add event listener", (Throwable)e);
        }
    }

    public void onDestroyServer(String applicationName) {
        if (!"server".equals(applicationName)) {
            return;
        }
        try {
            EventProcessor.getInstance().removeListener((EventListener)this);
        }
        catch (BGException e) {
            log.error("error remove event listener", (Throwable)e);
        }
    }
}

