/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drweb.server.tasks;

import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.drweb.common.bean.AgentAVD;
import ru.bitel.bgbilling.modules.drweb.server.bean.AgentAVDManager;
import ru.bitel.bgbilling.modules.drweb.server.bean.DrWebManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ProlongerAVDAgent
extends TaskBase {
    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        this.check();
        this.prolong();
        this.doChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prolong() {
        Connection con = this.setup.getDBConnectionFromPool();
        DrWebManager manager = new DrWebManager(con, (ParameterMap)this.setup.getModuleSetup(Integer.valueOf(this.moduleId)), this.moduleId);
        int day = this.taskSetup.getInt("prolong.days", 0);
        try {
            GregorianCalendar dateCheck = new GregorianCalendar();
            dateCheck.setTime(new Date());
            dateCheck.set(5, 1);
            GregorianCalendar dateTo = new GregorianCalendar();
            dateTo.setTime(dateCheck.getTime());
            dateTo.set(5, ((Calendar)dateTo).getActualMaximum(5));
            for (AgentAVD agent : manager.getAgentList(dateCheck.getTime())) {
                manager.prolongAgent(agent, dateTo.getTime());
            }
            dateCheck = new GregorianCalendar();
            dateCheck.setTime(new Date());
            if (dateCheck.get(5) + day >= ((Calendar)dateCheck).getActualMaximum(5)) {
                ((Calendar)dateCheck).add(2, 1);
                dateCheck.set(5, 1);
                dateTo = new GregorianCalendar();
                dateTo.setTime(dateCheck.getTime());
                dateTo.set(5, ((Calendar)dateTo).getActualMaximum(5));
                for (AgentAVD agent : manager.getAgentList(dateCheck.getTime())) {
                    manager.prolongAgent(agent, dateTo.getTime());
                }
            }
        }
        catch (BGException e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChanges() {
        List dayList = Utils.toIntegerList((String)this.taskSetup.get("change.tariff.days", null));
        GregorianCalendar dateNow = new GregorianCalendar();
        dateNow.setTime(new Date());
        this.log.debug("dayList=" + dayList);
        if (dayList.contains(dateNow.get(5))) {
            Connection con = this.setup.getDBConnectionFromPool();
            DrWebManager manager = new DrWebManager(con, (ParameterMap)this.setup.getModuleSetup(Integer.valueOf(this.moduleId)), this.moduleId);
            try {
                for (AgentAVD agent : manager.getLockAgent()) {
                    manager.doChanges(agent);
                }
            }
            catch (BGException e) {
                e.printStackTrace();
            }
            finally {
                ServerUtils.closeConnection((Connection)con);
            }
        }
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c DrWeb. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u0430\u0433\u0435\u043d\u0442\u043e\u0432. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ". \u0417\u0430 \u043c\u0435\u0441\u044f\u0446: " + TimeUtils.format((Calendar)this.getOperatingTime(), (String)"yyyy.MM");
    }

    private void check() {
        Connection con = this.setup.getDBConnectionFromPool();
        try (AgentAVDManager manager = new AgentAVDManager(con, this.moduleId);){
            manager.checkAgents();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ServerUtils.closeConnection((Connection)con);
    }
}

