/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drweb.server.tasks;

import bitel.billing.server.util.MailMsg;
import java.util.Calendar;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskRecalculator;
import ru.bitel.bgbilling.modules.drweb.server.tasks.Calculator;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class Recalculator
extends RunTaskRecalculator<Calculator> {
    private String cids;
    private String comment = null;

    public Recalculator(int mid, Calendar dt, String cids, String email, String comment) {
        dt.set(5, 2);
        this.mid = mid;
        this.dt = dt;
        this.email = email;
        this.cids = cids;
        this.comment = comment;
    }

    protected void executeTask() {
        this.log.info("PaymentRecalculator time: " + TimeUtils.format((Calendar)this.dt, (String)"dd.MM.yyyy HH"));
        long time = System.currentTimeMillis();
        this.createTask().startTask();
        time = System.currentTimeMillis() - time;
        if (this.email != null) {
            String subject = "\u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 Dr.Web \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e";
            StringBuffer report = new StringBuffer(subject);
            report.append("\n\u0412\u0440\u0435\u043c\u044f: ");
            report.append(TimeUtils.formatDeltaTime((long)(time / 1000L)));
            MailMsg msg = new MailMsg((Preferences)this.setup);
            try {
                msg.sendMessage(this.email, subject, report.toString());
            }
            catch (BGException e) {
                StringBuilder errMessage = new StringBuilder();
                errMessage.append("email = " + this.email);
                errMessage.append("; subject = " + subject);
                errMessage.append("; text = " + report.toString());
                errMessage.append("; errMessage = " + e.getMessage());
                this.log.error(errMessage.toString());
            }
        }
    }

    protected Calculator createTask() {
        Calculator calculator = new Calculator();
        calculator.setExecutingTime(this.dt);
        calculator.initTask(Setup.getSetup(), 0, "mid=" + this.mid + "\ncomment=" + this.comment);
        calculator.setCids(this.cids);
        return calculator;
    }
}

