/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.action;

import bitel.billing.server.contract.bean.ContractUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNote;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractNoteDao;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.email.server.bean.AttributeValue;
import ru.bitel.bgbilling.modules.email.server.bean.AttributeValueManager;
import ru.bitel.bgbilling.modules.email.server.bean.DomainManager;
import ru.bitel.bgbilling.modules.email.server.bean.Forward;
import ru.bitel.bgbilling.modules.email.server.bean.ForwardManager;
import ru.bitel.bgbilling.modules.email.server.event.AccountCreatedEvent;
import ru.bitel.bgbilling.modules.email.server.event.AccountDeleteEvent;
import ru.bitel.common.TimeUtils;

public class ActionMoveEmail
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", 0);
        int cidTo = this.getIntParameter("cid_to", -1);
        Date dateFrom = this.getDateParameter("from_date", null);
        if (this.mid <= 0 || id <= 0 || this.cid <= 0 || cidTo <= 0) {
            throw new BGIllegalArgumentException();
        }
        AccountManager manager = new AccountManager(this.con, this.mid);
        Account account = manager.getAccountById(id);
        if (account == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0441 \u043a\u043e\u0434\u043e\u043c " + id);
        }
        try (DomainManager dm = new DomainManager(this.con, this.mid);
             ContractNoteDao noteDao = new ContractNoteDao(this.con);){
            Domain domain = dm.get(account.getDomainId());
            String domainName = domain != null ? domain.getName() : "???";
            ContractUtils cu = new ContractUtils(this.con);
            ContractNote contractNote = new ContractNote();
            StringBuilder memoText = new StringBuilder(300);
            memoText.append("Email " + account.getAccount() + "@" + domainName);
            memoText.append(" \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d \u0438\u0437 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + cu.getContractTitle(this.cid, true));
            memoText.append(" \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + cu.getContractTitle(cidTo, true));
            contractNote.setTitle("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d email");
            contractNote.setComment(memoText.toString());
            contractNote.setUserId(this.userId.intValue());
            contractNote.setContractId(this.cid);
            noteDao.update((Object)contractNote);
            contractNote.setId(0);
            contractNote.setContractId(cidTo);
            noteDao.update((Object)contractNote);
            if (dateFrom != null) {
                List<Forward> forwardList;
                if (TimeUtils.dateBefore((Date)dateFrom, (Date)new Date()) || account.getDate2() != null && TimeUtils.dateBefore((Date)account.getDate2(), (Date)dateFrom)) {
                    throw new BGMessageException("\u041d\u0435 \u0432\u0435\u0440\u043d\u0430\u044f \u0434\u0430\u0442\u0430 \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430!");
                }
                AttributeValueManager attributeValueManager = new AttributeValueManager(this.con, this.mid);
                ForwardManager forwardManager = new ForwardManager(this.con, this.mid);
                Account moveAccount = manager.getAccountById(id);
                moveAccount.setId(0);
                moveAccount.setContractId(cidTo);
                moveAccount.setDate1(dateFrom);
                moveAccount.setNeedOpenAndNeedClose(dateFrom);
                manager.updateAccount(moveAccount);
                List<AttributeValue> attrList = attributeValueManager.getValueList(account.getId());
                if (!attrList.isEmpty()) {
                    attributeValueManager.updateValues(moveAccount.getId(), attrList);
                }
                if (!(forwardList = forwardManager.getForwardList(account.getId())).isEmpty()) {
                    forwardManager.updateForwardList(moveAccount.getId(), forwardList);
                }
                account.setDate2(dateFrom);
                account.setNeedOpenAndNeedClose(dateFrom);
            } else {
                account.setContractId(cidTo);
            }
            manager.updateAccount(account);
            if (dateFrom == null) {
                this.context.publishAfterCommit((Event)new AccountDeleteEvent(this.userId, this.mid, this.cid, account.getAccount() + "@" + domain.getName()));
            }
            this.context.publishAfterCommit((Event)new AccountCreatedEvent(this.userId, this.mid, cidTo, account.getAccount() + "@" + domain.getName()));
        }
    }
}

