<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="layout.xsl"/>


<xsl:template name="title">
<xsl:choose>
	<xsl:when test="data/@action = 'Account'">Управление ящиками</xsl:when>
	<xsl:when test="data/@action = 'Password'">Смена пароля на ящики</xsl:when>
	<xsl:when test="data/@action = 'Forward'">Пересылки</xsl:when>
</xsl:choose>
</xsl:template>


<xsl:template match="/data">
<xsl:choose>
	<xsl:when test="@action = 'Account'">
		<xsl:call-template name="Account"/>
	</xsl:when>
	<xsl:when test="@action = 'Password'">
	 	<xsl:call-template name="Password"/>
	</xsl:when>
	<xsl:when test="@action = 'Forward'">
	 	<xsl:call-template name="Forward"/>
	</xsl:when>
</xsl:choose>
</xsl:template>


<!-- смена пароля на ящики -->
<xsl:template name="Password">
	<form method='post' action='{$WEBEXECUTER}'>
		<xsl:call-template name="action"/>
		<xsl:call-template name="error"	/>
		<xsl:if test="@status = 'ok'"><div class="infoMessage">Пароль изменен!</div></xsl:if>
		<div class="report">
			<table cellspacing='1'>
			<col/>
			<col style="width: 150px;" />
			<tbody>
				<tr>
    				<td nowrap='1'>Почтовый ящик</td>
	    			<td>
     					<select name="account">
        					<xsl:call-template name="account_list"/>
        				</select>
        			</td>
				</tr>  
    			<tr>
    				<td nowrap='1'>Старый пароль:</td>
					<td><input type='password' name='old_pswd' maxlength='15' style="width: 96%;"/></td>
				</tr>
    			<tr>
        			<td nowrap='1'>Новый пароль:</td>
					<td><input type='password' name='pswd1' maxlength='15' style="width: 96%;"/></td>
				</tr>
				<tr>
					<td nowrap='1'>Повторите пароль:</td>
					<td><input type='password' name='pswd2' maxlength='15' style="width: 96%;"/></td>
				</tr>
			</tbody>
			<tfoot>
				<tr>
					<td colspan='2'>
						<xsl:call-template name="submit"><xsl:with-param name="title" select="'Сменить'"/></xsl:call-template>
					</td>
				</tr>
			</tfoot>
			</table>
		</div>
	</form>
</xsl:template>

<!-- управление ящиками -->
<xsl:template name="Account">
		
	<xsl:variable name="module" select="/data/@module"/>
	<xsl:variable name="mid" select="/data/@mid"/>
			
	<div class="report">
		<table cellspacing='1' class="table800">
			<thead>
			   <tr>
			       <td>E-Mail</td>
			       <td>Период</td>
			       <td>Статус</td>
			       <td>Квота</td>
			       <td>Удаление</td>
			  </tr>
			</thead>
			<tbody>
		      <xsl:for-each select="accounts/row">
		        <tr>
		           	<td><xsl:value-of select="@email"/></td>
		           	<td><xsl:value-of select="@period"/></td>
		            <td><xsl:value-of select="@status_label"/></td>
		            <td><xsl:value-of select="@quota"/></td>
		            <td>
						<xsl:call-template name="button">
							<xsl:with-param name="align" select="'center'"/>
							<xsl:with-param name="title" select="'Удалить'"/>
							<xsl:with-param name="onclick">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=Account&amp;command=delete&amp;account=<xsl:value-of select="@id"/>&amp;module=<xsl:value-of select="$module"/>&amp;mid=<xsl:value-of select="$mid"/>');</xsl:with-param>
						</xsl:call-template>
					</td>               
		         </tr>
		       </xsl:for-each>
			</tbody>
		</table>
				
		<xsl:if test="/data/perm/@create">
			<form method='post' action='{$WEBEXECUTER}' name="sessions">
				<input type="hidden" name="command" value="create"/>
				<xsl:call-template name="action"/>
			
				<table cellspacing="1" style="margin-top: 20px;">
					<thead>
						<tr>
						<td colspan="2">Добавление почтового ящика</td>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td nowrap="1">Имя:</td>
							<td nowrap="1">
								<input type="text" size="20" name="accountName"/>@
								<select name="domain">
									<xsl:call-template name="domain_list"/>
								</select>
							</td>
						</tr>
						<tr>
							<td>Пароль:</td>
							<td>
								<input type="password" name="accountPassword1" style="width:96%"/>
							</td>
						</tr>
						<tr>
							<td>еще раз:</td>
							<td>
								<input type="password" name="accountPassword2" style="width:96%"/>
							</td>				
						</tr>
					</tbody>					
					<tfoot>
						<tr><td colspan="2"><div>
							<xsl:call-template name="submit">
								<xsl:with-param name="title" select="'Создать ящик'"/>
							</xsl:call-template>
						</div></td></tr>
					</tfoot>						
				</table>
			</form>
		</xsl:if>
	</div>
</xsl:template>


<!-- пересылки -->
<xsl:template name="Forward">
		
	<xsl:variable name="module" select="/data/@module"/>
	<xsl:variable name="mid" select="/data/@mid"/>
	
	<!-- форма смены текущего аккаунта -->
	<form method='post' action='{$WEBEXECUTER}'>	
		<xsl:call-template name="action"/>
		<table class="filter">
			<tr>
				<td>Ящик:</td>
				<td>
					<select name="account">
						<xsl:call-template name="account_list"/>
					</select>
				</td>
				<td>
					<xsl:call-template name="submit">
						<xsl:with-param name="title" select="'>>>'"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
	</form>	
	
	<xsl:if test="/data/account_list/@id">
		<div class="report">
			<table cellspacing="1" class="table800">
			<col style="width: 80%;"/>
			<col/>
			<thead>
				<tr>
					<td>Адрес</td>
					<td>Удалить</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="/data/forward_list/item">
				<tr>
					<td>
						<xsl:value-of select="@title"/>
					</td>
					<td>
						<xsl:call-template name="button">
							<xsl:with-param name="align" select="'center'"/>
							<xsl:with-param name="title" select="'Удалить'"/>
							<xsl:with-param name="onclick">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=Forward&amp;account=<xsl:value-of select="/data/account_list/@id"/>&amp;command=delete&amp;forward=<xsl:value-of select="@id"/>&amp;module=<xsl:value-of select="$module"/>&amp;mid=<xsl:value-of select="$mid"/>');</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
				</xsl:for-each>
			</tbody>
			</table>
		</div>
		
		<!-- форма добавления пересылки -->
		<xsl:for-each select="/data/perm/@forward">
			<form method='post' action='{$WEBEXECUTER}'>	
				<xsl:call-template name="action"/>
				<xsl:variable name="account" select="/data/account_list/@id"/>
				<input type="hidden" name="account">
					<xsl:attribute name="value"><xsl:value-of select="$account"/></xsl:attribute>
				</input> 
				<input type="hidden" name="command" value="add"/>
				
				<table style="margin-top: 10px;" class="filter">
					<col class="col1"/>
					<col class="col2"/>
						<tr>
							<td>Адрес:</td>
					    	<td>
					        	<input type="text" name="forward" />
							</td>
							<td>
								<xsl:call-template name="submit">
									<xsl:with-param name="title" select="'Добавить'"/>									
								</xsl:call-template>
					        </td>
						</tr>                
				</table>
			</form>
		</xsl:for-each>		
	</xsl:if>	
</xsl:template>

<!-- ################ набор вспомогательных шаблонов ################## -->
<xsl:template name="account_list">
     <xsl:for-each select="/data/account_list/item">
          <option>
              <xsl:if test="/data/account_list/@id=@id"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
              <xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
              <xsl:value-of select="@title"/>
          </option>
      </xsl:for-each>
</xsl:template>

<xsl:template name="domain_list">
     <xsl:for-each select="/data/domain_list/item">
          <option>
              <xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
              <xsl:value-of select="@title"/>
          </option>
      </xsl:for-each>
</xsl:template>

</xsl:stylesheet>