/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.server.service;

import java.sql.Connection;
import java.util.List;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.City;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.Street;
import ru.bitel.bgbilling.plugins.fias.common.service.FiasSyncService;
import ru.bitel.bgbilling.plugins.fias.server.bean.AddressLoadManager;
import ru.bitel.bgbilling.plugins.fias.server.bean.HouseLoadManager;
import ru.bitel.bgbilling.plugins.fias.server.util.FiasUtil;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Result;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.fias.common.service.FiasSyncService")
public class FiasSyncServiceImpl
extends AbstractService
implements FiasSyncService {
    private AddressLoadManager getFiasAddressManager(Connection con) {
        return new AddressLoadManager(con);
    }

    public Result<City> getCityList() throws BGMessageException, BGException {
        AddressLoadManager fm = this.getFiasAddressManager(this.getConnection());
        List<City> list = fm.getCityList();
        return new Result(list);
    }

    public void syncCity(List<City> citys) throws BGMessageException, BGException {
        FiasUtil.syncCityList(citys);
        AddressLoadManager lm = new AddressLoadManager(this.getConnection());
        lm.clearFiasTable();
        for (City city : citys) {
            if (Utils.isEmptyString((String)city.getAoguid())) continue;
            lm.updateCity(city);
        }
    }

    public void changeBillingCityName(int cityId, String name) throws BGMessageException, BGException {
        AddressLoadManager lm = new AddressLoadManager(this.getConnection());
        lm.updateCityBgTitle(cityId, name);
    }

    public void syncStreet(List<Street> streets) throws BGMessageException, BGException {
        FiasUtil.syncStreetList(streets);
        AddressLoadManager lm = new AddressLoadManager(this.getConnection());
        lm.clearFiasTable();
        for (Street street : streets) {
            lm.updateStreet(street);
        }
    }

    public void changeBillingStreetName(List<Street> streets) throws BGMessageException, BGException {
        AddressLoadManager lm = new AddressLoadManager(this.getConnection());
        lm.updateStreetBgTitle(streets);
    }

    public Result<Street> getStreetList(City city) throws BGMessageException, BGException {
        AddressLoadManager fm = this.getFiasAddressManager(this.getConnection());
        List<Street> list = fm.getStreetList(city);
        return new Result(list);
    }

    public void syncHouse(List<City> citys, boolean loadNew) throws BGMessageException, BGException {
        Connection con = this.getConnection();
        try {
            con.setAutoCommit(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HouseLoadManager manager = new HouseLoadManager(con);
        manager.syncHouse(citys, loadNew);
    }
}

