/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.task;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.hd.common.bean.Zone;
import ru.bitel.bgbilling.modules.hd.server.bean.ZoneDAO;
import ru.bitel.bgbilling.modules.hd.server.task.ZoneTaskUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class UpdateZone
extends TaskBase {
    private String login = null;
    private String urlServer = null;
    private String dnsPath = null;
    Connection con = null;

    protected boolean initTask() {
        this.login = this.taskSetup.get("login", null);
        this.urlServer = this.taskSetup.get("urlServer", null);
        this.dnsPath = this.taskSetup.get("dnsPath", "/var/named/bgzones/");
        this.con = this.setup.getDBConnectionFromPool();
        if (this.login == null && this.urlServer == null && this.moduleId < 0) {
            this.log.error("Some param not found!");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        try {
            ZoneDAO zoneManager = new ZoneDAO(this.con, this.moduleId);
            List<Zone> zoneList = zoneManager.getModifiedZoneList(true);
            for (Zone zone : zoneList) {
                Map<String, String> zoneFields = ZoneTaskUtils.getZoneContent(zone.getConfig());
                ZoneTaskUtils.createZoneFile(zone, zoneFields);
            }
            ZoneTaskUtils.createMasterFile(zoneManager.getZoneList());
            this.sendZonesToServer();
            this.restoreZones(zoneList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ZoneTaskUtils.deleteTempFiles();
            ServerUtils.closeConnection((Connection)this.con);
        }
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c HD. \u0417\u0430\u0434\u0430\u0447\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0437\u043e\u043d \u043d\u0430 DNS-\u0441\u0435\u0440\u0432\u0435\u0440\u0435";
    }

    private void sendZonesToServer() {
        System.out.println(((Object)((Object)this)).getClass().getResource(".").getPath());
        String scriptPath = ((Object)((Object)this)).getClass().getResource("./script/uploader.sh").toString();
        StringBuilder command = new StringBuilder(scriptPath.substring(5, scriptPath.length()));
        ZoneTaskUtils.setExecutable(command.toString());
        command.append(" " + this.urlServer);
        command.append(" " + this.login);
        command.append(" " + ZoneTaskUtils.ZONE_TMP_DIR);
        command.append(" " + this.dnsPath);
        ZoneTaskUtils.executeScript(command.toString());
    }

    private void restoreZones(List<Zone> modifiedZoneList) {
        for (Zone zone : modifiedZoneList) {
            zone.setLastUpdate(new Date(0L));
            new ZoneDAO(this.con, this.moduleId).updateZone(zone);
        }
    }
}

