/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.client.contract;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.contract.ContractEditor;
import bitel.billing.module.contract.ContractPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.plugins.helpdesk.client.contract.HelpdeskMessageTab;
import ru.bitel.bgbilling.plugins.helpdesk.client.contract.HelpdeskPackageTab;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskDirectoryService;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskParamService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.DirectoryItem;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ContractPanel_Helpdesk
extends ContractPanel {
    private JLabel title = new JLabel();
    private boolean comboBoxUpdateFlag = false;
    private ClientContext clientContext = null;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private BGComboBox<DirectoryItem> modeComboBox = new BGComboBox();
    private BGComboBox<DirectoryItem> groupComboBox = new BGComboBox();
    private HelpdeskMessageTab messageTab = null;

    public ContractPanel_Helpdesk() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            this.getContext().processException((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.title = new JLabel("");
        this.title.setToolTipText("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 ( \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 )");
        Font font = this.title.getFont();
        if (font.getSize() < 12) {
            this.title.setFont(font.deriveFont(1, (float)font.getSize() + 3.0f));
        } else {
            this.title.setFont(font.deriveFont((float)font.getSize() + 3.0f));
        }
        this.title.setHorizontalAlignment(2);
        this.modeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!ContractPanel_Helpdesk.this.comboBoxUpdateFlag) {
                    String modeId = ((DirectoryItem)ContractPanel_Helpdesk.this.modeComboBox.getSelectedItem()).getId();
                    ContractPanel_Helpdesk.this.messageTab.contractModeChanged(modeId);
                    Request request = new Request();
                    request.setModule("ru.bitel.bgbilling.plugins.helpdesk");
                    request.setAction("UpdateContractMode");
                    request.setContractId(ContractPanel_Helpdesk.this.getContext().getContractId());
                    request.setAttribute("mode", modeId);
                    ClientUtils.checkStatus((Document)ContractPanel_Helpdesk.this.getDocument(request));
                    ContractPanel_Helpdesk.this.messageTab.performAction("refresh");
                }
            }
        });
        this.groupComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DirectoryItem itemHelpDesk = (DirectoryItem)ContractPanel_Helpdesk.this.groupComboBox.getSelectedItem();
                Request requestGroup = new Request();
                requestGroup.setModule("ru.bitel.bgbilling.plugins.helpdesk");
                requestGroup.setAction("ContractGroupUpdate");
                requestGroup.setAttribute("idGroup", itemHelpDesk.getId());
                requestGroup.setContractId(ContractPanel_Helpdesk.this.getContext().getContractId());
                ClientUtils.checkStatus((Document)ContractPanel_Helpdesk.this.getDocument(requestGroup));
            }
        });
        JPanel titlePanel = new JPanel(new GridBagLayout());
        titlePanel.setBorder((Border)new BGTitleBorder(" \u0414\u043e\u0433\u043e\u0432\u043e\u0440 "));
        titlePanel.add((Component)this.title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel modePanel = new JPanel(new GridBagLayout());
        modePanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0436\u0438\u043c "));
        modePanel.add((Component)this.modeComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel groupPanel = new JPanel(new GridBagLayout());
        groupPanel.setBorder((Border)new BGTitleBorder(" \u0413\u0440\u0443\u043f\u043f\u0430 "));
        groupPanel.add((Component)this.groupComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)titlePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        topPanel.add((Component)groupPanel, new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        topPanel.add((Component)modePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(topPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.tabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void init(ContractEditor editor) {
        super.init(editor);
        this.messageTab = new HelpdeskMessageTab(this.getContext());
        this.tabbedPane.add("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f", (Component)((Object)this.messageTab));
        this.tabbedPane.add("\u041f\u0430\u043a\u0435\u0442\u044b", (Component)((Object)new HelpdeskPackageTab(this.getContext())));
        this.tabbedPane.addChangeListener(e -> this.setPanelData());
        this.setPanelData();
    }

    public ClientContext getContext() {
        if (this.clientContext == null) {
            this.clientContext = new ClientContext(super.getContext(), "ru.bitel.bgbilling.plugins.helpdesk", -1, null);
        }
        return this.clientContext;
    }

    private void setPanelData() {
        BGUPanel panel = this.getSelectedTab();
        if (panel != null) {
            panel.performAction("refresh");
        }
    }

    public void setData() {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ContractTitleAndComment");
        request.setContractId(this.getContext().getContractId());
        Document doc = TransferManager.getDocument((Request)request);
        if (ClientUtils.checkStatus((Document)doc)) {
            String titl = XMLUtils.selectText((Node)doc, (String)"/data/contract/@title", (String)"");
            String comment = XMLUtils.selectText((Node)doc, (String)"/data/contract/@comment", (String)"");
            this.title.setText(titl + " [ " + comment + " ]");
        }
        ClientContext clientContext = this.getContext();
        try {
            String currentMode = ((HelpdeskParamService)clientContext.getPort(HelpdeskParamService.class)).getContractCurrentMode(this.getContext().getContractId());
            DefaultComboBoxModel<DirectoryItem> model = new DefaultComboBoxModel<DirectoryItem>();
            for (DirectoryItem item : ((HelpdeskParamService)clientContext.getPort(HelpdeskParamService.class)).getModeList()) {
                model.addElement(item);
                if (currentMode == null || !currentMode.equals(item.getId())) continue;
                model.setSelectedItem(item);
            }
            this.comboBoxUpdateFlag = true;
            this.modeComboBox.setModel(model);
            this.comboBoxUpdateFlag = false;
            SearchResult searchResult = ((HelpdeskDirectoryService)clientContext.getPort(HelpdeskDirectoryService.class)).getGroupList(false, this.getContext().getContractId(), new Page(1, 0));
            int selectGroupId = Utils.parseInt((String)searchResult.getAttribute("selectGroupId"));
            DirectoryItem selectedItem = new DirectoryItem("-2", "-----");
            model = new DefaultComboBoxModel();
            model.addElement(selectedItem);
            for (IdTitle item : searchResult.getList()) {
                DirectoryItem directoryItem = new DirectoryItem(String.valueOf(item.getId()), item.getTitle());
                model.addElement(directoryItem);
                if (item.getId() != selectGroupId) continue;
                selectedItem = directoryItem;
            }
            this.groupComboBox.setModel(model);
            this.groupComboBox.setSelectedItem((Object)selectedItem);
        }
        catch (Exception ex) {
            this.getContext().processException((Throwable)ex);
        }
        this.setPanelData();
    }

    public void newItem() {
        BGUPanel panel = this.getSelectedTab();
        if (panel != null) {
            panel.performAction("new");
        }
    }

    public void editItem() {
        BGUPanel panel = this.getSelectedTab();
        if (panel != null) {
            panel.performAction("edit");
        }
    }

    private BGUPanel getSelectedTab() {
        return (BGUPanel)this.tabbedPane.getSelectedComponent();
    }

    public void setParameter(Object parameter) {
        Integer id = (Integer)parameter;
        if (id != null) {
            this.messageTab.openTopic(Utils.parseInt((String)String.valueOf(id)));
        }
    }
}

