<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<c:set var="currency"><span class="CUR"></span></c:set>

<div class="tile">
	<div class="flexRow">
		<div class="titleFont3">Остаток на <fmt:formatDate value="${balanceDatetime}" type="BOTH" dateStyle="SHORT" timeStyle="SHORT" /></div>
		<div class="titleFont3" style="text-align: right;"><fmt:formatNumber value="${balanceSum}" groupingUsed="true" maxFractionDigits="2" minFractionDigits="2" currencyCode="" />${currency}</div>
	</div>
	<div style="font-size: 90%;">
		<span class="paramColor" style="display: inline-block; padding-right: 2em;">Лимит: <fmt:formatNumber type="number" pattern="###,###,##0.00" value="${webBalanceData.contract.balanceLimit}"/></span><span class="CUR"></span>
		<span class="paramColor" style="display: inline-block; padding-right: 2em;">Статус: ${contractStatusMap[contractRuntime.status]}</span> 
	</div>
</div>

<c:if test="${not empty dataMap['messages']}">
<div class="tile">
	<c:forEach var="message" varStatus="status" items="${dataMap['messages']}">
		<div>${message}</div>
		<c:if test="${not status.last}"><div class="line"></div></c:if>
	</c:forEach>
</div>	
</c:if>

<c:if test="${not empty balancePayments}">
<div class="tile">
	<div class="flexRow" style="margin-bottom: 10px;">
		<div class="titleFont3">Платежи</div>
		<div style="text-align: right; cursor: pointer;" onclick="showBlock( 'balanceRoot', 'payments', balanceQuery ); return false;"><img src="img/right.png" height="24"></div>
	</div>
	<c:forEach var="item" varStatus="status" items="${balancePayments}">
		<div class="flexRow" style="margin: 10px 5px 5px 10px; color: #555;">
			<div>
				<div style="overflow: auto;">
					<span style="float: left; margin-right: 15px;"><fmt:formatDate value="${item.date}" dateStyle="SHORT" /></span>
					<span style="float: left; font-weight: bold;">${balancePaymentTypes[item.typeId].guiTitle}</span>
				</div>
				<div style="margin-top: 5px;" class="paramColor">${item.comment}</div>
			</div>
			<div class="sum3"><fmt:formatNumber value="${item.sum}" groupingUsed="true" maxFractionDigits="2" minFractionDigits="2"/><span class="CUR"></span></div>
		</div>
		<c:if test="${not status.last}"><div class="line"></div></c:if>
	</c:forEach>
</div>
</c:if>

<c:if test="${not empty balanceCharges}">
<div class="tile">
	<div class="flexRow">
		<div class="titleFont3">Списания</div>
		<div style="text-align: right;"><a href="" onclick="showBlock( 'balanceRoot', 'charges', balanceQuery ); return false;"><img src="img/right.png" height="24"></a></div>
	</div>
	<c:forEach var="item" varStatus="status" items="${balanceCharges}">
		<div class="flexRow" style="margin: 10px 5px 5px 10px; color: #555;">
			<div>
				<div style="overflow: auto;">
					<span style="float: left; margin-right: 15px;"><fmt:formatDate value="${item.date}" dateStyle="SHORT" /></span>
					<span style="float: left; font-weight: bold;">${balanceChargeTypes[item.typeId].guiTitle}</span>
				</div>
				<div style="margin-top: 5px;" class="paramColor">${item.comment}</div>
			</div>
			<div class="sum3"><fmt:formatNumber value="${item.sum}" groupingUsed="true" maxFractionDigits="2" minFractionDigits="2"/><span class="CUR"/></div>
		</div>
		<c:if test="${not status.last}"><div class="line"></div></c:if>
	</c:forEach>
</div>
</c:if>

<div class="tile">
	<div class="flexRow">
		<div class="titleFont3">Наработка</div>
		<div style="text-align: right;"><a href="" onclick="showBlock( 'balanceRoot', 'accounts', balanceQuery ); return false;"><img src="img/right.png" height="24"></a></div>
	</div>
	<c:forEach var="item" varStatus="status" items="${balanceAccounts}">
		<div class="flexRow" style="margin: 10px 5px 5px 10px; color: #555;">
			<div>
				<div style="overflow: auto;">
					<span style="float: left; margin-right: 15px; width: 7em;"><fmt:formatDate value="${item[0]}" pattern="LLLL yyyy" /></span>
					<span style="float: left; font-weight: bold;">${item[1]}</span>
				</div>
				<div style="margin-top: 5px;" class="paramColor"></div>
			</div>
			<div class="sum3"><fmt:formatNumber value="${item[2]}" groupingUsed="true" maxFractionDigits="2" minFractionDigits="2"/><span class="CUR"></span></div>
		</div>
		<c:if test="${not status.last}"><div class="line"></div></c:if>
	</c:forEach>
</div>

<table style="width: 100%">
	<tr class="foot"><td>
		<c:if test="${dataMap['has_independent_subs']==1}">
			<br>
			<form method='GET' action='' style="margin: 0px 0px;">
				<input type="hidden" name="action" value="DistributeBalance"/>
				<input type="hidden" name="module" value="contract"/>
				<input type="hidden" name="mid" value="0"/>
				<input type="submit" value="Перенос средств"/> 
			</form>
		</c:if>
	</td></tr>
</table>
