/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.action;

import bitel.billing.server.call.action.base.ActionBase;
import bitel.billing.server.call.bean.ReportUtils;
import bitel.billing.server.call.bean.VoiceUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class ActionLoginDirect
extends ActionBase {
    private HashMap<String, String> parameterMap;

    @Override
    public void doAction() throws SQLException, BGException {
        this.direct(this.getPeriod(), Utils.toIntegerList((String)this.getParameter("id")));
    }

    private List<Range> loadColorRanges(String name, String def) {
        String[] ranges;
        ArrayList<Range> result = new ArrayList<Range>();
        String asr = this.moduleSetup.get(name, def);
        for (String _range : ranges = asr.split("\\s*;\\s*")) {
            int col;
            String[] range = _range.split("\\s*:\\s*");
            if (range.length != 2) continue;
            String[] r = range[0].split("\\s*-\\s*");
            String[] color = range[1].split("#");
            if (color.length != 1 && color.length != 2) continue;
            try {
                col = Integer.parseInt(color[color.length - 1], 16);
            }
            catch (Exception ex) {
                col = Color.WHITE.getRGB();
            }
            if (r.length == 2) {
                result.add(new Range(Utils.parseInt((String)r[0], (int)0), Utils.parseInt((String)r[1], (int)0), col));
                continue;
            }
            if (r.length != 1) continue;
            result.add(new Range(Utils.parseInt((String)r[0], (int)0), Utils.parseInt((String)r[0], (int)0), col));
        }
        return result;
    }

    private int getColor(List<Range> list, int value) {
        for (Range r : list) {
            if (r.from > value || r.until < value) continue;
            return r.color;
        }
        return Color.WHITE.getRGB();
    }

    public void direct(Period period, int lid) throws SQLException, DOMException, BGException {
        this.direct(period, Collections.singletonList(lid));
    }

    public void direct(Calendar now, int loginId) throws DOMException, SQLException, BGException {
        Period period = new Period(now.get(1), now.get(2), 1, now.getActualMaximum(5));
        this.direct(period, Collections.singletonList(loginId));
    }

    public void direct(Period period, List<Integer> lids) throws SQLException, DOMException, BGException {
        String xsl;
        String output = this.getParameter("output");
        Object xslSetupName = "xslt.3";
        if (output != null && output.equals("csv")) {
            xslSetupName = (String)xslSetupName + ".csv";
        }
        if ((xsl = this.moduleSetup.get((String)xslSetupName, null)) != null) {
            this.rootNode.setAttribute("xslt", xsl);
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        String whatSelect = " SQL_CALC_FOUND_ROWS dest_code, SUM(session_time) AS time , SUM(round_session_time) as roundTime, SUM(session_cost) AS sum, COUNT(id) AS count ";
        String group = " GROUP BY dest_code";
        String order = this.getParameter("order", "");
        String orderStr = null;
        if (!Utils.isEmptyString((String)order) && !order.equals("name")) {
            orderStr = " ORDER BY " + order;
        }
        VoiceUtils vu = this.getVoiceUtils();
        ReportUtils lu = this.getReportUtils();
        Page page = this.getPage();
        boolean showAll = this.getIntParameter("show_all", -1) >= 0;
        HashMap noFreeCountMap = !showAll ? this.getNoFreeCountMap(period, lids, " GROUP BY dest_code", lu, page) : new HashMap();
        String filter = this.getVoice_VoipFilter();
        PreparedStatement ps = lu.selectSomethingFromSessions(lids, period, " SQL_CALC_FOUND_ROWS dest_code, SUM(session_time) AS time , SUM(round_session_time) as roundTime, SUM(session_cost) AS sum, COUNT(id) AS count ", filter, " GROUP BY dest_code", orderStr, showAll ? null : this.getPage().sqlLimit());
        if (ps != null) {
            ResultSet rs = ps.executeQuery();
            if (!showAll) {
                int col = ServerUtils.foundRows(this.con);
                page.setRecordCount(col);
                this.setPageAttribute(table, page);
            }
            int _count = 0;
            int _time = 0;
            int _round_time = 0;
            BigDecimal _money = BigDecimal.ZERO;
            List<Range> asrRanges = this.loadColorRanges("color.asr", "");
            List<Range> acdRanges = this.loadColorRanges("color.acd", "");
            ArrayList<Object> rows = new ArrayList<Object>();
            if (rs != null) {
                while (rs.next()) {
                    HashMap item = new HashMap();
                    int n = rs.getInt("time");
                    _time += n;
                    int round_time = rs.getInt("roundTime");
                    _round_time += round_time;
                    BigDecimal money = rs.getBigDecimal("sum");
                    _money = _money.add(money);
                    int count = rs.getInt("count");
                    _count += count;
                    int destId = rs.getInt(1);
                    item.put("dest", vu.getDestTitle(destId));
                    item.put("count", String.valueOf(count));
                    item.put("time", Utils.formatSessionTime((int)n));
                    item.put("round_time", Utils.formatSessionTime((int)round_time));
                    item.put("cost", money.toPlainString());
                    item.put("dest_code", String.valueOf(destId));
                    int noFreeCount = noFreeCountMap.get(destId) != null ? (Integer)noFreeCountMap.get(destId) : 0;
                    int asr = Math.round((float)noFreeCount / (float)count * 100.0f);
                    if (count != 0) {
                        item.put("asr", this.getColor(asrRanges, asr) + ";" + String.valueOf(asr) + "%");
                    }
                    int acd = Math.round((float)round_time / (float)count);
                    item.put("acd", this.getColor(acdRanges, acd) + ";" + Utils.formatSessionTime((int)acd));
                    rows.add(item);
                }
            }
            rs.close();
            ps.close();
            if (order.equals("name")) {
                Collections.sort(rows, new ItemSort());
            }
            for (Map map : rows) {
                Element row = this.createElement(data, "row");
                row.setAttribute("dest", (String)map.get("dest"));
                row.setAttribute("count", (String)map.get("count"));
                row.setAttribute("time", (String)map.get("time"));
                row.setAttribute("round_time", (String)map.get("round_time"));
                row.setAttribute("cost", (String)map.get("cost"));
                row.setAttribute("dest_code", (String)map.get("dest_code"));
                row.setAttribute("asr", (String)map.get("asr"));
                row.setAttribute("acd", (String)map.get("acd"));
            }
            lu.addSums(data, lids, period, filter);
            this.addReportParams(period, lu, lids, table);
            String reportTitle = this.moduleSetup.get("reportTitle.3", "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f\u043c VoiceIP");
            table.setAttribute("reportTitle", reportTitle);
        }
    }

    private Map<Integer, Integer> getNoFreeCountMap(Period period, List<Integer> lids, String group, ReportUtils lu, Page page) throws SQLException {
        HashMap<Integer, Integer> noFreeCountMap = new HashMap<Integer, Integer>();
        PreparedStatement ps2 = lu.selectSomethingFromSessions(lids, period, "dest_code, COUNT(id) as count", this.getVoice_VoipFilter(false) + " AND session_cost!=0 ", group, null, page.sqlLimit());
        ResultSet rs2 = ps2.executeQuery();
        while (rs2.next()) {
            int destId = rs2.getInt("dest_code");
            int count = rs2.getInt("count");
            noFreeCountMap.put(destId, count);
        }
        ps2.close();
        return noFreeCountMap;
    }

    public void setParameterMap(HashMap<String, String> parameterMap) {
        this.parameterMap = parameterMap;
    }

    @Override
    protected String getParameter(String name, String defaultValue) {
        if (this.request != null) {
            return super.getParameter(name, defaultValue);
        }
        String value = defaultValue;
        if (this.parameterMap != null) {
            value = this.parameterMap.get(name);
        }
        return value;
    }

    @Override
    protected int getIntParameter(String name, int defaultValue) {
        if (this.request != null) {
            return super.getIntParameter(name, defaultValue);
        }
        int value = defaultValue;
        if (this.parameterMap != null) {
            value = Integer.parseInt(this.parameterMap.get(name));
        }
        return value;
    }

    private class Range {
        private int from;
        private int until;
        private int color;

        public Range(int from, int until, int color) {
            this.from = from;
            this.until = until;
            this.color = color;
        }
    }

    private class ItemSort
    implements Comparator<Map<String, String>> {
        private ItemSort() {
        }

        @Override
        public int compare(Map<String, String> o1, Map<String, String> o2) {
            return o1.get("dest").compareTo(o2.get("dest"));
        }
    }
}

