/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractTariffDao;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class ActionContractTariffPlans
extends ActionBase {
    @Override
    public void doAction() throws BGException {
        int emid = this.getIntParameter("entityMid", -1);
        int eid = this.getIntParameter("entityId", -1);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);
        List<ContractTariff> list = contractTariffDao.list(this.cid, null, emid, eid);
        Map<Integer, TariffPlan> tariffPlanMap = new TariffPlanDao(this.con).getTariffPlanMap();
        for (ContractTariff contractTariff : list) {
            Period period = contractTariff.getPeriod();
            TariffPlan tariffPlan = tariffPlanMap.get(contractTariff.getTariffPlanId());
            String contractTariffTitle = tariffPlan == null ? "???" : tariffPlan.getTitle();
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(contractTariff.getId()));
            row.setAttribute("tpid", String.valueOf(contractTariff.getTariffPlanId()));
            row.setAttribute("title", contractTariffTitle);
            row.setAttribute("date1", TimeUtils.formatDate((Date)period.getDateFrom()));
            row.setAttribute("date2", TimeUtils.formatDate((Date)period.getDateTo()));
            row.setAttribute("period", TimeUtils.formatPeriod((Period)period));
            row.setAttribute("comment", contractTariff.getComment());
            row.setAttribute("pos", String.valueOf(contractTariff.getPosition()));
            row.setAttribute("f0", String.valueOf(contractTariff.getId()));
            row.setAttribute("f1", String.valueOf(contractTariff.getTariffPlanId()));
            row.setAttribute("f2", contractTariffTitle);
            row.setAttribute("f3", TimeUtils.formatPeriod((Period)period));
            row.setAttribute("f4", contractTariff.getComment());
            row.setAttribute("f5", String.valueOf(contractTariff.getPosition()));
        }
    }
}

