/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.CommentPatternManager;
import bitel.billing.server.contract.bean.ContractAddressParamValue;
import bitel.billing.server.contract.bean.ContractEmailParamValue;
import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionChecker;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ListParamValue;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.MultiListParamValues;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamValue;
import ru.bitel.common.Utils;

public class ActionCopyContractParameters
extends ActionBase {
    private static final String MODE_REPLACE = "replace";

    @Override
    public void doAction() throws SQLException, BGException {
        int fromContractId = Utils.parseInt((String)this.getParameter("fromContractId"), (int)-1);
        String mode = this.getParameter("mode", MODE_REPLACE);
        Set pids = Utils.toIntegerSet((String)this.getParameter("pids"));
        ContractParameterManager parameterManager = new ContractParameterManager(this.con);
        PermissionChecker.PermissionEntry userPermission = PermissionChecker.getUserPermition(this.userId);
        Map<Integer, Date> dateParamMap = null;
        Map<Integer, String> textParamMap = null;
        Map<Integer, Boolean> flagParamMap = null;
        Map<Integer, ListParamValue> listParamMap = null;
        Map<Integer, PhoneParamValue> phoneParamMap = null;
        Map<Integer, ContractEmailParamValue> emailParamMap = null;
        Map<Integer, ContractAddressParamValue> addressParamMap = null;
        Map<Integer, MultiListParamValues> multiListParamMap = null;
        if (!MODE_REPLACE.equals(mode)) {
            dateParamMap = parameterManager.getDateParamMap(this.cid, pids);
            flagParamMap = parameterManager.getFlagParamMap(this.cid, pids);
            textParamMap = parameterManager.getStringParamMap(this.cid, pids);
            phoneParamMap = parameterManager.getPhoneParamMap(this.cid, pids);
            emailParamMap = parameterManager.getEmailParamMap(this.cid, pids);
            listParamMap = parameterManager.getListParamValueMap(this.cid, pids);
            addressParamMap = parameterManager.getAddressParamMap(this.cid, pids);
            multiListParamMap = parameterManager.getMultiListParamValueMap(this.cid, pids);
        }
        for (Map.Entry<Integer, String> entry : parameterManager.getStringParamMap(fromContractId, pids).entrySet()) {
            if (!MODE_REPLACE.equals(mode) && textParamMap.containsKey(entry.getKey()) || !PermissionChecker.checkWriteContractParameter(userPermission, entry.getKey())) continue;
            parameterManager.updateStringParam(this.cid, entry.getKey(), entry.getValue(), this.userId);
        }
        for (Map.Entry<Integer, Object> entry : parameterManager.getAddressParamMap(fromContractId, pids).entrySet()) {
            if (!MODE_REPLACE.equals(mode) && addressParamMap.containsKey(entry.getKey()) || !PermissionChecker.checkWriteContractParameter(userPermission, entry.getKey())) continue;
            parameterManager.updateAddressParam(this.cid, entry.getKey(), (ContractAddressParamValue)entry.getValue(), this.userId);
        }
        for (Map.Entry<Integer, Object> entry : parameterManager.getPhoneParamMap(fromContractId, pids).entrySet()) {
            if (!MODE_REPLACE.equals(mode) && phoneParamMap.containsKey(entry.getKey()) || !PermissionChecker.checkWriteContractParameter(userPermission, entry.getKey())) continue;
            parameterManager.updatePhoneParam(this.cid, entry.getKey(), (PhoneParamValue)entry.getValue(), this.userId);
        }
        for (Map.Entry<Integer, Object> entry : parameterManager.getEmailParamMap(fromContractId, pids).entrySet()) {
            if (!MODE_REPLACE.equals(mode) && emailParamMap.containsKey(entry.getKey()) || !PermissionChecker.checkWriteContractParameter(userPermission, entry.getKey())) continue;
            parameterManager.updateEmailParam(this.cid, entry.getKey(), (ContractEmailParamValue)entry.getValue(), this.userId);
        }
        for (Map.Entry<Integer, Object> entry : parameterManager.getDateParamMap(fromContractId, pids).entrySet()) {
            if (!MODE_REPLACE.equals(mode) && dateParamMap.containsKey(entry.getKey()) || !PermissionChecker.checkWriteContractParameter(userPermission, entry.getKey())) continue;
            parameterManager.updateDateParam(this.cid, entry.getKey(), (Date)entry.getValue(), this.userId);
        }
        for (Map.Entry<Integer, Object> entry : parameterManager.getFlagParamMap(fromContractId, pids).entrySet()) {
            if (!MODE_REPLACE.equals(mode) && flagParamMap.containsKey(entry.getKey()) || !PermissionChecker.checkWriteContractParameter(userPermission, entry.getKey())) continue;
            parameterManager.updateFlagParam(this.cid, entry.getKey(), (Boolean)entry.getValue(), this.userId);
        }
        for (Map.Entry<Integer, Object> entry : parameterManager.getListParamValueMap(fromContractId, pids).entrySet()) {
            if (!MODE_REPLACE.equals(mode) && listParamMap.containsKey(entry.getKey()) || !PermissionChecker.checkWriteContractParameter(userPermission, entry.getKey())) continue;
            parameterManager.updateListParam(this.cid, entry.getKey(), (ListParamValue)entry.getValue(), this.userId);
        }
        for (Map.Entry<Integer, Object> entry : parameterManager.getMultiListParamValueMap(fromContractId, pids).entrySet()) {
            if (!MODE_REPLACE.equals(mode) && multiListParamMap.containsKey(entry.getKey()) || !PermissionChecker.checkWriteContractParameter(userPermission, entry.getKey())) continue;
            parameterManager.updateMultiListParameterAndItems(this.cid, entry.getKey(), (MultiListParamValues)entry.getValue(), this.userId);
        }
        new CommentPatternManager(this.con).updateContractComment(this.cid);
    }
}

