/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.object.bean;

import bitel.billing.server.contract.object.bean.TypeParam;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TypeParamManager {
    private Connection con;
    private static final String TABLE_NAME = "object_type_param";

    public TypeParamManager(Connection con) {
        this.con = con;
    }

    public List<TypeParam> getTypeParamList(int typeId) {
        ArrayList<TypeParam> result = new ArrayList<TypeParam>();
        try {
            String query = "SELECT * FROM object_type_param WHERE type_id=? ORDER BY pos";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, typeId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getTypeParamFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void addTypeParam(TypeParam typeParam) {
        try {
            String query = "SELECT MAX(pos) FROM object_type_param WHERE type_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, typeParam.getTypeId());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                typeParam.setPos(rs.getInt(1) + 1);
            }
            rs.close();
            ps.close();
            query = "INSERT INTO object_type_param (type_id, param_id, pos) VALUES (?, ?, ?)";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, typeParam.getTypeId());
            ps.setInt(2, typeParam.getParamId());
            ps.setInt(3, typeParam.getPos());
            ps.executeUpdate();
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteTypeParam(TypeParam typeParam) {
        try {
            String query = "DELETE FROM object_type_param WHERE type_id=? AND param_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, typeParam.getTypeId());
            ps.setInt(2, typeParam.getParamId());
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void moveUp(TypeParam typeParam) {
        this.setTypeParamPos(typeParam);
        TypeParam neighbor = this.getNearestTypeParam(typeParam, true);
        if (neighbor != null) {
            this.exchangePosition(typeParam, neighbor);
        }
    }

    public void moveDown(TypeParam typeParam) {
        this.setTypeParamPos(typeParam);
        TypeParam neighbor = this.getNearestTypeParam(typeParam, false);
        if (neighbor != null) {
            this.exchangePosition(typeParam, neighbor);
        }
    }

    private void exchangePosition(TypeParam typeParam1, TypeParam typeParam2) {
        try {
            String query = "UPDATE object_type_param SET pos=? WHERE type_id=? AND param_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, typeParam2.getPos());
            ps.setInt(2, typeParam1.getTypeId());
            ps.setInt(3, typeParam1.getParamId());
            ps.executeUpdate();
            ps.setInt(1, typeParam1.getPos());
            ps.setInt(2, typeParam2.getTypeId());
            ps.setInt(3, typeParam2.getParamId());
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setTypeParamPos(TypeParam typeParam) {
        try {
            String query = "SELECT pos FROM object_type_param WHERE type_id=? AND param_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, typeParam.getTypeId());
            ps.setInt(2, typeParam.getParamId());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                typeParam.setPos(rs.getInt(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TypeParam getNearestTypeParam(TypeParam typeParam, boolean top) {
        TypeParam result = null;
        String query = null;
        PreparedStatement ps = null;
        try {
            query = top ? "SELECT * FROM object_type_param WHERE type_id=? AND pos<? ORDER BY pos DESC LIMIT 1" : "SELECT * FROM object_type_param WHERE type_id=? AND pos>? ORDER BY pos LIMIT 1";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, typeParam.getTypeId());
            ps.setInt(2, typeParam.getPos());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getTypeParamFromRs(rs);
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private TypeParam getTypeParamFromRs(ResultSet rs) throws SQLException {
        TypeParam result = new TypeParam();
        result.setTypeId(rs.getInt("type_id"));
        result.setParamId(rs.getInt("param_id"));
        result.setPos(rs.getInt("pos"));
        return result;
    }
}

