/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.service;

import bitel.billing.server.admin.bgsecure.bean.GroupManager;
import bitel.billing.server.admin.bgsecure.bean.GroupPermitionsManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.Group;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserGroup;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserGroupService;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSAction;
import ru.bitel.bgbilling.kernel.module.server.event.ModulesChangedEvent;
import ru.bitel.common.Utils;
import ru.bitel.common.model.ListItem;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.bgsecure.common.service.UserGroupService")
public class UserGroupServiceImpl
extends AbstractService
implements UserGroupService {
    @Override
    public List<UserGroup> getUserGroupList(boolean addUsersCount) throws BGException {
        Map<Integer, Integer> groupUsers = null;
        GroupManager groupManager = new GroupManager(this.getConnection());
        if (addUsersCount) {
            groupUsers = groupManager.getGroupUserCount();
        }
        ArrayList<UserGroup> list = new ArrayList<UserGroup>();
        for (ListItem listItem : groupManager.getGroupList()) {
            UserGroup userGroup = new UserGroup(listItem.getId(), listItem.getTitle());
            if (groupUsers != null) {
                Integer users = groupUsers.get(listItem.getId());
                userGroup.setUsers(users != null ? users : 0);
            }
            list.add(userGroup);
        }
        return list;
    }

    @Override
    public int updateUserGroup(UserGroup userGroup) throws BGIllegalArgumentException {
        if (userGroup.getId() < 0 || Utils.isBlankString((String)userGroup.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        Group group = new Group();
        group.setId(userGroup.getId());
        group.setTitle(userGroup.getTitle());
        new GroupManager(this.getConnection()).updateGroup(group);
        return group.getId();
    }

    @Override
    public void deleteGroup(int id) throws BGIllegalArgumentException {
        if (id <= 0) {
            throw new BGIllegalArgumentException();
        }
        new GroupPermitionsManager(this.getConnection()).updateGroupActions(id, null);
        new GroupManager(this.getConnection()).deleteGroup(id);
        this.context.publishAfterCommit(new ModulesChangedEvent(this.context.getUserId()));
    }

    @Override
    public String getActionsOfGroup(int userGroupId) throws BGException {
        GroupPermitionsManager manager = new GroupPermitionsManager(this.getConnection());
        return this.actionsListToString(manager.getGroupActions(userGroupId));
    }

    private String actionsListToString(List<BGSAction> list) {
        StringBuffer actions = new StringBuffer(1000);
        for (BGSAction ga : list) {
            if (actions.length() != 0) {
                actions.append(",");
            }
            actions.append(ga.mid);
            actions.append("_");
            actions.append(ga.actionID);
        }
        return actions.toString();
    }

    private List<BGSAction> stringActionsToList(String actions) {
        ArrayList<BGSAction> actionList = new ArrayList<BGSAction>();
        StringTokenizer st = new StringTokenizer(actions, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String[] mid_aid = token.split("_");
            if (mid_aid.length != 2) continue;
            BGSAction action = new BGSAction();
            action.mid = mid_aid[0];
            action.actionID = Utils.parseInt((String)mid_aid[1], (int)0);
            actionList.add(action);
        }
        return actionList;
    }

    @Override
    public Group getGroupById(int groupId) throws BGException {
        return new GroupManager(this.getConnection()).getGroupById(groupId);
    }

    @Override
    public void updateGroup(Group group, String actions) throws BGException {
        int gid = group.getId();
        long groups = group.getContractGroups();
        if (gid <= 0 || actions == null || groups < 0L) {
            throw new BGIllegalArgumentException();
        }
        List<BGSAction> actionList = this.stringActionsToList(actions);
        new GroupPermitionsManager(this.getConnection()).updateGroupActions(gid, actionList);
        new GroupManager(this.getConnection()).updateGroupPermitions(gid, group.getMenuId(), groups, group.getContractGroupsMode(), group.getRuleAccessContractParameter(), group.getRuleAccessObjectParameter());
        this.context.publishAfterCommit(new ModulesChangedEvent(this.context.getUserId()));
    }
}

