/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.common.DBInfoManager;
import bitel.billing.module.common.TransferData;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.common.XMLUtils;

public class TreesManager {
    private static Map<String, TreesManager> _managers = new HashMap<String, TreesManager>();
    private Map<String, Object> _configs = new HashMap<String, Object>();

    public static TreesManager getTreesManager(TransferData transferData, ClientSetup setup) {
        String key;
        TreesManager result = null;
        DBInfo dbInfo = DBInfoManager.getManager().getActiveDBInfo();
        if (dbInfo != null && (result = _managers.get(key = dbInfo.getDbServerURL())) == null) {
            result = new TreesManager();
            _managers.put(key, result);
        }
        return result;
    }

    private TreesManager() {
    }

    public ModuleTariffConfig getConfig(String module) {
        ModuleTariffConfig result = null;
        Object obj = this._configs.get(module);
        if (obj != null) {
            if (obj instanceof ModuleTariffConfig) {
                result = (ModuleTariffConfig)obj;
            }
        } else {
            Document moduleConfig = this.loadTreeConfig(module);
            if (moduleConfig != null) {
                result = new ModuleTariffConfig(moduleConfig);
                this._configs.put(module, result);
            } else {
                this._configs.put(module, "");
            }
        }
        return result;
    }

    private Document loadTreeConfig(String module) {
        Document result = null;
        try {
            URL url = TreesManager.class.getResource("/ru/bitel/bgbilling/modules/" + module + "/common/tariff.xml");
            if (url != null) {
                result = XMLUtils.parseDocument((InputSource)new InputSource(url.openStream()));
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        return result;
    }
}

