/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.FontUIResource;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.BGClient;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGServiceConfigModule;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.config.client.LaF;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.LookAndFeelUtils;
import ru.bitel.common.model.IdTitle;

public class EditorParameters
extends BGTabPanel {
    public static final String TAB_ID = "editorParameters";
    private BGServiceConfigModule serviceConfigModule = new BGServiceConfigModule();
    private JComboBox<ComboBoxItem> lookAndFeel = new JComboBox();
    private BGUComboBox<IdTitle> font = new BGUComboBox();
    private BGCalendarButton closedDateButton = new BGCalendarButton();
    private BGComboBox<ComboBoxItem> closedPeriodType = new BGComboBox();

    public EditorParameters() {
        super(TAB_ID, "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430...");
        ComboBoxItem item;
        String lafTheme;
        String lafClass;
        String lafTitle;
        this.jbInit();
        ComboBoxItem selectedItem = null;
        LookAndFeelUtils.LookAndFeelTheme currentTheme = LookAndFeelUtils.getCurrent();
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            lafTitle = lookAndFeelInfo.getName();
            item = this.addLaF(lafTitle, lafClass = lookAndFeelInfo.getClassName(), lafTheme = null, currentTheme);
            if (item == null) continue;
            selectedItem = item;
        }
        for (LaF laF : LaF.values()) {
            lafTitle = laF.getTitle();
            item = this.addLaF(lafTitle, lafClass = laF.getClassName(), lafTheme = laF.getTheme(), currentTheme);
            if (item == null) continue;
            selectedItem = item;
        }
        String string = "look.and.feel.";
        for (String key : Utils.toList(this.setup.get(string + "keys", ""))) {
            String lafTheme2;
            String lafClass2;
            String string2 = this.setup.get(string + key + ".title", null);
            ComboBoxItem item2 = this.addLaF(string2, lafClass2 = this.setup.get(string + key + ".class", null), lafTheme2 = this.setup.get(string + key + ".theme", null), currentTheme);
            if (item2 == null) continue;
            selectedItem = item2;
        }
        if (selectedItem != null) {
            this.lookAndFeel.setSelectedItem(selectedItem);
        }
        this.setData();
    }

    private ComboBoxItem addLaF(String title, String lafClass, String lafTheme, LookAndFeelUtils.LookAndFeelTheme currentTheme) {
        if (title == null || lafClass == null) {
            return null;
        }
        Object lafTitle = title;
        try {
            Class<LookAndFeel> lafclazz = Class.forName(lafClass).asSubclass(LookAndFeel.class);
            LookAndFeel lafinst = lafclazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (lafinst.isNativeLookAndFeel()) {
                lafTitle = (String)lafTitle + " [native]";
            }
            if (!lafinst.isSupportedLookAndFeel()) {
                lafTitle = (String)lafTitle + " [not supported]";
            }
            if (UIManager.getSystemLookAndFeelClassName().equals(lafClass)) {
                lafTitle = (String)lafTitle + " [system]";
            }
            if (UIManager.getCrossPlatformLookAndFeelClassName().equals(lafClass)) {
                lafTitle = (String)lafTitle + " [crossplatform]";
            }
        }
        catch (ClassNotFoundException e) {
            lafTitle = (String)lafTitle + " [class not found]";
        }
        catch (Exception e) {
            lafTitle = (String)lafTitle + " [error class]";
        }
        ComboBoxItem item = new ComboBoxItem(lafClass, (String)lafTitle);
        item.put("theme", lafTheme);
        this.lookAndFeel.addItem(item);
        if (currentTheme.getLafClass().getName().equals(lafClass) && (lafTheme == null || lafTheme.equals(currentTheme.getThemeName()))) {
            return item;
        }
        return null;
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getLafPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.getClosePeriodPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.serviceConfigModule, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getClosePeriodPanel() {
        this.closedPeriodType.addActionListener(e -> this.loadPeriod());
        JButton setPeriodButton = new JButton(" \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c ");
        setPeriodButton.addActionListener(e -> this.setPeriod());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u0417\u0430\u043a\u0440\u044b\u0442\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 "));
        panel.add(this.closedPeriodType, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.closedDateButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)setPeriodButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getLafPanel() {
        ArrayList<IdTitle> fontData = new ArrayList<IdTitle>();
        fontData.add(new IdTitle(0, "\u041e\u0431\u044b\u0447\u043d\u044b\u0439"));
        fontData.add(new IdTitle(1, "\u041c\u0435\u043d\u044c\u0448\u0435"));
        fontData.add(new IdTitle(2, "\u041c\u0430\u043b\u0435\u043d\u044c\u043a\u0438\u0439"));
        fontData.add(new IdTitle(-1, "\u0411\u043e\u043b\u044c\u0448\u043e\u0439"));
        this.font.setData(fontData);
        JButton applyButton = new JButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        applyButton.addActionListener(e -> this.jButton2_actionPerformed(e));
        JButton fontConfigButton = new JButton("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0448\u0440\u0438\u0444\u0442\u043e\u0432");
        fontConfigButton.addActionListener(e -> new FontConfigEditorDialog("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0448\u0440\u0438\u0444\u0442\u043e\u0432", null).getDialog().setVisible(true));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u0412\u0438\u0434 \u0438 \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 "));
        panel.add(this.lookAndFeel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)new JLabel("\u0428\u0440\u0438\u0444\u0442:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        panel.add(this.font, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 5, 0), 0, 0));
        panel.add((Component)applyButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)fontConfigButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private void loadPeriod() {
        Request request = new Request();
        request.setModule("admin");
        request.setAttribute("typeId", this.closedPeriodType.getSelectedId());
        request.setAction("GetClosedDate");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            String dateStr = XMLUtils.selectText(doc.getDocumentElement(), "closed/@date");
            this.closedDateButton.setLocalDate(TimeUtils.parseLocalDate(dateStr));
        }
    }

    private void setPeriod() {
        Request request = new Request();
        request.setModule("admin");
        request.setAction("SetClosedDate");
        request.setAttribute("date", TimeUtils.formatDate(this.closedDateButton.getCalendar()));
        request.setAttribute("typeId", this.closedPeriodType.getSelectedId());
        TransferManager.getDocument(request);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.serviceConfigModule.actionPerformed(actionEvent);
    }

    @Override
    public void setData() {
        Element list;
        this.font.setSelectedItem(this.setup.getInt(LookAndFeelUtils.class.getName() + ".minfont", 0));
        Request request = new Request();
        request.setModule("admin");
        request.setAction("ClosedDateTypeList");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc) && (list = XMLUtils.selectElement(doc, "/data/list")) != null) {
            this.closedPeriodType.setModel(ClientUtils.buildComboBox(list, ""));
        }
        this.loadPeriod();
        this.serviceConfigModule.performAction("refresh");
    }

    private void jButton2_actionPerformed(ActionEvent e) {
        ComboBoxItem item = (ComboBoxItem)this.lookAndFeel.getSelectedItem();
        LookAndFeelUtils.LookAndFeelTheme theme = LookAndFeelUtils.getTheme((String)item.getObject(), (String)item.get("theme"));
        this.setup.getUserConfig().set(LookAndFeelUtils.class.getName() + ".laf", theme.getLafClass().getName());
        this.setup.getUserConfig().set(LookAndFeelUtils.class.getName() + ".lafTheme", theme.getThemeName() != null ? theme.getThemeName() : "");
        this.setup.getUserConfig().set(LookAndFeelUtils.class.getName() + ".minfont", String.valueOf(((IdTitle)this.font.getSelectedItem()).getId()));
        this.setup.saveUserConfig();
        try {
            LookAndFeelUtils.setTheme(theme.getLafClass().getName(), theme.getThemeName());
            SwingUtilities.updateComponentTreeUI(BGClientBase.getFrame());
            BGClientBase.getFrame().repaint();
            BGClientBase.getFrame().pack();
        }
        catch (Exception e1) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c L&F, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u0432\u0430\u0440\u0438\u0430\u043d\u0442");
            e1.printStackTrace();
            return;
        }
        ClientUtils.showMessageDialog("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043a\u043b\u0438\u0435\u043d\u0442 \u0434\u043b\u044f \u043e\u043a\u043e\u043d\u0447\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439");
    }

    class FontConfigEditorDialog
    extends BGEditorDialog<String> {
        private Map<String, FontUIResource> fonts;
        private DefaultListModel<String> componentListModel;
        private JList<String> componentList;
        private DefaultListModel<Font> fontListModel;
        private JList<Font> fontList;
        private JComboBox<KeyValue> styleComboBox;
        private JComboBox<KeyValue> familyComboBox;
        private JTextField fontSize;
        private GraphicsEnvironment graphicsEnvironment;

        public FontConfigEditorDialog(String title, String data) {
            super(title, data);
            this.fonts = new HashMap<String, FontUIResource>();
            this.componentListModel = new DefaultListModel();
            this.componentList = new JList<String>(this.componentListModel);
            this.fontListModel = new DefaultListModel();
            this.fontList = new JList<Font>(this.fontListModel);
            this.styleComboBox = new JComboBox();
            this.familyComboBox = new JComboBox();
            this.fontSize = new JTextField(5);
            this.graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Enumeration keys = UIManager.getDefaults().keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = UIManager.get(key);
                if (!(value instanceof FontUIResource)) continue;
                this.fonts.put(String.valueOf(key), (FontUIResource)value);
            }
        }

        @Override
        protected BGOptionPane getBGOptionPane() {
            return new BGOptionPane(this.panel, this.title){

                @Override
                protected void doCancel() {
                    for (String key : FontConfigEditorDialog.this.fonts.keySet()) {
                        UIManager.put(key, FontConfigEditorDialog.this.fonts.get(key));
                    }
                    FontConfigEditorDialog.this.updateComponentTreeUI();
                }
            };
        }

        @Override
        public void doDialogPanel() {
            this.panel.add((Component)this.getComponentPanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
            this.panel.add((Component)this.getConfigPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        }

        private JPanel getComponentPanel() {
            ArrayList<String> fontKeys = new ArrayList<String>(this.fonts.keySet());
            Collections.sort(fontKeys);
            for (String key : fontKeys) {
                this.componentListModel.addElement(String.valueOf(key));
            }
            this.componentList.setCellRenderer(new ComponentFontListCellRenderer());
            this.componentList.addListSelectionListener(e -> {
                String key = this.componentList.getSelectedValue();
                if (key != null) {
                    Font font = UIManager.getDefaults().getFont(key);
                    this.fontSize.setText(String.valueOf(font.getSize()));
                }
            });
            Dimension dimension = new Dimension(600, 300);
            JScrollPane scrollPane = new JScrollPane(this.componentList);
            scrollPane.setMinimumSize(dimension);
            scrollPane.setPreferredSize(dimension);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(new TitledBorder("\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430"));
            panel.add((Component)scrollPane, new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getConfigPanel() {
            this.fontList.setCellRenderer(new FontListCellRenderer());
            for (Font font : this.graphicsEnvironment.getAllFonts()) {
                this.fontListModel.addElement(font.deriveFont(font.getStyle(), 12.0f));
            }
            Dimension dimension = new Dimension(500, 300);
            JScrollPane scrollPane = new JScrollPane(this.fontList);
            scrollPane.setPreferredSize(dimension);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(new TitledBorder("\u0428\u0440\u0438\u0444\u0442"));
            panel.add((Component)this.getTopPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.getButtonPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getTopPanel() {
            this.fontSize.setHorizontalAlignment(0);
            this.styleComboBox.addItem(new KeyValue("all", "\u041b\u044e\u0431\u043e\u0439"));
            this.styleComboBox.addItem(new KeyValue(String.valueOf(0), "plain"));
            this.styleComboBox.addItem(new KeyValue(String.valueOf(1), "bold"));
            this.styleComboBox.addItem(new KeyValue(String.valueOf(2), "italic"));
            this.styleComboBox.addItem(new KeyValue(String.valueOf(3), "bold + italic"));
            this.styleComboBox.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.applyFilter();
                }
            });
            this.familyComboBox.addItem(new KeyValue("all", "\u041b\u044e\u0431\u043e\u0435"));
            for (String name : this.graphicsEnvironment.getAvailableFontFamilyNames()) {
                this.familyComboBox.addItem(new KeyValue(name, name));
            }
            this.familyComboBox.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.applyFilter();
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0421\u0435\u043c\u0435\u0439\u0441\u0442\u0432\u043e: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
            panel.add(this.familyComboBox, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
            panel.add((Component)new JLabel("\u0421\u0442\u0438\u043b\u044c: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
            panel.add(this.styleComboBox, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
            panel.add((Component)new JLabel("\u0420\u0430\u0437\u043c\u0435\u0440: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
            panel.add((Component)this.fontSize, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
            return panel;
        }

        private void applyFilter() {
            this.fontListModel.removeAllElements();
            String family = ((KeyValue)this.familyComboBox.getSelectedItem()).getKey();
            String style = ((KeyValue)this.styleComboBox.getSelectedItem()).getKey();
            for (Font font : this.graphicsEnvironment.getAllFonts()) {
                if (!"all".equals(family) && !font.getFamily().equals(family) || !"all".equals(style) && font.getStyle() != Utils.parseInt(style)) continue;
                int size = Utils.parseInt(this.fontSize.getText(), 12);
                font = new Font(font.getName(), font.getStyle(), size);
                this.fontListModel.addElement(font);
            }
        }

        private JPanel getButtonPanel() {
            JButton defaultButton = new JButton("\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
            defaultButton.addActionListener(e -> {
                String componentKey = this.componentList.getSelectedValue();
                UIManager.put(componentKey, BGClientBase.getFrame().getDefaultUIFontMap().get(componentKey));
                this.updateComponentTreeUI();
            });
            JButton resetButton = new JButton("\u0412\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
            resetButton.addActionListener(e -> {
                String componentKey = this.componentList.getSelectedValue();
                UIManager.put(componentKey, this.fonts.get(componentKey));
                this.updateComponentTreeUI();
            });
            JButton setButton = new JButton("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
            setButton.addActionListener(e -> {
                Font selectedFont = this.fontList.getSelectedValue();
                for (String componentKey : this.componentList.getSelectedValuesList()) {
                    FontUIResource fontUIResource = new FontUIResource(selectedFont.getFontName(), Utils.parseInt(((KeyValue)this.styleComboBox.getSelectedItem()).getKey()), Utils.parseInt(this.fontSize.getText()));
                    UIManager.put(componentKey, fontUIResource);
                }
                this.updateComponentTreeUI();
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)defaultButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)resetButton, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)setButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }

        private void updateComponentTreeUI() {
            SwingUtilities.updateComponentTreeUI(BGClient.getFrame());
            SwingUtilities.updateComponentTreeUI(this.panel.getParent().getParent().getParent().getParent());
            this.componentList.invalidate();
            this.componentList.repaint();
        }

        @Override
        public boolean doApply() throws Exception {
            Map<String, FontUIResource> defaultFontMap = BGClientBase.getFrame().getDefaultUIFontMap();
            JSONArray customFontArray = new JSONArray();
            for (int index = 0; index < this.componentListModel.getSize(); ++index) {
                String key = this.componentListModel.get(index);
                Font font = UIManager.getDefaults().getFont(key);
                if (defaultFontMap.get(key).equals(font)) continue;
                JSONObject json = new JSONObject();
                json.put("key", (Object)key);
                json.put("name", (Object)font.getName());
                json.put("style", font.getStyle());
                json.put("size", font.getSize());
                customFontArray.put((Object)json);
            }
            ClientSetup.getInstance().getUserConfig().set("client.ui.fonts", customFontArray.toString());
            ClientSetup.getInstance().saveUserConfig();
            return true;
        }
    }

    class FontListCellRenderer
    extends DefaultListCellRenderer {
        FontListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Font font = (Font)value;
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            label.setFont(font);
            String strStyle = font.isBold() ? (font.isItalic() ? "bolditalic" : "bold") : (font.isItalic() ? "italic" : "plain");
            label.setText("\u0428\u0440\u0438\u0444\u0442 [family=" + font.getFamily() + ", name=" + font.getName() + ", style=" + strStyle + ", size=" + font.getSize() + "]");
            return label;
        }
    }

    class ComponentFontListCellRenderer
    extends DefaultListCellRenderer {
        ComponentFontListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            String key = (String)value;
            Font font = UIManager.getDefaults().getFont(key);
            component.setFont(font);
            String strStyle = font.isBold() ? (font.isItalic() ? "bolditalic" : "bold") : (font.isItalic() ? "italic" : "plain");
            String strFont = "[family=" + font.getFamily() + ", name=" + font.getName() + ", style=" + strStyle + ", size=" + font.getSize() + "]";
            ((JLabel)component).setText(key + " " + strFont);
            return component;
        }
    }
}

