/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.BGKeySelectionManager;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolTip;
import javax.swing.ListCellRenderer;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboPopup;
import ru.bitel.common.client.LookAndFeelUtils;

public class BGComboBox<E>
extends JComboBox<E> {
    private static final JSeparator separatorUI = new JSeparator(0);
    private BGKeySelectionManager ksm = new BGKeySelectionManager();
    private Popup popup = null;
    private int columnWidth = 0;
    private int columns = 0;
    private boolean prefferedPopupWidthCalculated = false;
    private int prefferedPopupWidth = 0;
    public static final ComboBoxItem SEPARATOR = new ComboBoxItem(){

        @Override
        public String toString() {
            return "---";
        }
    };

    public BGComboBox(List<E> values) {
        super(new Vector<E>(values));
        this.init();
    }

    public BGComboBox() {
        this.init();
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (anObject == SEPARATOR) {
            return;
        }
        if (anObject instanceof Separator) {
            return;
        }
        super.setSelectedItem(anObject);
    }

    private void init() {
        this.setKeySelectionManager(this.ksm);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                BGComboBox.this.showPatternPopup();
            }

            @Override
            public void focusLost(FocusEvent e) {
                BGComboBox.this.hidePatternPopup();
            }
        });
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                BasicComboPopup popup = (BasicComboPopup)BGComboBox.this.getUI().getAccessibleChild(BGComboBox.this, 0);
                Component comp = popup.getComponent(0);
                if (comp instanceof JScrollPane) {
                    JScrollPane scrollpane = (JScrollPane)comp;
                    if (!BGComboBox.this.prefferedPopupWidthCalculated) {
                        BGComboBox.this.calcComboPopupWidth();
                    }
                    Dimension dim = scrollpane.getPreferredSize();
                    if (dim.width < BGComboBox.this.prefferedPopupWidth) {
                        dim.width = BGComboBox.this.prefferedPopupWidth;
                        scrollpane.setMaximumSize(dim);
                        scrollpane.setPreferredSize(dim);
                        scrollpane.setMinimumSize(dim);
                    }
                }
            }
        });
    }

    private void showPatternPopup() {
        String s;
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
        if ((s = this.ksm.getPattern()) != null) {
            Point p = this.getLocationOnScreen();
            JToolTip toolTip = new JToolTip();
            toolTip.setTipText(s);
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.popup = popupFactory.getPopup(this, toolTip, p.x, p.y - toolTip.getPreferredSize().height);
            this.popup.show();
        }
    }

    private void hidePatternPopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    @Override
    public boolean selectWithKeyChar(char keyChar) {
        if (this.keySelectionManager == null) {
            this.keySelectionManager = this.createDefaultKeySelectionManager();
        }
        int index = this.ksm.selectionForKey(keyChar, this.getModel());
        this.showPatternPopup();
        if (index != -1) {
            this.setSelectedIndex(index);
            return true;
        }
        return false;
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 27: {
                if (this.ksm.getPattern() == null || e.getID() != 401) break;
                this.ksm.selectionForKey('\u001b', this.dataModel);
                this.showPatternPopup();
                break;
            }
            case 40: {
                if (this.ksm.getPattern() != null && e.getID() == 401) {
                    int index = this.ksm.findNext(this.dataModel, true);
                    if (index < 0) break;
                    this.setSelectedIndex(index);
                    break;
                }
                super.processKeyEvent(e);
                break;
            }
            case 38: {
                if (this.ksm.getPattern() != null && e.getID() == 401) {
                    int index = this.ksm.findNext(this.dataModel, false);
                    if (index < 0) break;
                    this.setSelectedIndex(index);
                    break;
                }
                super.processKeyEvent(e);
                break;
            }
            default: {
                super.processKeyEvent(e);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.columns != 0) {
            Insets insets = this.getInsets();
            size.width = this.columns * this.getColumnWidth() + insets.left + insets.right;
        }
        size.height = LookAndFeelUtils.BUTTON_HEIGHT.get();
        return size;
    }

    private int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('m');
        }
        return this.columnWidth;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final void setColumns(int columns) {
        if (columns >= 0 && this.columns != columns) {
            this.columns = columns;
            this.invalidate();
        }
    }

    public String getSelectedId() {
        return this.getIdFromItem(this.getSelectedItem());
    }

    private String getIdFromItem(Object item) {
        String id = null;
        if (item instanceof ComboBoxItem) {
            ComboBoxItem comboBoxItem = (ComboBoxItem)item;
            Object itemObject = comboBoxItem.getObject();
            id = itemObject != null ? itemObject.toString() : null;
        } else if (item != null) {
            id = item.toString();
        }
        return id;
    }

    public boolean setSelectedId(String selected) {
        if (selected == null) {
            return false;
        }
        ComboBoxModel model = this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String id = this.getIdFromItem(model.getElementAt(i));
            if (!selected.equals(id)) continue;
            this.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        separatorUI.updateUI();
        final ListCellRenderer oldRenderer = this.getRenderer();
        this.setRenderer(new ListCellRenderer<E>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == SEPARATOR) {
                    return separatorUI;
                }
                if (value instanceof Separator) {
                    JLabel label = new JLabel(value.toString());
                    label.setForeground(BGComboBox.this.getBackground());
                    label.setBackground(BGComboBox.this.getForeground());
                    label.setOpaque(true);
                    return label;
                }
                return oldRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
    }

    @Override
    public void setModel(ComboBoxModel<E> model) {
        super.setModel(model);
        this.prefferedPopupWidthCalculated = false;
    }

    private void calcComboPopupWidth() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        BasicComboPopup popup = (BasicComboPopup)this.getUI().getAccessibleChild(this, 0);
        if (popup == null) {
            return;
        }
        int size = (int)this.getPreferredSize().getWidth();
        for (int i = 0; i < this.getItemCount(); ++i) {
            Object str = this.getItemAt(i);
            if (size >= fm.stringWidth(str.toString())) continue;
            size = fm.stringWidth(str.toString());
        }
        this.prefferedPopupWidth = size;
        this.prefferedPopupWidthCalculated = true;
    }

    @Override
    public E getSelectedItem() {
        return (E)super.getSelectedItem();
    }

    public static class Separator
    extends ComboBoxItem {
        public Separator(String title) {
            super(null, title);
        }
    }
}

