/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerContactType;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerAddContactDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerParamHistoryDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerParamPanel;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerParamTextArea;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerParamTextField;
import ru.bitel.common.Utils;

public abstract class CustomerCommonParamPanel
extends BGUPanel {
    protected CustomerParamPanel customerParamPanel;
    protected ClientSetup clientSetup = ClientSetup.getInstance();
    protected List<CustomerParamTextField> contacts = new ArrayList<CustomerParamTextField>();

    protected CustomerCommonParamPanel(CustomerParamPanel customerParamPanel) {
        this.customerParamPanel = customerParamPanel;
    }

    protected JPanel getContactsPanel(CustomerContactType ... types) {
        final JPanel panelWithContants = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(panelWithContants);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setPreferredSize(new Dimension(100, 100));
        JPanel contactPanel = new JPanel(new GridBagLayout());
        contactPanel.setBorder(BorderFactory.createTitledBorder("\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u044b"));
        contactPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 0, 0), 0, 0));
        Object obj = ((ClientContext)this.customerParamPanel.getContext()).getCustomer().optQuery("/customer/contact");
        if (obj instanceof JSONObject) {
            JSONObject customerContacts = (JSONObject)obj;
            customerContacts.keySet().forEach(contactKey -> {
                CustomerContactType contactType = CustomerContactType.getContactTypeByKey(contactKey);
                this.contacts.add(new CustomerParamTextField("", "/customer/contact/" + contactKey, this.customerParamPanel, contactType != null ? contactType.key : ""));
            });
        } else {
            for (JSONObject contactType : types) {
                this.contacts.add(new CustomerParamTextField("", contactType.key + "_1", this.customerParamPanel, contactType.key));
            }
        }
        String addContactText = "\u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442";
        final JLabel addContact = new JLabel("\u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442");
        addContact.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                addContact.setText("<html><nobr><u>\u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442</u></nobr></html>");
                CustomerCommonParamPanel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                addContact.setText("<html><nobr>\u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442</nobr></html>");
                CustomerCommonParamPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ActionListener addContantListener = e -> {
                    CustomerContactType newContactType = CustomerContactType.getContactTypeByKey(e.getActionCommand());
                    List sameTypes = CustomerCommonParamPanel.this.contacts.stream().filter(c -> CustomerContactType.getContactTypeByKey(c.getFieldKey()).equals((Object)newContactType)).collect(Collectors.toList());
                    ArrayList<Integer> indexes = new ArrayList<Integer>(12);
                    for (CustomerParamTextField field : sameTypes) {
                        String fieldKey = field.getFieldKey();
                        int fieldKeyIndex = Utils.parseInt(fieldKey.substring(fieldKey.lastIndexOf("_") + 1), -1);
                        if (fieldKeyIndex <= 0) continue;
                        indexes.add(fieldKeyIndex);
                    }
                    int index = CustomerCommonParamPanel.this.getFreeIndex(indexes);
                    CustomerCommonParamPanel.this.contacts.add(new CustomerParamTextField("", e.getActionCommand() + "_" + index, CustomerCommonParamPanel.this.customerParamPanel, e.getActionCommand()));
                    CustomerCommonParamPanel.this.makeContantFieldOnPanel(panelWithContants, addContact, CustomerCommonParamPanel.this.contacts);
                };
                new CustomerAddContactDialog(addContantListener, CustomerContactType.values());
            }
        });
        this.makeContantFieldOnPanel(panelWithContants, addContact, this.contacts);
        return contactPanel;
    }

    private int getFreeIndex(List<Integer> indexes) {
        if (Utils.isEmptyCollection(indexes)) {
            return 1;
        }
        Collections.sort(indexes);
        int freeIndex = indexes.get(indexes.size() - 1) + 1;
        if (indexes.get(0) > 1) {
            freeIndex = 1;
        } else {
            for (int x = 0; x < indexes.size() - 1; ++x) {
                if (indexes.get(x) + 1 >= indexes.get(x + 1)) continue;
                freeIndex = indexes.get(x) + 1;
            }
        }
        return freeIndex;
    }

    private void makeContantFieldOnPanel(JPanel panelWithContants, JLabel addContact, List<CustomerParamTextField> contacts) {
        panelWithContants.removeAll();
        int gridy = 0;
        for (CustomerParamTextField fieldWithContact : contacts) {
            CustomerContactType contactType = CustomerContactType.getContactTypeByKey(fieldWithContact.getName());
            String title = contactType != null ? contactType.description : "";
            int index = gridy;
            JButton delButton = new JButton("X");
            delButton.setMargin(new Insets(3, 3, 3, 3));
            delButton.addActionListener(e -> {
                this.deleteCustomerContact((CustomerParamTextField)contacts.get(index));
                contacts.remove(index);
                this.makeContantFieldOnPanel(panelWithContants, addContact, contacts);
                this.customerParamPanel.invalidate();
                this.customerParamPanel.repaint();
            });
            panelWithContants.add((Component)new JLabel(title), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 0, 0), 0, 0));
            panelWithContants.add((Component)fieldWithContact, new GridBagConstraints(1, gridy, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 0, 0), 0, 0));
            panelWithContants.add((Component)delButton, new GridBagConstraints(2, gridy++, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 5), 0, 0));
        }
        panelWithContants.add((Component)addContact, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 3, 0, 5), 0, 0));
        panelWithContants.add(Box.createGlue(), new GridBagConstraints(0, gridy, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 0, 0), 0, 0));
        panelWithContants.revalidate();
        panelWithContants.repaint();
    }

    private void deleteCustomerContact(CustomerParamTextField contactField) {
        JSONObject customer = ((ClientContext)this.customerParamPanel.getContext()).getCustomer();
        Object contacts = customer.optQuery("/customer/contact");
        if (contacts instanceof JSONObject) {
            String key;
            JSONObject c = (JSONObject)contacts;
            String[] mas = contactField.getFieldKey().split("/");
            if (mas.length > 0 && c.has(key = mas[mas.length - 1])) {
                c.remove(key);
                this.customerParamPanel.updateCustomerValue(key, null);
            }
        }
    }

    protected JPanel wrapTextArea(CustomerParamTextArea customerParamTextArea) {
        Dimension dimension = new Dimension(300, customerParamTextArea.getPreferredSize().height + 3);
        JScrollPane scrollPane = new JScrollPane(customerParamTextArea);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        JButton button = new JButton(ClientUtils.getIcon("dots"));
        button.setPreferredSize(new Dimension(21, 12));
        button.setMaximumSize(new Dimension(21, 12));
        button.addActionListener(e -> new CustomerParamHistoryDialog(customerParamTextArea.getTitle(), customerParamTextArea.getFieldKey(), this.customerParamPanel));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(customerParamTextArea.getTitle() + ":"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)button, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }
}

