/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternBaseTabPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class PatternLabelAndGroupTabPanel
extends PatternBaseTabPanel {
    private static final String GROUPS = "groups";
    private ContractLabelTree contractLabelTree = new ContractLabelTree();

    public PatternLabelAndGroupTabPanel(Document moduleDoc) {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.contractLabelTree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setData(Document doc) {
        try {
            this.contractLabelTree.setData(this.getContext().getPort(ContractLabelService.class).getContractLabelTreeItemList(-1, false));
        }
        catch (BGException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setPatternData(Element pattern) {
        long groups = Utils.parseLong(XMLUtils.getAttribute(pattern, GROUPS, "0"), 0L);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < 64; ++i) {
            if ((groups & 1L << i) <= 0L) continue;
            ids.add(i + 2);
        }
        for (Element itemElement : XMLUtils.selectElements(pattern, "//data/contractLabels/item")) {
            int contractLabelId = Utils.parseInt(itemElement.getAttribute("id"));
            if (ids.contains(contractLabelId)) continue;
            ids.add(contractLabelId);
        }
        this.contractLabelTree.setSelectedIds(ids);
    }

    @Override
    public void resetData() {
        this.contractLabelTree.setSelectedIds(new ArrayList<Integer>());
    }

    @Override
    public boolean setRequestData(Request request) {
        String ids = this.contractLabelTree.getSelectedIds().stream().collect(() -> new StringBuilder(), (accumulator, element) -> accumulator.append(element).append(","), StringBuilder::append).toString();
        request.setAttribute("contractLabels", ids);
        return true;
    }
}

