/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.flow;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Record;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Template;

public class NetFlow9Array0
extends FlowArray<NetFlow9Record> {
    private static final Logger log = LogManager.getLogger();

    public NetFlow9Array0(int size) {
        super(NetFlow9Array0.create(size));
    }

    private static final List<NetFlow9Record> create(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException(String.valueOf(size));
        }
        ArrayList<NetFlow9Record> recordList = new ArrayList<NetFlow9Record>(size);
        for (int i = 0; i < size; ++i) {
            recordList.add(new NetFlow9Record());
        }
        return recordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean parsePacket(ByteBuffer readBuffer, long millis, ConcurrentMap<Integer, NetFlow9Template> templates) {
        int bufferPosition = readBuffer.position();
        try {
            this.size = 0;
            int version = readBuffer.getShort(0) & 0xFFFF;
            int count = readBuffer.getShort(2) & 0xFFFF;
            if (version != 9) {
                log.error("Incorrect NetFlow version: " + version);
                boolean bl = false;
                return bl;
            }
            int packetLimit = readBuffer.limit();
            if (log.isDebugEnabled()) {
                log.debug("NetFlow9 packet, count: " + count + "; limit: " + packetLimit);
            }
            int offset = 20;
            int i = 0;
            while (offset < packetLimit) {
                NetFlow9Template template;
                int templateId;
                readBuffer.position(offset);
                int flowSetId = readBuffer.getShort(offset) & 0xFFFF;
                int flowSetLength = readBuffer.getShort(offset + 2) & 0xFFFF;
                int flowSetLimit = offset + flowSetLength;
                if (log.isDebugEnabled()) {
                    log.debug("FlowSet id: " + flowSetId + "; offset: " + offset + "; length: " + flowSetLength + "; limit: " + flowSetLimit);
                }
                if (flowSetId > 255) {
                    log.debug("Data flowset.");
                    templateId = flowSetId;
                    template = (NetFlow9Template)templates.get(templateId);
                    if (template != null) {
                        offset += 4;
                        int recordNum = 0;
                        if (log.isDebugEnabled()) {
                            log.debug("Template data length: " + template.dataLength);
                        }
                        while (offset + template.dataLength <= flowSetLimit) {
                            readBuffer.position(offset);
                            NetFlow9Record record = ((NetFlow9Record[])this.array)[recordNum];
                            record.fillData(readBuffer, template);
                            record.milliseconds = millis;
                            if (log.isDebugEnabled()) {
                                log.debug("Record: " + recordNum + "; offset: " + offset + "\n" + record);
                            }
                            ++recordNum;
                            offset += template.dataLength;
                        }
                        this.size += recordNum;
                    }
                } else {
                    log.debug("Template flowset!");
                    offset += 4;
                    while (offset < flowSetLimit) {
                        templateId = readBuffer.getShort(offset) & 0xFFFF;
                        template = new NetFlow9Template();
                        readBuffer.position(offset);
                        template.parse(readBuffer);
                        templates.put(templateId, template);
                        offset += template.length;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Offset: " + offset);
                    }
                }
                offset = flowSetLimit;
                ++i;
            }
        }
        finally {
            readBuffer.position(bufferPosition);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int next(ByteBuffer readBuffer, ConcurrentMap<Integer, NetFlow9Template> templates) {
        int offset = readBuffer.position();
        this.size = 0;
        int limit = readBuffer.limit() - 1;
        try {
            block3: while (offset < limit) {
                long millis = readBuffer.getLong(offset);
                int version = readBuffer.getShort(offset += 8) & 0xFFFF;
                int count = readBuffer.getShort(offset + 2) & 0xFFFF;
                if (version != 9) {
                    log.error("Incorrect NetFlow version: " + version);
                }
                if (log.isDebugEnabled()) {
                    log.trace("NetFlow9 packet, count: " + count);
                }
                offset += 20;
                while (offset < limit) {
                    NetFlow9Template template;
                    int templateId;
                    readBuffer.position(offset);
                    long testMillis = readBuffer.getLong(offset);
                    if (testMillis > millis - 86400000L && testMillis < millis + 86400000L) continue block3;
                    int flowSetId = readBuffer.getShort(offset) & 0xFFFF;
                    int flowSetLength = readBuffer.getShort(offset + 2) & 0xFFFF;
                    int flowSetEnd = offset + flowSetLength;
                    if (log.isTraceEnabled()) {
                        log.trace("FlowSet id: " + flowSetId + "; offset: " + offset + "; length: " + flowSetLength + "; end: " + flowSetEnd);
                    }
                    if (flowSetId > 255) {
                        log.trace("Data flowset.");
                        templateId = flowSetId;
                        template = (NetFlow9Template)templates.get(templateId);
                        if (template != null) {
                            offset += 4;
                            if (log.isTraceEnabled()) {
                                log.trace("Template data length: " + template.dataLength);
                            }
                            int flowSetLimit = flowSetEnd - template.dataLength;
                            while (offset <= flowSetLimit) {
                                readBuffer.position(offset);
                                NetFlow9Record record = ((NetFlow9Record[])this.array)[this.size];
                                record.fillData(readBuffer, template);
                                record.milliseconds = millis;
                                if (log.isTraceEnabled()) {
                                    log.trace("Record: " + this.size + "; offset: " + offset + "\n" + record);
                                }
                                ++this.size;
                                offset += template.dataLength;
                            }
                        }
                    } else if (flowSetId == 0) {
                        log.trace("Template flowset!");
                        readBuffer.position(offset);
                        offset += 4;
                        while (offset < flowSetEnd) {
                            templateId = readBuffer.getShort(offset) & 0xFFFF;
                            template = new NetFlow9Template();
                            readBuffer.position(offset);
                            template.parse(readBuffer);
                            templates.put(templateId, template);
                            offset += template.length;
                        }
                        if (log.isTraceEnabled()) {
                            log.trace("Offset: " + offset);
                        }
                    }
                    offset = flowSetEnd;
                }
            }
        }
        finally {
            readBuffer.position(offset);
        }
        return offset;
    }
}

