/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.client;

import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.json.JSONObject;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.RowData;
import ru.bitel.oss.kernel.entity.client.EntityAttributesForm;
import ru.bitel.oss.systems.inventory.product.client.ProductSpecActivationModePanel;
import ru.bitel.oss.systems.inventory.product.client.ProductSpecPanel;
import ru.bitel.oss.systems.inventory.product.client.ProductSpecServiceLinkPanel;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecServiceLink;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;

class ProductSpecForm
extends BGUPanel {
    private final ProductSpecPanel productSpecPanel;
    private JTabbedPane pane;
    private List<BGUPanel> panels;
    private AtomicReference<ProductSpec> currentRef = new AtomicReference();
    private JTextArea comment = new JTextArea();
    private JTextArea description = new JTextArea();
    private BGTextField title = new BGTextField();
    private BGTextField identifier = new BGTextField();
    private BGTextField productCost = new BGTextField();
    private IntTextField priority = new IntTextField();
    private BGUComboBox<IdTitle> periodic = new BGUComboBox();
    private BGUComboBox<IdTitle> realtime = new BGUComboBox();
    private BGUComboBox<IdTitle> activationByCustomerGroup = new BGUComboBox();
    private BGUComboBox<IdTitle> deactivationByCustomerGroup = new BGUComboBox();
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private BGControlPanelListSelect tariffPlans;
    private ContractLabelTree contractLabels;
    private DepensTableModel depensTableModel;
    private JPopupMenu depensPopupMenu;
    private List<String[]> incompatibleItems;
    private JCheckBox hide;
    private JRadioButton hideForGroupsModeOr;
    private JRadioButton hideForGroupsModeAnd;
    private ContractLabelTree hideForContractLabels;
    private ProductSpecActivationModePanel activationModePanel;
    private ProductSpecServiceLinkPanel serviceLinkPanel;
    private List<IdTitle> onOffItems = Arrays.asList(new IdTitle(0, "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e"), new IdTitle(1, "\u0440\u0430\u0437\u0440\u0435\u0449\u0435\u043d\u043e"));
    AbstractBGUPanel.DefaultAction add = new AbstractBGUPanel.DefaultAction("new", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c"){

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            if (ProductSpecForm.this.isShowing()) {
                ClientUtils.showErrorMessageDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442.");
                return;
            }
            ProductSpec current = new ProductSpec();
            current.setId(-1);
            current.setEntitySpecId(ProductSpecForm.this.productSpecPanel.getEntitySpecId());
            current.setEntityAttributes(new HashMap());
            ProductSpec parent = (ProductSpec)ProductSpecForm.this.productSpecPanel.getProductSpecTreeTableModel().getSelectedRow();
            if (parent != null) {
                current.setParentId(parent.getId());
            }
            ProductSpecForm.this.title.setText("");
            ProductSpecForm.this.identifier.setText("");
            ProductSpecForm.this.productCost.setText(Utils.formatCost(BigDecimal.ZERO));
            ProductSpecForm.this.periodic.setSelectedItem(1);
            ProductSpecForm.this.realtime.setSelectedItem(0);
            ProductSpecForm.this.priority.setValue(0L);
            ProductSpecForm.this.period.setDateCalendar1(null);
            ProductSpecForm.this.period.setDateCalendar2(null);
            ProductSpecForm.this.activationByCustomerGroup.setSelectedIndex(0);
            ProductSpecForm.this.deactivationByCustomerGroup.setSelectedIndex(0);
            ProductSpecForm.this.comment.setText("");
            ProductSpecForm.this.description.setText("");
            ProductSpecForm.this.tariffPlans.setListValues("");
            ProductSpecForm.this.contractLabels.setSelectedIds(Collections.emptyList());
            ProductSpec root = ProductSpecForm.this.productSpecPanel.getProductService().productSpecTree(Integer.valueOf(((ClientContext)ProductSpecForm.this.getContext()).getModuleId()), null, null, null, null);
            ArrayList<RowData> rowDatas = new ArrayList<RowData>();
            ProductSpecForm.this.getDependRowData(rowDatas, root, current.getDepends(), current.getIncompatible(), new JSONObject(current.getData()).optJSONObject("incompatible"), 0);
            ProductSpecForm.this.depensTableModel.setData(rowDatas);
            ProductSpecForm.this.hide.setSelected(false);
            ProductSpecForm.this.hideForGroupsModeOr.setSelected(true);
            ProductSpecForm.this.hideForContractLabels.setSelectedIds(Collections.emptyList());
            ArrayList<ProductSpecActivationMode> activationModeList = new ArrayList<ProductSpecActivationMode>();
            ProductSpecActivationMode defaultActivationMode = new ProductSpecActivationMode();
            defaultActivationMode.setProductSpecId(0);
            defaultActivationMode.setDateFrom(new Date());
            defaultActivationMode.setPeriodAmount(0);
            defaultActivationMode.setPeriodMode(111);
            defaultActivationMode.setDeactivationMode(10);
            defaultActivationMode.setReactivationMode(0);
            defaultActivationMode.setTitle("");
            activationModeList.add(defaultActivationMode);
            ProductSpecForm.this.activationModePanel.setData(activationModeList);
            ProductSpecForm.this.currentRef.set(current);
            for (BGUPanel panel : ProductSpecForm.this.panels) {
                panel.performAction("new");
            }
            ProductSpecForm.this.performActionOpen();
        }
    };
    AbstractBGUPanel.DefaultAction edit = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (ProductSpecForm.this.isShowing()) {
                ClientUtils.showErrorMessageDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442");
                return;
            }
            if (ProductSpecForm.this.productSpecPanel.getProductSpecTreeTableModel().getSelectedRow() != ProductSpecForm.this.productSpecPanel.getProductSpecTreeTableModel().getRoot()) {
                ProductSpec current = (ProductSpec)ProductSpecForm.this.productSpecPanel.getProductSpecTreeTableModel().getSelectedRow();
                current = ProductSpecForm.this.productSpecPanel.getProductService().productSpecGet(current.getId());
                if (current != null) {
                    JSONObject data = new JSONObject(current.getData());
                    ProductSpecForm.this.title.setText(current.getTitle());
                    ProductSpecForm.this.identifier.setText(current.getIdentifier());
                    ProductSpecForm.this.productCost.setText(Utils.formatCost(data.optBigDecimal("cost", BigDecimal.ZERO)));
                    ProductSpecForm.this.periodic.setSelectedItem(current.isPeriodic() ? 1 : 0);
                    ProductSpecForm.this.realtime.setSelectedItem(current.isNotRealtime() ? 1 : 0);
                    ProductSpecForm.this.priority.setValue(current.getPriority());
                    ProductSpecForm.this.period.setDateCalendar1(TimeUtils.convertDateToCalendar(current.getDateFrom()));
                    ProductSpecForm.this.period.setDateCalendar2(TimeUtils.convertDateToCalendar(current.getDateTo()));
                    int activationByCustomerId = current.isActivationByCustomer() ? 1 : 0;
                    ProductSpecForm.this.activationByCustomerGroup.setSelectedItem(ProductSpecForm.this.onOffItems.stream().filter(a -> a.getId() == activationByCustomerId).findAny().orElse(ProductSpecForm.this.onOffItems.get(0)));
                    int deactivationByCustomerId = current.isDeactivationByCustomer() ? 1 : 0;
                    ProductSpecForm.this.deactivationByCustomerGroup.setSelectedItem(ProductSpecForm.this.onOffItems.stream().filter(a -> a.getId() == deactivationByCustomerId).findAny().orElse(ProductSpecForm.this.onOffItems.get(0)));
                    ProductSpecForm.this.comment.setText(current.getComment());
                    ProductSpecForm.this.description.setText(current.getDescription());
                    ProductSpecForm.this.tariffPlans.setListValues(Utils.toString(current.getTariffIds()));
                    ProductSpecForm.this.contractLabels.setSelectedIds(current.getContractLabels());
                    ProductSpec root = ProductSpecForm.this.productSpecPanel.getProductService().productSpecTree(Integer.valueOf(((ClientContext)ProductSpecForm.this.getContext()).getModuleId()), null, null, null, null);
                    ArrayList<RowData> rowDatas = new ArrayList<RowData>();
                    ProductSpecForm.this.getDependRowData(rowDatas, root, current.getDepends(), current.getIncompatible(), data.optJSONObject("incompatible"), 0);
                    ProductSpecForm.this.depensTableModel.setData(rowDatas);
                    ProductSpecForm.this.hide.setSelected(current.isHideForCustomer());
                    if (current.getHideForContractGroupsMode() == 0) {
                        ProductSpecForm.this.hideForGroupsModeOr.setSelected(true);
                    } else {
                        ProductSpecForm.this.hideForGroupsModeAnd.setSelected(true);
                    }
                    ProductSpecForm.this.hideForContractLabels.setSelectedIds(current.getHideForContractLabels());
                    ProductSpecForm.this.activationModePanel.setData(current.getActivationModeList());
                    current.setEntitySpecId(ProductSpecForm.this.productSpecPanel.getEntitySpecId());
                }
                ProductSpecForm.this.currentRef.set(current);
                for (BGUPanel panel : ProductSpecForm.this.panels) {
                    panel.performAction("edit");
                }
                ProductSpecForm.this.performActionOpen();
            }
        }
    };
    AbstractBGUPanel.DefaultAction remove = new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (!this.isEnabled()) {
                ClientUtils.showErrorMessageDialog("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
                return;
            }
            if (ProductSpecForm.this.isShowing()) {
                ClientUtils.showErrorMessageDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442");
                return;
            }
            ProductSpec selected = (ProductSpec)ProductSpecForm.this.productSpecPanel.getProductSpecTreeTableModel().getSelectedRow();
            if (selected == null || selected == ProductSpecForm.this.productSpecPanel.getProductSpecTreeTableModel().getRoot()) {
                ClientUtils.showMessageDialog("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d");
                return;
            }
            if (selected.getChildren() != null) {
                ClientUtils.showErrorMessageDialog("\u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b");
                return;
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u043f\u0440\u043e\u0434\u0443\u043a\u0442?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                ProductSpecForm.this.productSpecPanel.getProductService().productSpecDelete(selected.getId());
                ProductSpecForm.this.productSpecPanel.getProductSpecTreeTableModel().setSelectedRow(selected.getParentId());
                ProductSpecForm.this.productSpecPanel.performAction("refresh");
            }
        }
    };
    AbstractBGUPanel.DefaultAction ok = new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            BigDecimal cost = BigDecimal.ZERO;
            try {
                cost = new BigDecimal(ProductSpecForm.this.productCost.getText());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430");
                return;
            }
            ProductSpec current = ProductSpecForm.this.currentRef.get();
            current.setModuleId(((ClientContext)ProductSpecForm.this.getContext()).getModuleId());
            current.setTitle(ProductSpecForm.this.title.getText());
            current.setIdentifier(ProductSpecForm.this.identifier.getText());
            current.setPeriodic(((IdTitle)ProductSpecForm.this.periodic.getSelectedItem()).getId() == 1);
            current.setNotRealtime(((IdTitle)ProductSpecForm.this.realtime.getSelectedItem()).getId() == 1);
            current.setPriority((int)ProductSpecForm.this.priority.getValue());
            current.setDateFrom(TimeUtils.convertCalendarToDate(ProductSpecForm.this.period.getDateCalendar1()));
            current.setDateTo(TimeUtils.convertCalendarToDate(ProductSpecForm.this.period.getDateCalendar2()));
            current.setActivationByCustomer(((IdTitle)ProductSpecForm.this.activationByCustomerGroup.getSelectedItem()).getId() == 1);
            current.setDeactivationByCustomer(((IdTitle)ProductSpecForm.this.deactivationByCustomerGroup.getSelectedItem()).getId() == 1);
            current.setComment(ProductSpecForm.this.comment.getText());
            current.setDescription(ProductSpecForm.this.description.getText());
            current.setTariffIds(Utils.toIntegerSet(ProductSpecForm.this.tariffPlans.getListValues()));
            current.setContractLabels(new HashSet<Integer>(ProductSpecForm.this.contractLabels.getSelectedIds()));
            current.setDepends(ProductSpecForm.this.depensTableModel.getDependIds());
            current.setIncompatible(ProductSpecForm.this.depensTableModel.getIncompatibleIds());
            JSONObject data = new JSONObject(current.getData());
            data.put("incompatible", (Object)ProductSpecForm.this.depensTableModel.getIncompatibleData());
            data.put("cost", (Object)cost);
            current.setData(data.toString());
            current.setHideForCustomer(ProductSpecForm.this.hide.isSelected());
            current.setHideForContractGroupsMode(ProductSpecForm.this.hideForGroupsModeAnd.isSelected() ? 1 : 0);
            current.setHideForContractLabels(new HashSet<Integer>(ProductSpecForm.this.hideForContractLabels.getSelectedIds()));
            current.setActivationModeList(ProductSpecForm.this.activationModePanel.getData());
            for (BGUPanel panel : ProductSpecForm.this.panels) {
                if (panel.performAction("ok")) continue;
                return;
            }
            int id = ProductSpecForm.this.productSpecPanel.getProductService().productSpecUpdate(ProductSpecForm.this.currentRef.get());
            ProductSpecForm.this.productSpecPanel.performAction("refresh");
            ProductSpecForm.this.productSpecPanel.getProductSpecTreeTableModel().setSelectedRow(id);
            ProductSpecForm.this.performActionClose();
        }
    };
    final Set<Integer> cutSet = new HashSet<Integer>();
    final Set<Integer> copySet = new HashSet<Integer>();
    AbstractBGUPanel.MenuAction copy = new AbstractBGUPanel.MenuAction("ProductSpec.copy", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c", (Icon)ClientUtils.getIcon("copy")){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ProductSpecForm.this.copySet.clear();
            ProductSpecForm.this.cutSet.clear();
            List selectedRows = ProductSpecForm.this.productSpecPanel.getProductSpecTreeTableModel().getSelectedRows();
            if (selectedRows == null) {
                return;
            }
            for (ProductSpec d : selectedRows) {
                ProductSpecForm.this.copySet.add(d.getId());
            }
        }
    };
    AbstractBGUPanel.MenuAction cut = new AbstractBGUPanel.MenuAction("ProductSpec.cut", "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", (Icon)ClientUtils.getIcon("cut")){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ProductSpecForm.this.copySet.clear();
            ProductSpecForm.this.cutSet.clear();
            List selectedRows = ProductSpecForm.this.productSpecPanel.getProductSpecTreeTableModel().getSelectedRows();
            if (selectedRows == null) {
                return;
            }
            for (ProductSpec d : selectedRows) {
                ProductSpecForm.this.cutSet.add(d.getId());
            }
        }
    };
    AbstractBGUPanel.MenuAction paste = new AbstractBGUPanel.MenuAction("ProductSpec.paste", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", (Icon)ClientUtils.getIcon("paste")){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ProductSpec parent = (ProductSpec)ProductSpecForm.this.productSpecPanel.getProductSpecTreeTableModel().getSelectedRow();
            if (parent != null) {
                ProductService productService = ((ClientContext)ProductSpecForm.this.getContext()).getPort(ProductService.class, 0);
                if (ProductSpecForm.this.copySet.size() > 0) {
                    for (Integer productSpecId : ProductSpecForm.this.copySet) {
                        ProductSpec productSpec = productService.productSpecGet(productSpecId.intValue());
                        productSpec.setParentId(parent.getId());
                        productSpec.setId(0);
                        for (ProductSpecActivationMode activationMode : productSpec.getActivationModeList()) {
                            activationMode.setId(0);
                            activationMode.setProductSpecId(0);
                        }
                        int newProductSpecId = productService.productSpecUpdate(productSpec);
                        List serviceLinkList = productService.serviceLinkList(productSpecId.intValue(), null);
                        for (ProductSpecServiceLink link : serviceLinkList) {
                            link.setId(0);
                        }
                        productService.serviceLinkUpdate(newProductSpecId, serviceLinkList);
                    }
                    ProductSpecForm.this.productSpecPanel.performAction("refresh");
                } else if (ProductSpecForm.this.cutSet.size() > 0) {
                    productService.productSpecMove(parent.getId(), ProductSpecForm.this.cutSet);
                    ProductSpecForm.this.cutSet.clear();
                    ProductSpecForm.this.productSpecPanel.performAction("refresh");
                }
            }
        }
    };

    public ProductSpecForm(ProductSpecPanel productSpecPanel, ClientContext context) {
        super((LayoutManager)new BorderLayout(), context);
        this.productSpecPanel = productSpecPanel;
        this.setName("ProductSpecForm");
    }

    @Override
    protected void jbInit() throws Exception {
        BGSwingUtilites.wrapBorder(this, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430");
        JPanel titlePanel = new JPanel(new GridBagLayout());
        titlePanel.add((Component)new JLabel("\u041f\u0440\u043e\u0434\u0443\u043a\u0442:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 5), 0, 0));
        titlePanel.add((Component)this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.pane = new JTabbedPane();
        this.panels = new ArrayList<BGUPanel>();
        this.pane.addTab("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", this.getBasePanel());
        EntityAttributesForm bguPanel = new EntityAttributesForm(this.currentRef, (ClientContext)this.getContext());
        this.pane.addTab("\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044b", bguPanel);
        this.panels.add(bguPanel);
        this.serviceLinkPanel = new ProductSpecServiceLinkPanel(this, this.currentRef);
        this.pane.addTab("\u0421\u0435\u0440\u0432\u0438\u0441\u044b", this.serviceLinkPanel);
        this.panels.add(this.serviceLinkPanel);
        this.activationModePanel = new ProductSpecActivationModePanel();
        this.pane.addTab("\u0420\u0435\u0436\u0438\u043c\u044b \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", this.activationModePanel);
        this.tariffPlans = new BGControlPanelListSelect(0);
        this.contractLabels = new ContractLabelTree(((ClientContext)this.getContext()).getPort(ContractLabelService.class, 0));
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.addTab("\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043f\u043b\u0430\u043d\u044b", this.tariffPlans);
        tabPane.addTab("\u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", this.contractLabels);
        JPanel availablePanel = new JPanel(new GridLayout(0, 2));
        this.tariffPlans.setBorder(new BGTitleBorder("\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043f\u043b\u0430\u043d\u044b:"));
        availablePanel.add(this.tariffPlans);
        this.contractLabels.setBorder(new BGTitleBorder("\u041c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432:"));
        availablePanel.add(new JScrollPane(this.contractLabels));
        this.pane.addTab("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0441\u0442\u044c", availablePanel);
        this.pane.addTab("\u0417\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c", this.getDependPanel());
        this.hide = new JCheckBox("\u0421\u043a\u0440\u044b\u0442 \u0432 \u0432\u0435\u0431-\u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0435");
        this.hideForGroupsModeOr = new JRadioButton("\u0418\u041b\u0418");
        this.hideForGroupsModeAnd = new JRadioButton("\u0418");
        this.hideForContractLabels = new ContractLabelTree(((ClientContext)this.getContext()).getPort(ContractLabelService.class, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel hideForGroups = new JPanel(new GridBagLayout());
        panel.add((Component)this.hide, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        hideForGroups.setBorder(BorderFactory.createTitledBorder("\u0421\u043a\u0440\u044b\u0442 \u0432 \u0432\u0435\u0431-\u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0435 \u0434\u043b\u044f \u0433\u0440\u0443\u043f\u043f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432"));
        panel.add((Component)hideForGroups, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        hideForGroups.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u044f:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 5), 0, 0));
        hideForGroups.add((Component)this.hideForGroupsModeOr, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 3), 0, 0));
        hideForGroups.add((Component)this.hideForGroupsModeAnd, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 3), 0, 0));
        hideForGroups.add((Component)new JScrollPane(this.hideForContractLabels), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        ButtonGroup group = new ButtonGroup();
        group.add(this.hideForGroupsModeOr);
        group.add(this.hideForGroupsModeAnd);
        this.pane.addTab("\u0412\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u044c", panel);
        Request request = new Request();
        request.setModule("tariff");
        request.setAction("ListTariffPlans");
        Document doc = ((ClientContext)this.getContext()).getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            ClientUtils.buildList(this.tariffPlans.getList(), this.tariffPlans.getListModel(), XMLUtils.selectNode(doc, "//tariffPlans"));
        }
        this.incompatibleItems = this.productSpecPanel.getProductService().getIncompatibleItems(((ClientContext)this.getContext()).getModuleId());
        this.add((Component)this.pane, "Center");
        this.add((Component)titlePanel, "North");
    }

    private JPanel getBasePanel() {
        this.identifier.setHorizontalAlignment(0);
        this.productCost.setHorizontalAlignment(0);
        this.priority.setMaxValue(999999999L);
        this.comment.setLineWrap(true);
        this.comment.setWrapStyleWord(true);
        this.comment.setMargin(new Insets(3, 3, 3, 3));
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        this.description.setMargin(new Insets(3, 3, 3, 3));
        ArrayList<IdTitle> data = new ArrayList<IdTitle>();
        data.add(new IdTitle(1, "\u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0439"));
        data.add(new IdTitle(0, "\u0435\u0434\u0438\u043d\u043e\u0440\u0430\u0437\u043e\u0432\u044b\u0439"));
        this.periodic.setData(data);
        data = new ArrayList();
        data.add(new IdTitle(0, "\u0432 \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u043c \u0432\u0440\u0435\u043c\u0435\u043d\u0438"));
        data.add(new IdTitle(1, "\u043f\u043e \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0443"));
        this.realtime.setData(data);
        this.activationByCustomerGroup.setData(this.onOffItems);
        this.deactivationByCustomerGroup.setData(this.onOffItems);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add((Component)this.period, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("\u0422\u0438\u043f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add(this.periodic, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("\u041f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add(this.realtime, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add(this.activationByCustomerGroup, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add(this.deactivationByCustomerGroup, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add((Component)this.identifier, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add((Component)this.priority, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add((Component)this.productCost, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        BGSwingUtilites.wrapEmptyBorder(leftPanel);
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        rightPanel.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)new JScrollPane(this.description), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        BGSwingUtilites.wrapEmptyBorder(rightPanel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new BGSplitPaneNoBorder(1, leftPanel, (Component)rightPanel, 400L), "Center");
        return panel;
    }

    private JPanel getDependPanel() {
        this.depensTableModel = new DepensTableModel(DepensTableModel.class.getName());
        final BGUTable dependsTable = new BGUTable(this.depensTableModel);
        dependsTable.setSelectionMode(0);
        dependsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int column;
                if (mouseEvent.getClickCount() == 2 && (column = dependsTable.convertColumnIndexToModel(dependsTable.columnAtPoint(mouseEvent.getPoint()))) < 2) {
                    JSONObject json = ((RowData)ProductSpecForm.this.depensTableModel.getSelectedRow()).getJson();
                    if (column == 1) {
                        Rectangle cell = dependsTable.getCellRect(dependsTable.rowAtPoint(mouseEvent.getPoint()), dependsTable.columnAtPoint(mouseEvent.getPoint()), true);
                        ProductSpecForm.this.getDepensPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX() - 50, cell.y + cell.height);
                    } else {
                        String key = column == 0 ? "d" : "i";
                        json.put(key, !json.getBoolean(key));
                    }
                    dependsTable.repaint();
                }
            }
        });
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(dependsTable), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPopupMenu getDepensPopupMenu() {
        if (this.depensPopupMenu == null) {
            this.depensPopupMenu = new JPopupMenu();
            ActionListener actionListener = e -> {
                JSONObject json = ((RowData)this.depensTableModel.getSelectedRow()).getJson();
                json.put("i", (Object)e.getActionCommand());
            };
            for (String[] item : this.incompatibleItems) {
                JMenuItem menuItem = new JMenuItem();
                menuItem.setActionCommand(item[0]);
                menuItem.setText(item[1]);
                menuItem.addActionListener(actionListener);
                this.depensPopupMenu.add(menuItem);
            }
            JMenuItem menuItem = new JMenuItem();
            menuItem.setActionCommand("");
            menuItem.setText("<\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e>");
            menuItem.addActionListener(actionListener);
            this.depensPopupMenu.add(menuItem);
        }
        return this.depensPopupMenu;
    }

    private void getDependRowData(List<RowData> rowDatas, ProductSpec productSpec, Set<Integer> depenIds, Set<Integer> incompIds, JSONObject incompData, int level) {
        JSONObject json = new JSONObject();
        json.put("id", productSpec.getId());
        json.put("title", (Object)(String.join((CharSequence)"", Collections.nCopies(level, "     ")) + productSpec.getTitle()));
        json.put("d", depenIds != null ? depenIds.contains(productSpec.getId()) : false);
        String value = "";
        if (incompIds != null && !incompIds.isEmpty()) {
            value = String.valueOf(incompIds.contains(productSpec.getId()));
        } else if (incompData != null && !incompData.keySet().isEmpty()) {
            value = incompData.optString(String.valueOf(productSpec.getId()), "");
        }
        json.put("i", (Object)value);
        rowDatas.add(new RowData(json));
        if (productSpec.getChildren() != null) {
            for (ProductSpec productSpecChild : productSpec.getChildren()) {
                this.getDependRowData(rowDatas, productSpecChild, depenIds, incompIds, incompData, level + 1);
            }
        }
    }

    class DepensTableModel
    extends BGTableModel<RowData> {
        public static final String COLUMN_TITLE = "title";
        public static final String COLUMN_D = "d";
        public static final String COLUMN_I = "i";

        public DepensTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0417\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c", 120, 200, 250, COLUMN_D, true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c", 120, 300, 400, COLUMN_I, true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0440\u043e\u0434\u0443\u043a\u0442", 200, 400, -1, COLUMN_TITLE, true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(RowData rowData, int column) throws BGException {
            String i;
            JSONObject json = rowData.getJson();
            switch (i = this.getIdentifier(column)) {
                case "title": {
                    return json.optString(i);
                }
                case "d": {
                    return json.optBoolean(i) ? "\u0437\u0430\u0432\u0438\u0441\u0438\u0442" : "\u043d\u0435 \u0437\u0430\u0432\u0438\u0441\u0438\u0442";
                }
                case "i": {
                    String val = json.optString(COLUMN_I, "");
                    for (String[] item : ProductSpecForm.this.incompatibleItems) {
                        if (val.equals(item[0])) {
                            return item[1];
                        }
                        if ("true".equals(val)) {
                            return "\u043d\u0435 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c";
                        }
                        if (!"false".equals(val)) continue;
                        return "\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c";
                    }
                    return val;
                }
            }
            return super.getValueAt(rowData, column);
        }

        public Set<Integer> getDependIds() {
            return this.getIds(COLUMN_D);
        }

        public Set<Integer> getIncompatibleIds() {
            return this.getIds(COLUMN_I);
        }

        public JSONObject getIncompatibleData() {
            JSONObject incompatibleData = new JSONObject();
            for (RowData rowData : this.getRows()) {
                String val = rowData.getJson().optString(COLUMN_I, "false");
                if ("true".equals(val) || "false".equals(val) || "".equals(val)) continue;
                incompatibleData.put(String.valueOf(rowData.getJson().getInt("id")), (Object)val);
            }
            return incompatibleData;
        }

        private Set<Integer> getIds(String key) {
            HashSet<Integer> ids = new HashSet<Integer>();
            for (RowData rowData : this.getRows()) {
                if (!"true".equals(rowData.getJson().optString(key, "false"))) continue;
                ids.add(rowData.getJson().getInt("id"));
            }
            return ids;
        }
    }
}

