/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.action.web;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.license.common.LicenseUtils;
import ru.bitel.bgbilling.modules.license.common.OrderUtils;
import ru.bitel.bgbilling.modules.license.common.bean.Component;
import ru.bitel.bgbilling.modules.license.common.bean.ComponentCategory;
import ru.bitel.bgbilling.modules.license.common.bean.ConfirmedOrder;
import ru.bitel.bgbilling.modules.license.common.bean.Copy;
import ru.bitel.bgbilling.modules.license.common.bean.License;
import ru.bitel.bgbilling.modules.license.common.bean.Order;
import ru.bitel.bgbilling.modules.license.common.bean.OrderType;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;

public class ActionLicense
extends AbstractAction {
    private final String module = "license";
    private static final Object mutex = new Object();

    public void execute() throws BGException {
        this.productCopy();
    }

    public void licenseList() throws BGException {
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        int copyId = this.req.getInt("copyId", -1);
        Copy copy = licenseManager.getCopy(copyId);
        if (copy != null && copy.getContractId() == this.contractId) {
            this.context.getRequest().setAttribute("copy", (Object)copy);
            this.context.getRequest().setAttribute("licenseList", licenseManager.getLicenses(copyId));
        }
        this.requestDispatcher("license", "license_list");
    }

    public void licenseComponents() throws BGException {
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        License license = licenseManager.getLicenseById(this.req.getInt("licenseId", -1));
        if (license != null) {
            Copy copy = licenseManager.getCopy(license.getCopyId());
            if (copy != null && copy.getContractId() == this.contractId) {
                String productVersion = copy.getProductVersion();
                this.licenseItemsList(license.getId(), productVersion, licenseManager);
            }
            this.context.getRequest().setAttribute("license", (Object)license);
        }
        this.requestDispatcher("license", "license_components");
    }

    public void licenseText() throws BGException {
        Copy copy;
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        License license = licenseManager.getLicenseById(this.req.getInt("licenseId", -1));
        if (license != null && (copy = licenseManager.getCopy(license.getCopyId())) != null && copy.getContractId() == this.contractId) {
            this.context.getRequest().setAttribute("licenseText", (Object)licenseManager.getLicenseText(license.getId()));
        }
        this.requestDispatcher("license", "license_text");
    }

    public void licenseToEmail() throws BGException {
        this.context.getRequest().setAttribute("licenseId", (Object)this.req.getInt("licenseId", -1));
        this.context.getRequest().setAttribute("recipientList", this.getRecipientList());
        this.requestDispatcher("license", "license_mail");
    }

    public void sendLicenseToEmail() throws BGException {
        int licenseId = this.req.getInt("licenseId", -1);
        StringBuilder sendEmailMessage = new StringBuilder();
        StringBuilder sendEmailError = new StringBuilder();
        String mails = this.req.get("email");
        if (!mails.isEmpty()) {
            try {
                Copy copy;
                LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
                License license = licenseManager.getLicenseById(licenseId);
                if (license != null && (copy = licenseManager.getCopy(license.getCopyId())) != null && copy.getContractId() == this.contractId) {
                    String licenseText = licenseManager.getLicenseText(license.getId());
                    LicenseUtils.sendLiceneseText((Setup)this.setup, (String)mails, (String)licenseText, (String)"\u0422\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438");
                    sendEmailMessage.append("\u0422\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u043d\u0430 \u0430\u0434\u0440\u0435\u0441(\u0430): ");
                    sendEmailMessage.append(mails);
                }
            }
            catch (Exception e) {
                sendEmailError.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f: ");
                sendEmailError.append(e.getMessage());
            }
        } else {
            sendEmailError.append("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438. \u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438.");
        }
        this.context.getRequest().setAttribute("sendEmailMessage", (Object)sendEmailMessage.toString());
        this.context.getRequest().setAttribute("sendEmailError", (Object)sendEmailError.toString());
        this.requestDispatcher("license", "license_mail_message");
    }

    public void getLicense() throws BGException {
        Copy copy;
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        int copyId = this.req.getInt("copyId", -1);
        License license = licenseManager.getCurrentLicense(copyId);
        if (license != null && (copy = licenseManager.getCopy(license.getCopyId())) != null && copy.getContractId() == this.contractId) {
            String licenseText = licenseManager.getLicenseText(license.getId());
            this.context.getRequest().setAttribute("contentType", (Object)"binary");
            this.context.getResponse().setContentType("application/txt;charset=UTF-8");
            this.context.getResponse().setHeader("Content-Disposition", "attachment;filename=\"lic.properties\"");
            try {
                ServletOutputStream responseStream = this.context.getResponse().getOutputStream();
                responseStream.write(licenseText.getBytes());
                responseStream.flush();
                responseStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void licenseOrders() throws BGException {
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        int copyId = this.req.getInt("copyId", -1);
        Copy copy = licenseManager.getCopy(copyId);
        if (copy != null && copy.getContractId() == this.contractId) {
            this.context.getRequest().setAttribute("copy", (Object)copy);
        }
        this.requestDispatcher("license", "license_orders");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void licenseOrderComponents() throws BGException {
        int orderIndex;
        int copyId = this.req.getInt("copyId", -1);
        ArrayList<Order> orders = (ArrayList<Order>)this.context.getRequest().getSession().getAttribute("orders");
        if (orders == null) {
            orders = new ArrayList<Order>();
            this.context.getRequest().getSession().setAttribute("orders", orders);
        } else {
            boolean reset = false;
            for (Order order : orders) {
                if (order.getCopyId() == copyId) continue;
                reset = true;
                break;
            }
            if (reset) {
                orders = new ArrayList();
                this.context.getRequest().getSession().setAttribute("orders", orders);
            }
        }
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        List<Component> productItems = licenseManager.getComponentList(copyId, false, true);
        HashMap<Integer, Component> componentMap = new HashMap<Integer, Component>();
        int productItemId = this.req.getInt("productItemId", -1);
        if (productItemId > 0) {
            boolean add = false;
            for (Object component : productItems) {
                if (component.getId() != productItemId) continue;
                add = true;
                break;
            }
            if (add) {
                Object component;
                Order order = null;
                component = mutex;
                synchronized (component) {
                    add = true;
                    for (Order checkOrder : orders) {
                        if (checkOrder.getCopyId() != copyId || checkOrder.getComponentId() != productItemId) continue;
                        order = checkOrder;
                        add = false;
                        break;
                    }
                    if (add) {
                        order = new Order();
                        order.setCopyId(copyId);
                        order.setComponentId(productItemId);
                        order.setStatus(0);
                        order.setUserId(0);
                        orders.add(order);
                    }
                    order.setType(OrderType.getOrderTypeByCode((int)this.req.getInt("orderType", 1)));
                    order.setCount(this.req.getInt("orderCount", 1));
                    order.setTerm(this.req.getInt("orderTerm", 0));
                }
            }
        }
        if ((orderIndex = this.req.getInt("orderIndex", -1)) > -1) {
            orders.remove(orderIndex);
        }
        block6: for (Order order : orders) {
            int len = productItems.size();
            for (int i = 0; i < len; ++i) {
                Component component = productItems.get(i);
                if (order.getComponentId() != component.getId()) continue;
                componentMap.put(component.getId(), component);
                productItems.remove(i);
                continue block6;
            }
        }
        int categoryId = this.req.getInt("categoryId", Utils.parseInt((String)((String)this.context.getRequest().getSession().getAttribute("categoryId")), (int)-1));
        this.context.getRequest().getSession().setAttribute("categoryId", (Object)String.valueOf(categoryId));
        if (categoryId > -1) {
            ArrayList<Component> filterPproductItems = new ArrayList<Component>();
            productItems.stream().filter(a -> a.getCategory().getCode() == categoryId).forEach(a -> filterPproductItems.add((Component)a));
            productItems = filterPproductItems;
        }
        this.context.getRequest().setAttribute("productItems", productItems);
        this.context.getRequest().setAttribute("componentMap", componentMap);
        this.context.getRequest().setAttribute("componentCategory", (Object)ComponentCategory.values());
        this.requestDispatcher("license", "license_orders_product_items");
    }

    public void licenseEditComponent() throws BGException {
        int orderIndex;
        ArrayList orders = (ArrayList)this.context.getRequest().getSession().getAttribute("orders");
        if (orders == null) {
            orders = new ArrayList();
            this.context.getRequest().getSession().setAttribute("orders", orders);
        }
        if ((orderIndex = this.req.getInt("orderIndex", -1)) > -1 && orderIndex < orders.size()) {
            Order order = (Order)orders.get(orderIndex);
            LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
            this.context.getRequest().setAttribute("productItem", (Object)licenseManager.getComponent(order.getComponentId()));
            this.context.getRequest().setAttribute("order", (Object)order);
        }
        this.requestDispatcher("license", "license_orders_editor");
    }

    private void productCopy() throws BGException {
        if (this.contractId <= 0 && this.moduleId <= 0) {
            throw new BGIllegalArgumentException();
        }
        List<Copy> copies = new LicenseManager(this.con, this.moduleId).getCopyList(this.contractId);
        this.context.getRequest().setAttribute("copies", copies);
        this.context.getRequest().setAttribute("copyId", (Object)(copies.isEmpty() ? -1 : copies.get(0).getId()));
    }

    private void licenseItemsList(int licenseId, String productVersion, LicenseManager licenseManager) {
        List<ConfirmedOrder> confirmedOrders = licenseManager.getLicenseItems(licenseId, false);
        Map<String, BigDecimal> licenseItemCosts = this.getItemsCosts(confirmedOrders, productVersion);
        BigDecimal totalCost = BigDecimal.ZERO;
        Date now = new Date();
        ArrayList licenseItems = new ArrayList();
        for (ConfirmedOrder item : confirmedOrders) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", OrderUtils.getType((OrderType)OrderType.getOrderTypeByCode((int)item.getType())));
            map.put("title", item.getComponentTitle());
            map.put("ids", item.getIds());
            map.put("count", OrderUtils.getCount((Integer)item.getCount()));
            if (TimeUtils.dateBeforeOrEq((Date)item.getDateTo(), (Date)now)) {
                map.put("dateOf", "true");
            }
            map.put("to_date", TimeUtils.format((Date)item.getDateTo(), (String)"dd.MM.yyyy"));
            BigDecimal itemCost = licenseItemCosts.get(item.getComponentName());
            if (itemCost == null || item.getType() == OrderType.TEST.getCode()) {
                itemCost = BigDecimal.ZERO;
            }
            totalCost = totalCost.add(itemCost);
            map.put("cost", itemCost);
            licenseItems.add(map);
        }
        this.context.getRequest().setAttribute("licenseItemsList", licenseItems);
        this.context.getRequest().setAttribute("totalCost", (Object)totalCost);
    }

    private Map<String, BigDecimal> getItemsCosts(List<ConfirmedOrder> items, String productVersion) {
        return LicenseUtils.getCosts((String)LicenseUtils.buildLicenseCostUrlRequest(items, (String)productVersion, (ParameterMap)this.moduleSetup));
    }

    private List<String> getRecipientList() throws BGException {
        try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
            List recipientList = null;
            int emailParameterId = this.moduleSetup.getInt("license.email.parameter.id", 0);
            EntityAttr entityAttr = contractDao.getContractParameter(this.contractId, emailParameterId);
            if (entityAttr instanceof EntityAttrEmail) {
                recipientList = ((EntityAttrEmail)entityAttr).getAddressList();
            }
            List list = recipientList;
            return list;
        }
    }
}

