/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mangooffice.client;

import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.mangooffice.client.MangoContractAccountPanel;
import ru.bitel.bgbilling.modules.mangooffice.client.MangoContractFeesPanel;
import ru.bitel.bgbilling.modules.mangooffice.client.MangoContractPhonePanel;
import ru.bitel.bgbilling.modules.mangooffice.common.service.MangoService;
import ru.bitel.common.model.IdTitle;

public class ServicePropertiesPanel
extends ServicePanel {
    private MangoContractAccountPanel mainPanel = new MangoContractAccountPanel();
    private MangoContractPhonePanel phonePanel = new MangoContractPhonePanel();
    private MangoContractFeesPanel feesPanel = new MangoContractFeesPanel();
    private JTabbedPane tabPane = new JTabbedPane();
    private boolean feesWasInit = false;
    private boolean phoneWasInit = false;
    private List<IdTitle> tariffTypeList = null;
    private Map<Integer, IdTitle> tariffTypeMap = null;
    private MangoService mangoService = null;

    public ServicePropertiesPanel() {
        this.tabPane.addTab("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u0438 \u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b", (Component)((Object)this.mainPanel));
        this.tabPane.addTab("\u0422\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u044b\u0435 \u043d\u043e\u043c\u0435\u0440\u0430", (Component)((Object)this.phonePanel));
        this.tabPane.addTab("\u0421\u043f\u0438\u0441\u0430\u043d\u0438\u044f", (Component)((Object)this.feesPanel));
        this.setLayout(new GridBagLayout());
        this.add(this.tabPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ServicePropertiesPanel.this.tabPane.getSelectedComponent() == ServicePropertiesPanel.this.feesPanel) {
                    if (!ServicePropertiesPanel.this.feesWasInit) {
                        ServicePropertiesPanel.this.feesPanel.performAction("refresh");
                        ServicePropertiesPanel.this.feesWasInit = true;
                    }
                } else if (ServicePropertiesPanel.this.tabPane.getSelectedComponent() == ServicePropertiesPanel.this.phonePanel && !ServicePropertiesPanel.this.phoneWasInit) {
                    ServicePropertiesPanel.this.phonePanel.performAction("refresh");
                    ServicePropertiesPanel.this.phoneWasInit = true;
                }
            }
        });
    }

    public void setData() {
        try {
            if (this.mangoService == null) {
                this.mangoService = (MangoService)this.getContext().getPort(MangoService.class, this.getModuleId());
                this.tariffTypeList = this.mangoService.getTariffTypeList();
                this.mainPanel.tariffTypeList = this.tariffTypeList;
                this.phonePanel.tariffTypeList = this.tariffTypeList;
                if (this.tariffTypeList != null && this.tariffTypeList.size() > 0) {
                    this.tariffTypeMap = new HashMap<Integer, IdTitle>();
                    this.tariffTypeList.forEach(type -> this.tariffTypeMap.put(type.getId(), (IdTitle)type));
                    this.mainPanel.tariffTypeMap = this.tariffTypeMap;
                    this.phonePanel.tariffTypeMap = this.tariffTypeMap;
                }
            }
        }
        catch (BGException e) {
            this.getContext().processException((Throwable)e);
        }
        Component c = this.tabPane.getSelectedComponent();
        if (c instanceof BGUPanel) {
            ((BGUPanel)c).performAction(null, "refresh", "refresh");
        }
    }

    public void newItem() {
        Component c = this.tabPane.getSelectedComponent();
        if (c instanceof BGUPanel) {
            ((BGUPanel)c).performAction("new");
        }
    }

    public void editItem() {
        Component c = this.tabPane.getSelectedComponent();
        if (c instanceof BGUPanel) {
            ((BGUPanel)c).performAction("edit");
        }
    }

    public void deleteItem() {
        Component c = this.tabPane.getSelectedComponent();
        if (c instanceof BGUPanel) {
            ((BGUPanel)c).performAction("delete");
        }
    }
}

