/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.tariff;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ModuleServiceTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.megogo.server.tariff.MegogoServiceCost;
import ru.bitel.bgbilling.modules.megogo.server.tariff.MegogoTariffContext;
import ru.bitel.bgbilling.modules.megogo.server.tariff.MegogoTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.worker.ThreadContext;

public class CalculateModeTariffTreeNode
extends ModuleServiceTariffTreeNode<MegogoTariffContext, MegogoServiceCost, MegogoTariffRequest> {
    public static final int MODE_MONTH = 0;
    public static final int MODE_DAY = 1;
    public static final int MODE_ADVANCE = 3;
    private final int mode;
    private final int calcType;

    public CalculateModeTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        String modeParam = parameterMap.get("mode", null);
        this.mode = "day".equals(modeParam) ? 1 : 0;
        this.calcType = parameterMap.getInt("type", 0);
    }

    public int execute(Long treeNodeId, Long parentTreeNodeId, MegogoTariffRequest req, TariffTreeNodeHolder holder, MegogoTariffContext context, TreeContext treeContext, ThreadContext workerContext) {
        List serviceCostList = (List)req.getServiceCost().get(this.serviceId);
        if (serviceCostList == null) {
            return 0;
        }
        switch (this.mode) {
            case 0: {
                int size = serviceCostList.size();
                for (int i = 0; i < size; ++i) {
                    req.serviceCost = (ServiceCost)serviceCostList.get(i);
                    this.monthMode(treeNodeId, req, holder, context, treeContext, workerContext);
                }
                break;
            }
            case 1: {
                int size = serviceCostList.size();
                for (int i = 0; i < size; ++i) {
                    req.serviceCost = (ServiceCost)serviceCostList.get(i);
                    this.dayMode(treeNodeId, req, holder, context, treeContext, workerContext);
                }
                break;
            }
            default: {
                req.addError("Unknown mode");
            }
        }
        return 1;
    }

    public void dayMode(Long treeNodeId, MegogoTariffRequest req, TariffTreeNodeHolder holder, MegogoTariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        Calendar end;
        Calendar date1 = ((MegogoServiceCost)req.serviceCost).date1;
        Calendar date2 = ((MegogoServiceCost)req.serviceCost).date2;
        Calendar time = req.getTime();
        BigDecimal inCost = ((MegogoServiceCost)req.serviceCost).cost;
        Map pushed = req.acceptedSetPush();
        Calendar day = (Calendar)date1.clone();
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)day);
        Calendar dayEnd = (Calendar)date1.clone();
        if (req.isInfoEnabled()) {
            req.addInfo("Day mode: " + ((MegogoServiceCost)req.serviceCost).toString());
        }
        Calendar calendar = end = this.calcType == 1 ? ctx.getCurrentDay() : date2;
        if (TimeUtils.dateBefore((Calendar)date2, (Calendar)end)) {
            end = date2;
        }
        BigDecimal cost = BigDecimal.ZERO;
        while (TimeUtils.dateBeforeOrEq((Calendar)day, (Calendar)end)) {
            dayEnd.setTimeInMillis(day.getTimeInMillis());
            dayEnd.add(5, 1);
            dayEnd.add(14, -1);
            assert (TimeUtils.compare((Calendar)day, (Calendar)dayEnd, (int)5) == 0);
            ((MegogoServiceCost)req.serviceCost).date1 = day;
            ((MegogoServiceCost)req.serviceCost).date2 = dayEnd;
            req.setTime(day);
            ((MegogoServiceCost)req.serviceCost).cost = null;
            req.acceptedSetClear();
            super.executeChildren(treeNodeId, (AbstractTariffRequest)req, holder, (TariffContext)ctx, treeContext, workerContext);
            if (((MegogoServiceCost)req.serviceCost).cost != null) {
                int dayMonth = day.get(5);
                if (((MegogoServiceCost)req.serviceCost).unpaidBitSet != null && ((MegogoServiceCost)req.serviceCost).unpaidBitSet.get(dayMonth)) {
                    ((MegogoServiceCost)req.serviceCost).cost = BigDecimal.ZERO;
                }
                if (req.isInfoEnabled()) {
                    req.addInfo(TimeUtils.formatDate((Calendar)day) + "=>" + ((MegogoServiceCost)req.serviceCost).cost);
                }
            } else {
                cost = null;
                break;
            }
            cost = cost.add(((MegogoServiceCost)req.serviceCost).cost);
            day.add(5, 1);
        }
        ((MegogoServiceCost)req.serviceCost).date1 = date1;
        ((MegogoServiceCost)req.serviceCost).date2 = date2;
        ((MegogoServiceCost)req.serviceCost).cost = cost;
        req.setTime(time);
        req.acceptedSetPop(pushed);
        if (cost != null) {
            req.addInfo("process cost=" + cost);
            ((MegogoServiceCost)req.serviceCost).cost = cost;
            if (((MegogoServiceCost)req.serviceCost).amount != 1L && ((MegogoServiceCost)req.serviceCost).cost != null) {
                ((MegogoServiceCost)req.serviceCost).cost = ((MegogoServiceCost)req.serviceCost).cost.multiply(BigDecimal.valueOf(((MegogoServiceCost)req.serviceCost).amount), ctx.mc);
            }
        } else {
            req.addInfo("return cost=" + inCost);
            ((MegogoServiceCost)req.serviceCost).cost = inCost;
        }
    }

    public void monthMode(Long treeNodeId, MegogoTariffRequest req, TariffTreeNodeHolder holder, MegogoTariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        int day1 = ((MegogoServiceCost)req.serviceCost).date1.get(5);
        ((MegogoServiceCost)req.serviceCost).accountingPeriodDays = ((MegogoServiceCost)req.serviceCost).date2.get(5) - day1 + 1;
        req.setTime(((MegogoServiceCost)req.serviceCost).date2);
        ((MegogoServiceCost)req.serviceCost).cost = null;
        super.executeChildren(treeNodeId, (AbstractTariffRequest)req, holder, (TariffContext)ctx, treeContext, workerContext);
    }
}

