/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.action;

import bitel.billing.server.ActionBase;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.localize.Localizer;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class ActionPaymentList
extends ActionBase {
    public void doAction() throws BGException {
        Date from = this.getDateParameter("date1");
        Date until = this.getDateParameter("date2");
        String status = this.getParameter("type", "");
        String mpsId = this.getParameter("system");
        if (mpsId == null || from == null) {
            throw new BGIllegalArgumentException();
        }
        MPSTransactionManager transactionManager = MPSTransactionManager.getInstance(mpsId, this.setup, this.mid);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(Localizer.getDecimalFormatSymbols().getDecimalSeparator());
        DecimalFormat df = new DecimalFormat("########0.00##", dfs);
        if ("text/csv".equals(this.getParameter("contentType"))) {
            SearchResult searchResult = new SearchResult();
            searchResult.setPage(new Page(0, 0));
            searchResult.setPeriod(new Period(from, until));
            transactionManager.searchTransactionList((SearchResult<Transaction>)searchResult, mpsId, -1, status, this.con, this.mid);
            this.request.setAttribute("contentType", (Object)"binary");
            this.response.setContentType("text/csv; charset=UTF-8");
            try {
                String separator = this.moduleSetup.get("mps.save.field.separator", ";");
                PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)this.response.getOutputStream(), "UTF-8"));
                for (Transaction transaction : searchResult.getList()) {
                    w.print(transaction.getId());
                    w.print(separator);
                    w.print(transaction.getTransId());
                    w.print(separator);
                    w.print(TimeUtils.format((Date)transaction.getTime(), (String)"dd.MM.yyyy HH:mm:ss"));
                    w.print(separator);
                    w.print(transaction.getRawNumber());
                    w.print(separator);
                    w.print(df.format(transaction.getSum()));
                    w.print(separator);
                    w.print(transaction.getStatus());
                    w.print(separator);
                    w.print(transaction.getContractTitle());
                    w.print(separator);
                    w.print(transaction.getContractId());
                    w.print(separator);
                    w.print(transaction.getPaymentId());
                    w.print('\n');
                }
                w.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

