/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public final class RapidaOldTransactionManager
extends MPSTransactionManager {
    protected static final Pattern TRANSACTION_PATTERN = Pattern.compile("^pay;(\\d+);(\\d\\d\\.\\d\\d\\.\\d+ \\d\\d:\\d\\d:\\d\\d);(\\d+\\.*\\d*);(.+)$", 8);

    @Override
    protected void checkValid(Conf.MPSSystem system, MPSRequest mpsRequest, Connection con) throws MPSException {
        switch (mpsRequest.getAction()) {
            case 1: {
                if (mpsRequest.getNumber() != null && mpsRequest.getNumber().length() > 0 && mpsRequest.getSum() != null && (system.extDontCheckSum || mpsRequest.getSum().compareTo(BigDecimal.ZERO) > 0) && mpsRequest.getTransId() != null && this.parseBigInteger(mpsRequest.getTransId()).compareTo(BigInteger.ZERO) > 0) break;
                throw new MPSException(2);
            }
            case 2: {
                if (mpsRequest.getNumber() != null && mpsRequest.getNumber().length() > 0 && mpsRequest.getSum() != null && (system.extDontCheckSum || mpsRequest.getSum().compareTo(BigDecimal.ZERO) > 0) && mpsRequest.getTransId() != null && this.parseBigInteger(mpsRequest.getTransId()).compareTo(BigInteger.ZERO) > 0) break;
                throw new MPSException(2);
            }
            default: {
                throw new MPSException(2, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
            }
        }
        super.checkValid(system, mpsRequest, con);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        mpsResponse = new MPSResponse(moduleId, mpsId, response);
        mpsResponse.setResult(0);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            this.checkValid(system, mpsRequest, con);
            mpsResponse.setAction(mpsRequest.getAction());
            mpsResponse.setTransId(mpsRequest.getTransId());
            switch (mpsRequest.getAction()) {
                case 1: {
                    transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction != null) {
                        throw new MPSException(4, "\u041f\u043b\u0430\u0442\u0435\u0436 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c \u0443\u0436\u0435 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d");
                    }
                    contract = this.actionCheck(mpsRequest);
                    mpsResponse.setMessage(this.getComment(system, conf, con, contract));
                    break;
                }
                case 2: 
                case 10: {
                    transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction != null && !transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                        mpsResponse.setResult(1);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0435\u0441\u0442\u044c \u0432 \u0431\u0430\u0437\u0435, \u043d\u043e \u0431\u044b\u043b \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                        break;
                    }
                    if (transaction != null) ** GOTO lbl30
                    contract = this.actionCheck(mpsRequest);
                    this.checkTime(mpsRequest);
                    transaction = this.addTransaction(con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getRawNumber(), mpsRequest.getType(), system.title);
                    mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                    ** GOTO lbl39
lbl30:
                    // 1 sources

                    contractManager = new ContractManager(con);
                    try {
                        contract = contractManager.getContractById(transaction.getContractId());
                    }
                    finally {
                        contractManager.close();
                    }
                    if (contract != null) {
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                    }
lbl39:
                    // 4 sources

                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setSum(transaction.getSum());
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            this.processError(new MPSException(-1), mpsResponse);
            e.printStackTrace();
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        char type;
        MPSRequest req = new MPSRequest(con, moduleId, mpsId, request, system);
        String actionString = request.getParameter("type");
        if ("1".equals(actionString)) {
            req.setAction(1);
        } else if ("2".equals(actionString)) {
            req.setAction(2);
        }
        req.setRawNumber(request.getParameter("id"));
        if (system.osmpPrefix && req.getRawNumber() != null && req.getRawNumber().length() > 1 && (req.getRawNumber().charAt(1) == '_' || req.getRawNumber().charAt(1) == '+') && Character.isDigit((int)(type = req.getRawNumber().charAt(0)))) {
            req.setType(Character.getNumericValue((int)type));
            req.setNumber(req.getRawNumber().substring(2));
        } else {
            req.setNumber(req.getRawNumber());
            req.setType(0);
        }
        req.setSum(Utils.parseBigDecimal((String)request.getParameter("sum"), (BigDecimal)BigDecimal.ZERO));
        req.setTransId(request.getParameter("order"));
        req.setTime(new Date());
        return req;
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 2: {
                response.setResult(1);
                response.setMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
                break;
            }
            case 3: {
                response.setResult(1);
                response.setMessage(ex.message);
                break;
            }
            case 6: {
                response.setResult(1);
                response.setMessage(ex.message);
                break;
            }
            case 8: {
                response.setResult(1);
                response.setMessage("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430");
                break;
            }
            case -1: {
                response.setResult(1);
                response.setMessage("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430");
                break;
            }
            case 9: {
                response.setResult(1);
                response.setMessage(ex.message);
                break;
            }
            case 10: {
                response.setResult(1);
                response.setMessage(ex.message);
                break;
            }
            case 11: {
                response.setResult(1);
                response.setMessage(ex.message);
                break;
            }
            case 4: {
                response.setResult(1);
                response.setMessage(ex.message);
            }
        }
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        Matcher match = TRANSACTION_PATTERN.matcher(file);
        while (match.find()) {
            char type;
            Transaction transaction = new Transaction();
            transaction.setTransId(Utils.parseLong((String)match.group(1), (long)0L));
            transaction.setTime(TimeUtils.parseDate((String)match.group(2), (String)"dd.MM.yyyy HH:mm:ss"));
            String number = match.group(4);
            if (system.osmpPrefix && number != null && number.length() > 1 && number.charAt(1) == '_' && Character.isDigit((int)(type = number.charAt(0)))) {
                transaction.setType(Character.getNumericValue((int)type));
                transaction.setNumber(number.substring(2));
            } else {
                transaction.setNumber(number);
            }
            transaction.setRawNumber(number);
            transaction.setSum(Utils.parseBigDecimal((String)match.group(3), (BigDecimal)BigDecimal.ZERO));
            transaction.setStatus(TransactionStatus.PAYMENT_PAYED.getCode());
            result.add(transaction);
        }
        return result;
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        Document doc = this.documentBuilder.newDocument();
        Element rootNode = XMLUtils.createElement((Document)doc, (String)"results");
        XMLUtils.createElement((Element)rootNode, (String)"code").setTextContent(String.valueOf(response.getResult()));
        XMLUtils.createElement((Element)rootNode, (String)"comments").setTextContent(response.getMessage() != null ? response.getMessage() : "");
        return this.xmlSerialize(doc);
    }

    private class ErrorCode {
        private static final int ANSWER_SUCCESS = 0;
        private static final int ANSWER_FAULT = 1;

        private ErrorCode() {
        }
    }
}

