/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;

public final class SfourAlternativeTransactionManager
extends MPSTransactionManager {
    private static final Pattern patPlus = Pattern.compile("\\+");

    private String enc(String s) throws UnsupportedEncodingException {
        return patPlus.matcher(URLEncoder.encode(s, this.getEncoding())).replaceAll("%20");
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        char type;
        try {
            request.setCharacterEncoding("windows-1251");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        MPSRequest req = new MPSRequest(con, moduleId, mpsId, request, system);
        String[] pathInfo = (String[])request.getAttribute("ru.bitel.bgbilling.modules.mps.server.bean.MPSTransactionManager.PATH_INFO");
        if (pathInfo != null && pathInfo.length >= 4) {
            String actionString = pathInfo[3];
            if ("Pay".equals(actionString)) {
                req.setAction(2);
            } else if ("Check".equals(actionString)) {
                req.setAction(1);
            } else if ("Status".equals(actionString)) {
                req.setAction(3);
            }
        }
        req.setRawNumber(request.getParameter("AccountNumber"));
        if (system.osmpPrefix && req.getRawNumber() != null && req.getRawNumber().length() > 1 && req.getRawNumber().charAt(1) == '_' && Character.isDigit((int)(type = req.getRawNumber().charAt(0)))) {
            req.setType(Character.getNumericValue((int)type));
            req.setNumber(req.getRawNumber().substring(2));
        } else {
            req.setNumber(req.getRawNumber());
            req.setType(Utils.parseInt((String)request.getParameter("AccountType"), (int)0));
        }
        String summString = request.getParameter("Amount");
        req.setSum(Utils.parseBigDecimal((String)summString, (BigDecimal)BigDecimal.ZERO));
        req.setSessionId(request.getParameter("SessionID"));
        String machineMark = request.getParameter("MachineMark");
        String clearingNumber = request.getParameter("ClearingNumber");
        req.setComment(request.getParameter("AccountComment"));
        String hashCode = request.getParameter("Hashcode");
        HashMap parameters = (HashMap)request.getAttribute("ru.bitel.bgbilling.modules.mps.server.bean.MPSTransactionManager.PARAMETERS");
        parameters.put("sessionId", req.getSessionId());
        parameters.put("machineMark", machineMark);
        parameters.put("clearingNumber", clearingNumber);
        req.setTime(new Date());
        try {
            StringBuilder sb = new StringBuilder(100);
            switch (req.getAction()) {
                case 1: {
                    if (req.getNumber() == null || req.getNumber().length() <= 0 || req.getSessionId() == null || machineMark == null || clearingNumber == null || hashCode == null) {
                        throw new MPSException(2);
                    }
                    sb.append(req.getSessionId());
                    sb.append(machineMark);
                    sb.append(clearingNumber);
                    sb.append(req.getRawNumber());
                    if (summString != null) {
                        sb.append(summString);
                    }
                    sb.append(system.secret);
                    break;
                }
                case 2: {
                    if (req.getNumber() == null || req.getNumber().length() <= 0 || req.getSum() == null || !system.extDontCheckSum && req.getSum().compareTo(BigDecimal.ZERO) <= 0 || req.getSessionId() == null || machineMark == null || clearingNumber == null || hashCode == null) {
                        throw new MPSException(2);
                    }
                    sb.append(req.getSessionId());
                    sb.append(machineMark);
                    sb.append(clearingNumber);
                    sb.append(req.getRawNumber());
                    if (req.getComment() != null) {
                        sb.append(req.getComment());
                    }
                    sb.append(summString);
                    sb.append(system.secret);
                    break;
                }
                case 3: {
                    if (req.getSessionId() == null || machineMark == null || clearingNumber == null || hashCode == null) {
                        throw new MPSException(2);
                    }
                    sb.append(req.getSessionId());
                    sb.append(machineMark);
                    sb.append(clearingNumber);
                    sb.append(system.secret);
                    break;
                }
                default: {
                    throw new MPSException(2);
                }
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(sb.toString().getBytes(this.getEncoding()));
            byte[] digestBytes = digest.digest();
            String hash = new String(Base64.encode((byte[])digestBytes));
            if (!hash.equalsIgnoreCase(hashCode)) {
                throw new MPSException(10);
            }
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            throw new MPSException(-1);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new MPSException(-1);
        }
        return req;
    }

    @Override
    protected Contract actionCheck(MPSRequest request) throws MPSException {
        return super.actionCheck(request);
    }

    @Override
    protected void checkValid(Conf.MPSSystem system, MPSRequest req, Connection con) throws MPSException {
        super.checkValid(system, req, con);
    }

    @Override
    public String getDefaultEncoding() {
        return "cp1251";
    }

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        request.setAttribute("ru.bitel.bgbilling.modules.mps.server.bean.MPSTransactionManager.PARAMETERS", parameters);
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        mpsResponse.setParameters(parameters);
        mpsResponse.setResult(0);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            MPSRequest mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            this.checkValid(system, mpsRequest, con);
            mpsResponse.setAction(mpsRequest.getAction());
            switch (mpsRequest.getAction()) {
                case 1: {
                    Contract contract = this.actionCheck(mpsRequest);
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getSessionId(), new Date());
                    if (transaction != null) {
                        throw new MPSException(4, "\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u043e \u0441\u0435\u0441\u0441\u0438\u0438 \u0443\u0436\u0435 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d");
                    }
                    transaction = this.prepareTransaction(con, moduleId, mpsId, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getSessionId(), mpsRequest.getRawNumber(), mpsRequest.getType());
                    mpsResponse.setMessage(this.getComment(system, conf, con, contract));
                    break;
                }
                case 2: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getSessionId(), new Date());
                    if (transaction == null) {
                        mpsResponse.setResult(2);
                        mpsResponse.setMessage("\u0423\u043a\u0430\u0437\u0430\u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0430\u044f \u0441\u0435\u0441\u0441\u0438\u044f");
                        break;
                    }
                    try (ContractManager contractManager = new ContractManager(con);){
                        Contract contract = contractManager.getContractById(transaction.getContractId());
                        if (transaction.getStatus().equals(TransactionStatus.PAYMENT_NOT_PAYED.getCode())) {
                            if (contract == null) {
                                throw new MPSException(3, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                            }
                            this.checkTime(mpsRequest);
                            transaction = this.executePreparedTransaction(con, moduleId, system, transaction, system.title, mpsRequest.getSum());
                        }
                        mpsResponse.setId(transaction.getId());
                        mpsResponse.setMessage(this.getComment(system, conf, con, contract));
                        break;
                    }
                }
                case 3: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getSessionId(), new Date());
                    if (transaction == null) {
                        mpsResponse.setResult(2);
                        mpsResponse.setMessage("\u0423\u043a\u0430\u0437\u0430\u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0430\u044f \u0441\u0435\u0441\u0441\u0438\u044f");
                        break;
                    }
                    try (ContractManager contractManager = new ContractManager(con);){
                        Contract contract = contractManager.getContractById(transaction.getContractId());
                        if (transaction.getStatus().equals(TransactionStatus.PAYMENT_NOT_PAYED.getCode())) {
                            mpsResponse.setResult(1);
                            mpsResponse.setMessage("\u0421\u0435\u0441\u0441\u0438\u044f \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
                        }
                        mpsResponse.setId(transaction.getId());
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                        break;
                    }
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            this.processError(new MPSException(-1), mpsResponse);
            e.printStackTrace();
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        StringBuilder sb = new StringBuilder(150);
        try {
            String clearingNumber;
            String sessionId;
            StringBuilder hashBase = new StringBuilder(100);
            if (response.getAction() == 1 || response.getAction() == 10) {
                sessionId = (String)response.getParameters().get("sessionId");
                clearingNumber = (String)response.getParameters().get("clearingNumber");
                if (sessionId != null) {
                    sb.append("SessionID=").append(this.enc(sessionId)).append('&');
                    hashBase.append(sessionId);
                }
                sb.append("ErrorCode=").append(response.getResult()).append('&');
                hashBase.append(response.getResult());
                if (clearingNumber != null) {
                    sb.append("ClearingNumber=").append(this.enc(clearingNumber)).append('&');
                    hashBase.append(clearingNumber);
                }
            } else if (response.getAction() == 2) {
                sessionId = (String)response.getParameters().get("sessionId");
                clearingNumber = (String)response.getParameters().get("clearingNumber");
                if (sessionId != null) {
                    sb.append("SessionID=").append(this.enc(sessionId)).append('&');
                    hashBase.append(sessionId);
                }
                sb.append("ErrorCode=").append(response.getResult()).append('&');
                hashBase.append(response.getResult());
                if (clearingNumber != null) {
                    sb.append("ClearingNumber=").append(this.enc(clearingNumber)).append('&');
                    hashBase.append(clearingNumber);
                }
            } else if (response.getAction() == 3) {
                sessionId = (String)response.getParameters().get("sessionId");
                clearingNumber = (String)response.getParameters().get("clearingNumber");
                if (sessionId != null) {
                    sb.append("SessionID=").append(this.enc(sessionId)).append('&');
                    hashBase.append(sessionId);
                }
                sb.append("ErrorCode=").append(response.getResult()).append('&');
                hashBase.append(response.getResult());
                if (clearingNumber != null) {
                    sb.append("ClearingNumber=").append(this.enc(clearingNumber)).append('&');
                    hashBase.append(clearingNumber);
                }
            } else {
                sessionId = (String)response.getParameters().get("sessionId");
                clearingNumber = (String)response.getParameters().get("clearingNumber");
                if (sessionId != null) {
                    sb.append("SessionID=").append(this.enc(sessionId)).append('&');
                    hashBase.append(sessionId);
                }
                sb.append("ErrorCode=").append(response.getResult()).append('&');
                hashBase.append(response.getResult());
                if (clearingNumber != null) {
                    sb.append("ClearingNumber=").append(this.enc(clearingNumber)).append('&');
                    hashBase.append(clearingNumber);
                }
            }
            if (system.extSfourComment && response.getResult() == 0 && response.getMessage() != null) {
                sb.append("AccountComment=").append(this.enc(response.getMessage())).append('&');
                hashBase.append(response.getMessage());
            }
            hashBase.append(system.secret);
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(hashBase.toString().getBytes(this.getEncoding()));
            byte[] digestBytes = digest.digest();
            String hash = new String(Base64.encode((byte[])digestBytes));
            sb.append("Hashcode=").append(this.enc(hash));
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sb.toString().getBytes();
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 2: {
                response.setResult(9);
                response.setMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
                break;
            }
            case 3: {
                response.setResult(12);
                response.setMessage(ex.message);
                break;
            }
            case 6: {
                response.setResult(300);
                response.setMessage(ex.message);
                break;
            }
            case 8: {
                response.setResult(301);
                response.setMessage("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430");
                break;
            }
            case -1: {
                response.setResult(10);
                response.setMessage("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430");
                break;
            }
            case 9: {
                response.setResult(10);
                response.setMessage(ex.message);
                break;
            }
            case 10: {
                response.setResult(8);
                response.setMessage(ex.message);
                break;
            }
            case 4: {
                response.setResult(1);
                response.setMessage(ex.message);
                break;
            }
            case 20: {
                response.setResult(7);
                response.setMessage(ex.message);
            }
        }
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        return null;
    }

    private static final class ErrorCode {
        protected static final int ANSWER_SUCCESS = 0;
        protected static final int ANSWER_ERR_SESSION_EXIST = 1;
        protected static final int ANSWER_ERR_SESSION_NOT_FOUND = 2;
        protected static final int ANSWER_ERR_TERMINAL_NOT_REGISTERED = 3;
        protected static final int ANSWER_ERR_CONTRAGENT_NOT_REGISTERED = 4;
        protected static final int ANSWER_ERR_TERMINAL_CONTRAGENT_ERROR = 5;
        protected static final int ANSWER_ERR_TERMINAL_BLOCKED = 6;
        protected static final int ANSWER_ERR_OUT_OF_MONEY = 7;
        protected static final int ANSWER_ERR_HASH = 8;
        protected static final int ANSWER_ERR_REQUEST = 9;
        protected static final int ANSWER_ERR_SERVER = 10;
        protected static final int ANSWER_ERR_GATE_UNACCESSABLE = 11;
        protected static final int ANSWER_ERR_CONTRACT_NOT_FOUND = 12;
        protected static final int ANSWER_ERR_DATE = 300;
        protected static final int ANSWER_ERR_AMOUNT_ERROR = 301;

        private ErrorCode() {
        }
    }
}

