/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.AbstractTransactionPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.modules.mps.client.TransactionTableModel;
import ru.bitel.bgbilling.modules.mps.common.service.MPSService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.SearchResult;

public class TransactionPanel
extends AbstractTransactionPanel {
    protected BGComboBox<ComboBoxItem> systemComboBox = new BGComboBox();
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            AbstractTransactionStatus status = (AbstractTransactionStatus)TransactionPanel.this.statusComboBox.getSelectedItem();
            String systemId = ((ComboBoxItem)TransactionPanel.this.systemComboBox.getSelectedItem()).getObject().toString();
            SearchResult searchResult = ((MPSService)((ClientContext)TransactionPanel.this.getContext()).getPort(MPSService.class)).searchTransactions(((ClientContext)TransactionPanel.this.getContext()).getContractId(), systemId, status.getCode(), TransactionPanel.this.periodPanel.getPeriod(), TransactionPanel.this.pagePanel.getPage());
            ((TransactionTableModel)TransactionPanel.this.transactionModel).setData(searchResult.getList());
            TransactionPanel.this.pagePanel.setPage(searchResult.getPage());
            TransactionPanel.this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            TransactionPanel.this.summaField.setText(new DecimalFormat("###,###,##0.00").format(searchResult.getSum()));
        }
    };

    public TransactionPanel() {
        try {
            String[] systemListData = ((MPSService)((ClientContext)this.getContext()).getPort(MPSService.class)).getMPSSystemList();
            this.systemComboBox.addItem((Object)new ComboBoxItem(0, "-----"));
            for (int i = 0; i < systemListData.length; i += 2) {
                this.systemComboBox.addItem((Object)new ComboBoxItem(Utils.parseInt((String)systemListData[i]), systemListData[i + 1]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected JPanel getExtraFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0421\u0438\u0441\u0442\u0435\u043c\u0430: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.systemComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    protected void initListeners() {
        if (this.systemComboBox.getItemCount() > 0) {
            this.systemComboBox.setSelectedIndex(0);
        }
        this.systemComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    TransactionPanel.this.pagePanel.setPageIndex(1);
                    TransactionPanel.this.performAction("refresh");
                }
            }
        });
        super.initListeners();
    }
}

