<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="layout.xsl"/>

<xsl:template name="title">
<xsl:choose>
	<xsl:when test="data/@action = 'MPS'">Список платежей</xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template match="/data">
<xsl:if test="@action = 'MPS'">
	<xsl:call-template name="MPS"/>
</xsl:if>
</xsl:template>

<xsl:template name="MPS">

	<div class="bgMonthAndYearWidget">
		<xsl:attribute name="month"><xsl:value-of select="/data/@month"/></xsl:attribute>
		<xsl:attribute name="year"><xsl:value-of select="/data/@year"/></xsl:attribute>
		<xsl:attribute name="query"><xsl:value-of select="$WEBEXECUTER"/>?action=<xsl:value-of select="/data/@action"/>&amp;module=<xsl:value-of select="/data/@module"/>&amp;mid=<xsl:value-of select="/data/@mid"/></xsl:attribute></div>

	<table class="table800">
		<thead>
		  <tr>
			<td nowrap="nowrap">Ввнешний ID</td>
			<td nowrap="nowrap">Внутренний ID</td>
			<td>Дата/время ПС</td>
			<td>Дата/время оплаты</td>
			<td>Сумма</td>
			<td>Комментарий</td>
			<td>Статус</td>
		</tr>
		</thead>
		<tbody>
		  <xsl:for-each select="payments/payment">
			<tr>
				<td nowrap="nowrap"><xsl:value-of select="@trans_id"/></td>
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@time"/></td>
				<td><xsl:value-of select="@local_time"/></td>
				<td><xsl:value-of select="@summ"/></td>
				<td><xsl:value-of select="@comment"/></td>
				<td><xsl:choose><xsl:when test="@status = 1">проведен</xsl:when><xsl:otherwise>отменен</xsl:otherwise></xsl:choose></td>
			</tr>		
		  </xsl:for-each>
		</tbody>
	</table>
	<br/>
	<xsl:if test="/data/@mps_login = 1">
	<form name="change_login" method="post" action="{$WEBEXECUTER}">
		<xsl:call-template name="action"/>
		<input type="hidden" name="y" value="{/data/@curr_year}"/>
		<input type="hidden" name="m" value="{/data/@curr_month}"/>
		<table class="filter" cellspacing="0">
			<tr>
			<td nowrap="nowrap">Номер для поиска договора в платежных системах:</td>
			<td><input type="text" size="9" name="login" value="{login/@login}" /></td>
			<td>
				<xsl:call-template name="submit">
					<xsl:with-param name="title" select="'Сменить'"/>
				</xsl:call-template>
			</td>
			</tr>
		</table>
	</form>
</xsl:if>
</xsl:template>

</xsl:stylesheet>