/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.news.server.bean;

import java.io.StringReader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.plugins.news.common.bean.News;
import ru.bitel.bgbilling.plugins.news.server.event.NewsModifiedEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public final class NewsManager
extends AbstractIdDao<News> {
    private static final Logger logger = LogManager.getLogger();
    private static Boolean needReload = true;
    private static Object mutex = new Object();
    private static final Map<Integer, List<News>> newsDocumentMap = new HashMap<Integer, List<News>>();

    public NewsManager(Connection con) {
        super(con, 0, "news");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(int id) throws BGException {
        int result = super.delete(id);
        Object object = mutex;
        synchronized (object) {
            needReload = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateImpl(News news) throws BGException, SQLException {
        Document doc;
        if (news.getBody().trim().startsWith("<data") && (doc = XMLUtils.parseDocument((InputSource)new InputSource(new StringReader(news.getBody())))) == null) {
            throw new BGException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 xml \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442!");
        }
        boolean update = news.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET dt=?, title=?, txt=?, label_ids=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)news.getDate()));
            ps.setString(index++, news.getTitle());
            ps.setString(index++, news.getBody());
            ps.setString(index++, Utils.toString((Iterable)news.getContractLabelIds()));
            if (update) {
                ps.setInt(index++, news.getId());
            }
            ps.executeUpdate();
            Object object = mutex;
            synchronized (object) {
                needReload = true;
            }
            if (!update) {
                news.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<News> getNewsList(List<Integer> labelIds, Page page) throws BGException {
        return super.list(page, null, "dt DESC", new Object[0]).getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<News> getNewsList(Setup setup, Page page, List<Integer> labelIds) {
        logger.debug("needReload = {}", (Object)needReload);
        if (needReload.booleanValue()) {
            Object object = mutex;
            synchronized (object) {
                if (needReload.booleanValue()) {
                    NewsManager.newsReload(setup);
                    needReload = false;
                }
            }
        }
        ArrayList<News> newsList = new ArrayList<News>();
        if (labelIds != null) {
            logger.debug("labelIds = {}", (Object)Utils.toString(labelIds));
            for (int id : labelIds) {
                List<News> list = newsDocumentMap.get(id);
                if (list == null) continue;
                for (News news : list) {
                    if (newsList.contains(news)) continue;
                    newsList.add(news);
                }
            }
        }
        logger.debug("newsList.size() = {}", (Object)newsList.size());
        Collections.sort(newsList);
        Collections.reverse(newsList);
        if (page != null) {
            page.setRecordCount(newsList.size());
            if (page.getPageIndex() > 1) {
                int i = page.getPageSize() * (page.getPageIndex() - 1);
                while (i-- > 0) {
                    newsList.remove(0);
                }
            }
            while (newsList.size() > page.getPageSize()) {
                newsList.remove(page.getPageSize());
            }
        }
        return newsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void newsReload(Setup setup) {
        Connection con = setup.getDBConnectionFromPool();
        String query = "SELECT * FROM news WHERE dt <= now()";
        try (Statement st = con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            Map<Integer, List<News>> map = newsDocumentMap;
            synchronized (map) {
                newsDocumentMap.clear();
                while (rs.next()) {
                    News news = new News();
                    news.setId(rs.getInt("id"));
                    news.setContractLabelIds(Utils.toIntegerList((String)rs.getString("label_ids")));
                    news.setDate((java.util.Date)rs.getTimestamp("dt"));
                    news.setTitle(rs.getString("title"));
                    news.setBody(rs.getString("txt"));
                    Iterator iterator = news.getContractLabelIds().iterator();
                    while (iterator.hasNext()) {
                        int id = (Integer)iterator.next();
                        List<News> newsList = newsDocumentMap.get(id);
                        if (newsList == null) {
                            newsList = new ArrayList<News>();
                            newsDocumentMap.put(id, newsList);
                        }
                        newsList.add(news);
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("newsDocumentMap:");
                for (Integer id : newsDocumentMap.keySet()) {
                    logger.debug("\tlabelId = {}, news.size() = {}", (Object)id, (Object)newsDocumentMap.get(id).size());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    public List<News> list(Page page) throws BGException {
        return super.list(page, null, "dt DESC", new Object[0]).getList();
    }

    public void search(SearchResult<News> searchResult) throws BGException {
        Objects.requireNonNull(searchResult);
        Page page = searchResult.getPage();
        List news = searchResult.getList();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + page.sqlLimit();
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    news.add(this.getFromRS(rs));
                }
            }
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected News getFromRS(ResultSet rs) throws SQLException, BGException {
        News result = new News();
        result.setId(rs.getInt("id"));
        result.setDate(TimeUtils.convertSqlDateToDate((Date)rs.getDate("dt")));
        result.setContractLabelIds(Utils.toIntegerList((String)rs.getString("label_ids")));
        result.setTitle(rs.getString("title"));
        result.setBody(rs.getString("txt"));
        return result;
    }

    static {
        try {
            EventProcessor.getInstance().addListener((EventListener)new EventListener<NewsModifiedEvent>(){

                public void notify(NewsModifiedEvent e, EventListenerContext ctx) throws BGException {
                    needReload = true;
                }
            }, NewsModifiedEvent.class);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }
}

