/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server;

import bitel.billing.server.ModuleBase;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractStatus;
import bitel.billing.server.contract.bean.ContractStatusManager;
import bitel.billing.server.contract.object.bean.ModuleEntity;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.CommonEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWebMessagesEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ObjectMoveEvent;
import ru.bitel.bgbilling.kernel.event.events.system.SystemLimitChangedEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.server.Recalculator;
import ru.bitel.bgbilling.modules.npay.server.bean.DebetStatusManageConfig;
import ru.bitel.bgbilling.modules.npay.server.bean.object.ServiceObjectManager;
import ru.bitel.bgbilling.modules.npay.server.event.DebetStatusManageAfterOpen;
import ru.bitel.bgbilling.modules.npay.server.utils.NpayUtils;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.XMLDatabaseSerializer;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class Module
extends ModuleBase {
    private static final Logger log = LogManager.getLogger();
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.npay"};

    public void serializeContract(Connection con, int cid, int mid, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
        String tableName = "npay_service_object_" + mid;
        String query = "SELECT service_object.*, service.title FROM " + tableName + " as service_object LEFT JOIN service ON service.id=service_object.sid WHERE cid=" + cid;
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery(query);
        new XMLDatabaseSerializer(tables).addItemsFromRS(tableName, null, null, rs);
        st.close();
    }

    public void start(Connection con, final BGModule module) throws BGException {
        super.start(con, module);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<ContractBalanceChangedEvent>(){

            public void notify(ContractBalanceChangedEvent e, EventListenerContext ctx) throws BGException {
                Module.this.unlockDebetStatus(module, (Event)e, ctx);
            }
        }, ContractBalanceChangedEvent.class);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<SystemLimitChangedEvent>(){

            public void notify(SystemLimitChangedEvent e, EventListenerContext ctx) throws BGException {
                Module.this.unlockDebetStatus(module, (Event)e, ctx);
            }
        }, SystemLimitChangedEvent.class);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<ContractWebMessagesEvent>(){

            public void notify(ContractWebMessagesEvent contractWebMessagesEvent, EventListenerContext ctx) throws BGException {
                int moduleId = module.getId();
                int contractId = contractWebMessagesEvent.getContractId();
                Connection con = ctx.getConnection();
                ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
                String status = Module.this.getStatus(con, moduleId, contractId);
                if (Utils.notBlankString((String)status)) {
                    contractWebMessagesEvent.addMessage(moduleSetup.get("web.message.contract.open.summ", "\u0421\u0443\u043c\u043c\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430\u044f \u0434\u043b\u044f \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: ${status}").replaceAll("\\$\\{status\\}", status));
                }
            }
        }, ContractWebMessagesEvent.class);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<CommonEvent>(){

            public void notify(CommonEvent e, EventListenerContext ctx) throws BGException {
                boolean flag;
                boolean bl = flag = e.getParameter("phone_abon") != null;
                if (flag) {
                    int cidNew = Integer.valueOf(String.valueOf(e.getParameter("cidNew")));
                    int entityMid = Integer.valueOf(String.valueOf(e.getParameter("entityMid")));
                    int entityIdOld = Integer.valueOf(String.valueOf(e.getParameter("entityIdOld")));
                    int entityIdNew = Integer.valueOf(String.valueOf(e.getParameter("entityIdNew")));
                    Date dateOpen = (Date)e.getParameter("dateOpen");
                    Date dateClose = (Date)e.getParameter("dateClose");
                    ServiceObjectManager sm = new ServiceObjectManager(ctx.getConnection(), module.getId());
                    try {
                        for (ServiceObject serviceObject : sm.getServiceObjectList(e.getContractId(), 0, entityMid, entityIdOld)) {
                            sm.wrapContractSevice(serviceObject, cidNew, serviceObject.getObjectId(), entityIdNew, 0, dateClose, dateOpen);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }, CommonEvent.class);
    }

    private void unlockDebetStatus(BGModule module, Event e, EventListenerContext ctx) throws BGException {
        DebetStatusManageConfig config;
        int moduleId = module.getId();
        int contractId = e.getContractId();
        log.debug("Process unlockDebetStatus contractId:" + contractId + "; event:" + e.toString());
        Connection con = ctx.getConnection();
        BigDecimal unlockLimit = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId)).getBigDecimal("debet.npay.unlock.balance.limit", BigDecimal.ZERO);
        if (unlockLimit.compareTo(BigDecimal.ZERO) > 0) {
            try (BalanceUtils bu = new BalanceUtils(con);){
                if (bu.getBalance(new Date(), contractId).compareTo(unlockLimit) < 0) {
                    return;
                }
            }
        }
        if ((config = new DebetStatusManageConfig((Preferences)Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId)))).isEnable()) {
            ContractManager contractManager = new ContractManager(con);
            ContractLabelManager contractLabelManager = new ContractLabelManager(con);
            ContractStatusManager contractStatusManager = new ContractStatusManager(con);
            Contract contract = this.unlockDebetStatus(con, moduleId, contractId, config, contractManager, contractStatusManager, contractLabelManager);
            if (config.isProcessDependentSub()) {
                HashSet<Integer> processedCids = new HashSet<Integer>();
                processedCids.add(contract.getId());
                if (contract.isSub()) {
                    contract = this.unlockDebetStatus(con, moduleId, contract.getSuperId(), config, contractManager, contractStatusManager, contractLabelManager);
                }
                List cids = Utils.toIntegerList((String)contract.getDependSubList());
                Collections.sort(cids);
                for (Integer subContractId : cids) {
                    if (!processedCids.add(subContractId)) continue;
                    this.unlockDebetStatus(con, moduleId, subContractId, config, contractManager, contractStatusManager, contractLabelManager);
                }
            }
            contractManager.recycle();
            contractStatusManager.recycle();
        }
    }

    private Contract unlockDebetStatus(Connection con, int moduleId, int contractId, DebetStatusManageConfig config, ContractManager contractManager, ContractStatusManager statusManager, ContractLabelManager contractLabelManager) throws BGException {
        BigDecimal unlockSumm;
        Contract contract = contractManager.getContractById(contractId);
        List contractLabelIds = contractLabelManager.getContractLabelIds(contractId);
        if (!(contract.getDateTo() != null && !TimeUtils.dateBefore((Date)new Date(), (Date)contract.getDateTo()) || !config.isEnableForContractLabelIds(contractLabelIds) || config.isCheckServiceObjectList() && new ServiceObjectManager(con, moduleId).getServiceObjectList(contractId, null).size() <= 0 || (unlockSumm = config.getSummaForUnlock(con, moduleId, contract)) == null || unlockSumm.compareTo(BigDecimal.ZERO) != 0)) {
            ContractStatus status = new ContractStatus();
            status.setContractId(contractId);
            status.setStatus(config.getNextStatus(contract.getStatus()));
            status.setDateFrom(new Date());
            status.setDateTo(null);
            status.setComment("\u0420\u0430\u0437\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d \u043c\u043e\u0434\u0443\u043b\u0435\u043c \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442 \u043f\u043e \u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e\u043c\u0443 \u043f\u043b\u0430\u0442\u0435\u0436\u0443");
            statusManager.changeStatus(status, Integer.valueOf(0), true);
            Recalculator recalc = new Recalculator(moduleId, new GregorianCalendar(), "", config.getServiceSet(), String.valueOf(contractId), "");
            recalc.init(Setup.getSetup());
            recalc.run();
            EventProcessor.getInstance().publish((Event)new DebetStatusManageAfterOpen(moduleId, contractId));
        }
        return contract;
    }

    public void moduleAction(ServerContext ctx, int mid, Event event) throws Exception {
        super.moduleAction(ctx, mid, event);
        int cid = event.getContractId();
        try {
            if (event instanceof ContractCloseEvent) {
                ContractCloseEvent ccEvent = (ContractCloseEvent)event;
                Connection con = ctx.getConnection();
                ServiceObjectManager sm = new ServiceObjectManager(con, mid);
                if (ccEvent.isCheck()) {
                    for (ServiceObject object : sm.getServiceObjectList(cid, 0, -1, -1)) {
                        if (object.getDate1() != null) continue;
                        ccEvent.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435, \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0430 " + object.getServiceTitle() + " \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0434\u0430\u0442\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f.");
                        return;
                    }
                } else {
                    boolean didUpdate = false;
                    for (ServiceObject object : sm.getServiceObjectList(cid, 0, -1, -1)) {
                        if (object.getDate2() != null && !object.getDate2().after(ccEvent.getDate())) continue;
                        object.setDate2(ccEvent.getDate());
                        sm.updateServiceObject(object);
                        didUpdate = true;
                    }
                    if (didUpdate) {
                        int recalcOnServiceChange = Setup.getSetup().getModuleSetup(Integer.valueOf(mid)).getInt("recalculate.on.service.change", 0);
                        this.recalculate(recalcOnServiceChange, ccEvent.getDate(), "" + cid, mid, con, "\u041f\u0435\u0440\u0435\u0440\u0430\u0441\u0447\u0435\u0442 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u044b \u043f\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                    }
                }
            } else if (event instanceof ContractWrapEvent) {
                ContractWrapEvent cwEvent = (ContractWrapEvent)event;
                Connection con = ctx.getConnection();
                ServiceObjectManager sm = new ServiceObjectManager(con, mid);
                if (cwEvent.isCheck()) {
                    for (ServiceObject object : sm.getServiceObjectList(cid, 0, 0, 0)) {
                        if (object.getDate1() != null) continue;
                        cwEvent.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435, \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0430 " + object.getServiceTitle() + " \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0434\u0430\u0442\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f.");
                        return;
                    }
                } else {
                    for (ServiceObject serviceObject : sm.getServiceObjectList(cid, 0, 0, 0)) {
                        Integer objectId = (Integer)cwEvent.getObjectMap().get(serviceObject.getObjectId());
                        if (objectId == null) {
                            objectId = 0;
                        }
                        int newEntityId = 0;
                        if (serviceObject.getEntityId() > 0) {
                            newEntityId = cwEvent.getNewEntityId(serviceObject.getEntityMid(), serviceObject.getEntityId());
                        }
                        sm.wrapContractSevice(serviceObject, cwEvent.getToContractId(), objectId, newEntityId, 0, cwEvent.getDateClose(), cwEvent.getDateOpen());
                    }
                    this.recalculate(1, cwEvent.getDateClose(), cid + "," + cwEvent.getToContractId(), mid, con, "\u041f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u044b");
                }
            } else if (event instanceof ContractDeleteEvent) {
                ContractDeleteEvent cdEvent = (ContractDeleteEvent)event;
                Connection con = ctx.getConnection();
                if (!cdEvent.isCheck()) {
                    String tableName = "npay_service_object_" + mid;
                    String query = "DELETE FROM " + tableName + " WHERE cid=" + cid;
                    Statement st = con.createStatement();
                    st.executeUpdate(query);
                    st.close();
                }
            } else if (event instanceof ObjectMoveEvent) {
                Connection con = ctx.getConnection();
                String tableName = "npay_service_object_" + mid;
                String query = "UPDATE " + tableName + " SET oid=0 WHERE oid=?";
                PreparedStatement psUpdate = con.prepareStatement(query);
                psUpdate.setInt(1, ((ObjectMoveEvent)event).getObjectId());
                psUpdate.executeUpdate();
                psUpdate.close();
            } else if (event instanceof ContractCreateEvent) {
                Element addDocuments;
                Document dataDoc;
                ContractCreateEvent ccEvent = (ContractCreateEvent)event;
                Connection con = ctx.getConnection();
                if (!ccEvent.isCheck() && (dataDoc = ccEvent.getPattern().getData()) != null && (addDocuments = XMLUtils.selectElement((Node)dataDoc, (String)("data/modules/npay[@mid=" + mid + "]/addServices"))) != null) {
                    ServiceObjectManager serviceObjectManager = new ServiceObjectManager(con, mid);
                    NodeList nodes = addDocuments.getElementsByTagName("item");
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Element item = (Element)nodes.item(i);
                        ServiceObject service = new ServiceObject();
                        service.setContractId(cid);
                        service.setDate1(ccEvent.getDateFrom());
                        service.setDate2(ccEvent.getDateTo());
                        service.setServiceId(Utils.parseInt((String)item.getAttribute("sid")));
                        service.setComment("");
                        if (service.getServiceId() <= 0) continue;
                        serviceObjectManager.updateServiceObject(service);
                    }
                }
            } else if (event instanceof CommonEvent) {
                CommonEvent comEvent = (CommonEvent)event;
                Connection con = ctx.getConnection();
                if (comEvent.getParameter("objectDeleted") != null) {
                    String tableName = "npay_service_object_" + mid;
                    String query = "DELETE FROM " + tableName + " WHERE ";
                    query = query + " cid = ? ";
                    query = query + " AND emid = ? ";
                    query = query + " AND eid = ? ";
                    PreparedStatement psUpdate = con.prepareStatement(query);
                    psUpdate.setInt(1, comEvent.getContractId());
                    psUpdate.setInt(2, (Integer)comEvent.getParameter("objectMid"));
                    psUpdate.setInt(3, (Integer)comEvent.getParameter("objectId"));
                    psUpdate.executeUpdate();
                    psUpdate.close();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void recalculate(int recalcOnServiceChange, Date date, String cids, int mid, Connection con, String comment) {
        if (recalcOnServiceChange < 1 || recalcOnServiceChange > 2) {
            return;
        }
        TreeSet<Calendar> monthsForRecalc = new TreeSet<Calendar>();
        monthsForRecalc.add(Calendar.getInstance());
        if (recalcOnServiceChange == 1) {
            Calendar cal = TimeUtils.convertDateToCalendar((Date)date);
            GregorianCalendar now = new GregorianCalendar();
            while (TimeUtils.monthsDelta((Calendar)cal, (Calendar)now) > 0) {
                monthsForRecalc.add((Calendar)cal.clone());
                cal.add(2, 1);
            }
        }
        for (Calendar month : monthsForRecalc) {
            Recalculator recalculator = new Recalculator(mid, month, null, 0, cids, comment);
            recalculator.init(Setup.getSetup());
            recalculator.executeTask();
        }
    }

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public List<ModuleEntity> getObjectEntities(Connection con, int mid, int objectId) throws BGException {
        ArrayList<ModuleEntity> result = new ArrayList<ModuleEntity>();
        try {
            ServiceObjectManager manager = new ServiceObjectManager(con, mid);
            for (ServiceObject object : manager.getServiceObjectListForObject(objectId)) {
                ModuleEntity entity = new ModuleEntity();
                entity.setName("\u0410\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0430");
                entity.setData(object.getServiceTitle());
                entity.setPeriod(TimeUtils.formatPeriod((Date)object.getDate1(), (Date)object.getDate2()));
                result.add(entity);
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public String getStatus(Connection con, int moduleId, int contractId) throws BGException {
        String result = "";
        BigDecimal unlockAmount = NpayUtils.getAmountForUnlock(con, moduleId, contractId);
        if (unlockAmount != null) {
            result = Utils.formatBigDecimalSumm((BigDecimal)unlockAmount);
        }
        return result;
    }
}

