/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.action;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.npay.server.bean.object.ServiceObjectManager;
import ru.bitel.common.TimeUtils;

public class ActionServiceObjectTable
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        if (this.cid <= 0 || this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        int objectId = this.getIntParameter("object_id", 0);
        int entityMid = this.getIntParameter("entityMid", 0);
        int entityId = this.getIntParameter("entityId", 0);
        boolean actualItemsOnly = this.getBooleanParameter("actualItemsOnly", true);
        Date actualItemsDate = this.getDateParameter("actualItemsDate");
        List<ServiceObject> list = actualItemsOnly && actualItemsDate != null ? new ServiceObjectManager(this.con, this.mid).getServiceObjectList(this.cid, objectId, entityMid, entityId, actualItemsDate) : new ServiceObjectManager(this.con, this.mid).getServiceObjectList(this.cid, objectId, entityMid, entityId);
        for (ServiceObject serviceObject : list) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(serviceObject.getId()));
            row.setAttribute("col", String.valueOf(serviceObject.getCol()));
            row.setAttribute("sid", String.valueOf(serviceObject.getServiceId()));
            row.setAttribute("service", serviceObject.getServiceTitle());
            row.setAttribute("period", TimeUtils.formatPeriod((Date)serviceObject.getDate1(), (Date)serviceObject.getDate2()));
            row.setAttribute("date1", TimeUtils.formatDate((Date)serviceObject.getDate1()));
            row.setAttribute("date2", TimeUtils.formatDate((Date)serviceObject.getDate2()));
            row.setAttribute("objectId", String.valueOf(serviceObject.getObjectId()));
            row.setAttribute("object", serviceObject.getObjectTitle());
            row.setAttribute("comment", serviceObject.getComment());
        }
    }
}

